<?php
header('Content-Type: application/json');
include('config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     if(isset($_POST['username']) && isset($_POST['password'])){
        $username = $_POST['username'];
        $password = $_POST['password'];
    
   
        $stmt = $con->prepare("SELECT password FROM tbl_login WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();
    
        // Check if user exists
        if ($stmt->num_rows > 0) {
            $stmt->bind_result($hashed_password);
            $stmt->fetch();
    
            // Verify the password
            if (password_verify($password, $hashed_password)) {
                $response = [
                    'error' => true,
                    'code' => 200,
                    'error' => 'Login successful! Welcome, '.$username,
                ];
            } else {
                $response = [
                    'error' => true,
                    'code' => 201,
                    'error' => 'Invalid password.',
                ];
            }
        } else {
            $response = [
                'error' => true,
                'code' => 201,
                'error' => 'No user found with that username.',
            ];
            
        }
        $stmt->close();
        
        
    }else{
        $response = [
            'error' => true,
            'code' => 201,
            'error' => 'Username or password missing',
        ];
    }
}else{
    $response = [
        'error' => true,
        'code' => 201,
        'error' => 'Invalid Request method',
    ];
}
echo json_encode($response);
?>