<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\Template;
use App\Http\Controllers\APIController;

class WhatsUpTemplateController extends Controller {
    private $apiController;
    
    public function __construct(APIController $apiController) {
        $this->apiController = $apiController;
    }

    public function getTemplateList(Request $request)
    {
        try {
            $result = DB::table('tbl_template as t1')->where('deleteFlag',0)->get();
           
            $result = $result->toArray();
    
            // Get the total record count
            // $totalCount = $result->count();
    
           
            return response()->json([
                'code' => 200,
                'message' => "Agency fetched successfully",
                'data' => $result,
                // 'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function submitTemplateList(Request $request) {
        try {
            $templateData = $request->id ? Template::find($request->id) : new Template();
            $templateData->template_title = $request->template_title;
            $templateData->template_content = $request->template_content;
            $templateData->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully"
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data"
            ]);
        }
    }
    
    public function deleteTemplatelist(Request $request) {
        try {
                $templateData = Template::where('id', $request->id)
                  ->update(['deleteFlag' => 1]);
           
                return response()->json([
                    'code' => 200,
                    'message' => "template list deleted successfully"
                ]);
        } catch (\Exception $e) {
           
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting"
            ]);
        }
       
    }
    
 
}
