<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\UserMenuPermission;
use App\Models\UserActionPermission;

class UserManagement extends Controller
{
    public function getMenu(Request $request) {
        if ($request->designation_id) {
          $parentMenu = DB::table('tbl_user_menu_permission as tump')
                        ->leftJoin('tbl_menu as tm', 'tm.id', '=', 'tump.menu_id')
                        ->where('tump.designation_id', $request->designation_id)
                        ->where('tm.parent_id', 0)
                        ->where('tm.is_active', true)
                        ->orderBy('tm.menu_order', 'asc')
                        ->get()->toArray();

          $childMenu = DB::table('tbl_user_menu_permission as tump')
                        ->leftJoin('tbl_menu as tm', 'tm.id', '=', 'tump.menu_id')
                        ->where('tump.designation_id', $request->designation_id)
                        ->where('parent_id', '!=', 0)
                        ->where('is_subchild', 0)
                        ->where('is_active', true)
                        ->orderBy('menu_order', 'asc')
                        ->get()->toArray();

          $subchildMenu = DB::table('tbl_user_menu_permission as tump')
                          ->leftJoin('tbl_menu as tm', 'tm.id', '=', 'tump.menu_id')
                          ->where('tump.designation_id', $request->designation_id)
                          ->where('is_subchild', 1)
                          ->where('is_active', true)
                          ->orderBy('menu_order', 'asc')
                          ->get()->toArray();

          $isChildMenu = DB::table('tbl_user_menu_permission as tump')
                        ->leftJoin('tbl_menu as tm', 'tm.id', '=', 'tump.menu_id')
                        ->where('tump.designation_id', $request->designation_id)
                        ->where('parent_id', '!=', 0)
                        ->where('is_subchild', 0)
                        ->where('is_active', true)
                        ->orderBy('menu_order', 'asc')
                        ->get()->pluck('parent_id')->toArray();

          if ($request->designation_id == 1551997) {
            $getAllMenuAction = DB::table('tbl_menu_action')->get()->pluck('action', 'menu_id')->toArray();
          } else {
            $getAllMenuAction = DB::table('tbl_menu_action_permission as tmap')
                          ->where('tmap.designation_id', $request->designation_id)
                          ->get()->pluck('action', 'menu_id')->toArray();
          }


          // dd($parentMenu);
        
          // Create Main Menu Array
          $menuArray = [];
          foreach ($parentMenu as $pmenu) {
            if ($pmenu->header){
              $menuArray[$pmenu->header] = ['header' => $pmenu->header];
            }
            $menuArray[$pmenu->id] = [
              'id' => $pmenu->title_id,
              'title' => $pmenu->menu_name,
              'icon' => $pmenu->icon,
              'navLink' =>$pmenu->route,
            ];
            if (in_array($pmenu->id, $isChildMenu)) {
              $menuArray[$pmenu->id]['children'] = [];
            }
          }
        
          //Create Child Menu Array
          foreach ($childMenu as $cmenu) {
            
            if (array_key_exists('children', $menuArray[$cmenu->parent_id])) {
              $childrenArray = $menuArray[$cmenu->parent_id]['children'];
              $childData = [
                'id' =>$cmenu->title_id,
                'title' =>$cmenu->menu_name,
                'icon' =>$cmenu->icon,
                'navLink' =>$cmenu->route,
                'uniqueID' => $cmenu->id,
              ];
              if ($cmenu->id == 60) {
                $childData['children'] = [];
              }
              array_push($childrenArray, $childData);
              $menuArray[$cmenu->parent_id]['children'] = $childrenArray;
            }
          }

          //Create Subchild Menu Array
          foreach ($subchildMenu as $cmenu) {
            // dd($cmenu);
            if (array_key_exists('children', $menuArray[$cmenu->subchild_parent_id])) {
              $subChildrenArray = $menuArray[$cmenu->subchild_parent_id]['children'];
              // dd($subChildrenArray);
              $index = '';
              foreach ($subChildrenArray as $key => $value) {
                if ($value['uniqueID'] == $cmenu->parent_id) {
                  $index = $key;
                }
              }
              if (array_key_exists('children', $subChildrenArray[$index])) {
                $createSubChildArray = $subChildrenArray[$index]['children'];
                $childData = [
                  'id' =>$cmenu->title_id,
                  'title' =>$cmenu->menu_name,
                  'icon' =>$cmenu->icon,
                  'navLink' =>$cmenu->route,
                ];
                array_push($createSubChildArray, $childData);
                $subChildrenArray[$index]['children'] = $createSubChildArray;
                $menuArray[$cmenu->subchild_parent_id]['children'] = $subChildrenArray;
              }
            }
          }
          $newMenuArray = [];
          foreach($menuArray as $key => $value) {
            array_push($newMenuArray, $menuArray[$key]);
          }
          $menuAction = DB::table('tbl_menu_action_permission as tmap')
                            ->leftJoin('tbl_menu as tm', 'tm.id', '=', 'tmap.menu_id')
                            ->select('tmap.action', 'tm.route')
                            ->where('tmap.designation_id', $request->designation_id)
                            ->get()->toArray();
          // dd($userdata);
          $dataArray = [];
          foreach ($menuAction as $value) {
            $dataArray[$value->route] = $value->action;
          }
          return response()->json([
            'code' => 200,
            'data' => $newMenuArray,
            'main_menu' => $parentMenu,
            'child_menu' => $childMenu,
            'subchild_menu' => $subchildMenu,
            'get_all_menu_action' => $getAllMenuAction,
            'action_permission' => $dataArray
          ]);
        } else {
          return response()->json([
            'code' => 500,
            'message' => "Employee designation not alloted",
          ]);
        }
    }
    public function submitUserPermission(Request $request)
    {
        UserMenuPermission::where('designation_id', $request->designation_id)->delete();
        UserActionPermission::where('designation_id', $request->designation_id)->delete();
        foreach ($request->menu as $value) {
            $userPermission = new UserMenuPermission();
            $userPermission->menu_id = $value;
            $userPermission->designation_id = $request->designation_id;
            $userPermission->user_type = 'employee';

            $userPermission->save();
        }
        foreach ($request->actions as $key => $action) {
            $useraction = new UserActionPermission();
            $useraction->menu_id = $key;
            $useraction->designation_id = $request->designation_id;
            $useraction->user_type = 'employee';
            $useraction->action = implode('#', $action);

            $useraction->save();
        }

        return response()->json([
            'code' => 200,
            'message' => "User permission added successfully",
        ]);
    }
    
    //test menu api
    public function getMenuTest(Request $request) {
        if ($request->designation_id) {
          $parentMenu = DB::table('tbl_user_menu_permission as tump')
                        ->leftJoin('tbl_menu2 as tm', 'tm.id', '=', 'tump.menu_id')
                        ->where('tump.designation_id', $request->designation_id)
                        ->where('tm.parent_id', 0)
                        ->where('tm.is_active', true)
                        ->orderBy('tm.menu_order', 'asc')
                        ->get()->toArray();

          $childMenu = DB::table('tbl_user_menu_permission as tump')
                        ->leftJoin('tbl_menu2 as tm', 'tm.id', '=', 'tump.menu_id')
                        ->where('tump.designation_id', $request->designation_id)
                        ->where('parent_id', '!=', 0)
                        ->where('is_subchild', 0)
                        ->where('is_active', true)
                        ->orderBy('menu_order', 'asc')
                        ->get()->toArray();

          $subchildMenu = DB::table('tbl_user_menu_permission as tump')
                          ->leftJoin('tbl_menu2 as tm', 'tm.id', '=', 'tump.menu_id')
                          ->where('tump.designation_id', $request->designation_id)
                          ->where('is_subchild', 1)
                          ->where('is_active', true)
                          ->orderBy('menu_order', 'asc')
                          ->get()->toArray();

          $isChildMenu = DB::table('tbl_user_menu_permission as tump')
                        ->leftJoin('tbl_menu2 as tm', 'tm.id', '=', 'tump.menu_id')
                        ->where('tump.designation_id', $request->designation_id)
                        ->where('parent_id', '!=', 0)
                        ->where('is_subchild', 0)
                        ->where('is_active', true)
                        ->orderBy('menu_order', 'asc')
                        ->get()->pluck('parent_id')->toArray();

          if ($request->designation_id == 1551997) {
            $getAllMenuAction = DB::table('tbl_menu_action')->get()->pluck('action', 'menu_id')->toArray();
          } else {
            $getAllMenuAction = DB::table('tbl_menu_action_permission as tmap')
                          ->where('tmap.designation_id', $request->designation_id)
                          ->get()->pluck('action', 'menu_id')->toArray();
          }


        //   dd($isChildMenu);
        
          // Create Main Menu Array
          $menuArray = [];
          foreach ($parentMenu as $pmenu) {
            if ($pmenu->header){
              $menuArray[$pmenu->header] = ['header' => $pmenu->header];
            }
            $menuArray[$pmenu->id] = [
              'id' => $pmenu->title_id,
              'title' => $pmenu->menu_name,
              'icon' => $pmenu->icon,
              'navLink' =>$pmenu->route,
            ];
            if (in_array($pmenu->id, $isChildMenu)) {
              $menuArray[$pmenu->id]['children'] = [];
            }
          }
        
        // dd($menuArray);
          //Create Child Menu Array
          foreach ($childMenu as $cmenu) {
            
            if (array_key_exists('children', $menuArray[$cmenu->parent_id])) {
              $childrenArray = $menuArray[$cmenu->parent_id]['children'];
              $childData = [
                'id' =>$cmenu->title_id,
                'title' =>$cmenu->menu_name,
                'icon' =>$cmenu->icon,
                'navLink' =>$cmenu->route,
                'uniqueID' => $cmenu->id,
              ];
              if ($cmenu->id == 60) {
                $childData['children'] = [];
              }
              array_push($childrenArray, $childData);
              $menuArray[$cmenu->parent_id]['children'] = $childrenArray;
            }
          }
        //   dd($subchildMenu);
        // print_r($menuArray);
          //Create Subchild Menu Array
          foreach ($subchildMenu as $cmenu) {
            // print_r($cmenu);
            if (array_key_exists('children', $menuArray[$cmenu->subchild_parent_id])) {
              $subChildrenArray = $menuArray[$cmenu->subchild_parent_id]['children'];
              // dd($subChildrenArray);
              $index = '';
              foreach ($subChildrenArray as $key => $value) {
                if ($value['uniqueID'] == $cmenu->parent_id) {
                  $index = $key;
                }
              }
              if (array_key_exists('children', $subChildrenArray[$index])) {
                $createSubChildArray = $subChildrenArray[$index]['children'];
                $childData = [
                  'id' =>$cmenu->title_id,
                  'title' =>$cmenu->menu_name,
                  'icon' =>$cmenu->icon,
                  'navLink' =>$cmenu->route,
                ];
                array_push($createSubChildArray, $childData);
                $subChildrenArray[$index]['children'] = $createSubChildArray;
                $menuArray[$cmenu->subchild_parent_id]['children'] = $subChildrenArray;
              }
            }
          }
          $newMenuArray = [];
          foreach($menuArray as $key => $value) {
            array_push($newMenuArray, $menuArray[$key]);
          }
          $menuAction = DB::table('tbl_menu_action_permission as tmap')
                            ->leftJoin('tbl_menu2 as tm', 'tm.id', '=', 'tmap.menu_id')
                            ->select('tmap.action', 'tm.route')
                            ->where('tmap.designation_id', $request->designation_id)
                            ->get()->toArray();
          // dd($userdata);
          $dataArray = [];
          foreach ($menuAction as $value) {
            $dataArray[$value->route] = $value->action;
          }
          return response()->json([
            'code' => 200,
            'data' => $newMenuArray,
            'main_menu' => $parentMenu,
            'child_menu' => $childMenu,
            'subchild_menu' => $subchildMenu,
            'get_all_menu_action' => $getAllMenuAction,
            'action_permission' => $dataArray
          ]);
        } else {
          return response()->json([
            'code' => 500,
            'message' => "Employee designation not alloted",
          ]);
        }
    }
}
