<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\ToDolist;
use App\Http\Controllers\APIController;

class ToDolistController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }

public function gettodolist(Request $request)
{
    try {
        $result = DB::table('tbl_todolist as tfa');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result->leftJoin('tbl_employee as tf', 'tf.eid', '=', 'tfa.uid')
            ->where('tfa.isDeleted', false)
            ->orderBy('tfa.id', 'desc');

        if ($request->paginate == "true") {
            $result = $result->select('tfa.id', 'tf.emp_name', 'tfa.date', 'tfa.tasks');
        }

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.date', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tf.id', $request->empID);
        }

        // Get the total record count
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Agency fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data",
        ]);
    }
}

  public function submittodolist(Request $request) {
    try {
      $todoData = $request->id ? ToDolist::find($request->id) : new ToDolist();
       $todoData->uid = $request->uid;
      $todoData->tasks = $request->tasks;
      $todoData->date = $request->date;
      $todoData->save();


      return response()->json([
        'code' => 200,
        'message' => "Data Save successfully"
      ]);
    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'error' => $e->getMessage(),
        'message' => "Something went wrong while saving data"
      ]);
    }
  }
     public function deleteTodolist(Request $request) {
        try {
               $tadadata = ToDolist::where('id', $request->id)
                      ->update(['isDeleted' => true]);
           
           
              return response()->json([
                'code' => 200,
                'message' => "Todo list Rejected successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }
       
    }
    
 
}
