<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\tada;
use App\Models\Employee;
use App\Models\DayStart;
use App\Http\Controllers\APIController;

class TaDaController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }

    public function getada(Request $request)
    {
        $result = DB::table('tbl_tada as tfa');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_daystart as td', function ($join) {
                $join->on('td.uid', '=', 'tfa.uid')->on('tfa.tadaDate', '=', 'td.date');
            })
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.uid')
            ->where('tfa.isApproved', true)
            ->where('tfa.isReject', false);

        if ($request->paginate == "true") {
            $result = $result->select(
                'tfa.id',
                'tf.emp_name',
                'tf.id as empId',
                'td.date as dayStartDate',
                'tfa.tadaDate',
                'tfa.editableForm',
                'tfa.editableTo',
                'tfa.editableDistance',
                'tfa.editableMode',
                'tfa.etdsg',
                'tfa.editableExpense',
                'tfa.editableOtherExpense',
                'tfa.start_image',
                'tfa.end_image',
                'tf.ta',
                'tf.taCar',
                'tfa.da',
                'tfa.bill_img',
                'tfa.auto',
                'tfa.stationery',
                'tfa.vehmant',
                'tfa.petrol',
                'tfa.tada_pdf',
                'tfa.isApproved',
                'td.sdis',
                'td.edis',
                'td.distance'
            );
        } else {
            $result = $result->select(
                'tfa.id',
                'tf.emp_name',
                'tfa.tadaDate',
                'tfa.editableForm',
                'tfa.editableTo',
                'tfa.editableDistance',
                'tfa.editableMode',
                'tfa.etdsg',
                'tfa.editableExpense',
                'tfa.editableOtherExpense',
                'tfa.start_image',
                'tfa.end_image',
                'tf.ta',
                'tf.taCar',
                'tfa.da',
                'tfa.bill_img',
                'tfa.auto',
                'tfa.stationery',
                'tfa.vehmant',
                'tfa.petrol',
                'tfa.tada_pdf',
                'tfa.isApproved',
                'td.sdis',
                'td.edis',
                'td.distance'
            );
        }

        // $result = $result->orderBy('tfa.tadaDate', 'desc');

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.tadaDate', [$fromDate, $toDate]);
        }else{
            $fromDate = date('Y-m-d',strtotime('-10 Days'));
            $toDate = date('Y-m-d');
            $result = $result->whereBetween('tfa.tadaDate', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tfa.uid', $request->empID);
        }

        if ($request->regionID) {
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
            $result = $result->whereIn('tf.region', explode(',', $getAllRegionIDs));
        }

        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Ta Da fetched successfully",
            'data' => $result,
            'total_records' => $totalCount,
        ]);
    }

    public function getadabill(Request $request)
    {
        $result = DB::table('tbl_tada as tfa');
        $result = $result->whereNotNull('tfa.bill_img')->where('tfa.bill_img', '!=', '');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_daystart as td', function ($join) {
                $join->on('td.uid', '=', 'tfa.uid')->on('tfa.tadaDate', '=', 'td.date');
            })
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.uid')
            ->where('tfa.isApproved', true)
            ->where('tfa.isReject', false);

        $selectFields = [
            'tfa.id',
            'tf.emp_name',
            'tfa.tadaDate',
            'tfa.editableForm',
            'tfa.editableTo',
            'tfa.editableDistance',
            'tfa.editableMode',
            'tfa.etdsg',
            'tfa.editableExpense',
            'tfa.editableOtherExpense',
            'tfa.start_image',
            'tfa.end_image',
            'tf.ta',
            'tfa.da',
            'tfa.bill_img',
            'tfa.auto',
            'tfa.stationery',
            'tfa.vehmant',
            'tfa.petrol',
            'tfa.tada_pdf',
            'tfa.isApproved',
            'td.sdis',
            'td.edis',
            'td.distance',
        ];

        $result = $result->select($selectFields);

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.tadaDate', [$fromDate, $toDate]);
        }else{
            $fromDate = date('Y-m-d',strtotime('-10 Days'));
            $toDate = date('Y-m-d');
            $result = $result->whereBetween('tfa.tadaDate', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tfa.uid', $request->empID);
        }

        if ($request->regionID) {
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
            $result = $result->whereIn('tf.region', explode(',', $getAllRegionIDs));
        }

        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Ta Da fetched successfully",
            'data' => $result,
            'total_records' => $totalCount,
        ]);
    }

    public function getnotaprovetada(Request $request)
    {
        try {
            $result = DB::table('tbl_tada as tfa');
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
                });
            }

            $result = $result
                ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.uid')
                ->where('tfa.isApproved', false)
                ->where('tfa.isReject', false);

            if ($request->timeFrameValue != "0") {
                $result = $result->whereBetween('tfa.tadaDate', [$fromDate, $toDate]);
            }else{
                $fromDate = date('Y-m-d',strtotime('-10 Days'));
                $toDate = date('Y-m-d');
                $result = $result->whereBetween('tfa.tadaDate', [$fromDate, $toDate]);
            }

            if ($request->empID) {
                $result = $result->where('tfa.uid', $request->empID);
            }

            if ($request->regionID) {
                $regionId = $request->regionID;
                $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
                $result = $result->whereIn('tf.region', explode(',', $getAllRegionIDs));
            }

            // Add the order by clause here
            $result = $result->orderBy('tfa.id', 'DESC'); // You can use 'asc' for ascending order

            if ($request->paginate == "true") {
                $result = $result->select(
                    'tfa.id',
                    'tf.emp_name',
                    'tfa.tadaDate',
                    'tfa.editableForm',
                    'tfa.editableTo',
                    'tfa.editableDistance',
                    'tfa.editableMode',
                    'tfa.etdsg',
                    'tfa.editableExpense',
                    'tfa.editableOtherExpense',
                    'tfa.start_image',
                    'tfa.end_image',
                    'tfa.ta',
                    'tfa.da',
                    'tfa.bill_img',
                    'tfa.auto',
                    'tfa.stationery',
                    'tfa.vehmant',
                    'tfa.petrol',
                    'tfa.tada_pdf',
                    'tfa.isApproved'
                );

                // Get the total record count
                $totalCount = $result->count();

                $result = $result->simplePaginate();
            } else {
                $result = $result
                    ->select('tfa.*', 'tf.emp_name')
                    ->get()
                    ->toArray();
                // Get the total record count
                $totalCount = count($result);
            }

            return response()->json([
                'code' => 200,
                'message' => "Not approved TA/DA fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }

    public function edittada(Request $request)
    {
        // dd($request->all());
        
        $getEmp = DB::table('tbl_employee')->where('id', $request->empId)->first();

        if($getEmp){
            $lda = $getEmp->lda;
            $oda = $getEmp->oda;
        } else {
            $lda = 0;
            $oda = 0;
        }
        
        $totalTaFair = $request->ta * $request->distance; 
        
        if($request->ta != 0 || $request->ta != ''){
            $petrol = 0;
        } else {
            $petrol = $request->petrol;
        }
        
        if($request->da == 'Local DA'){
            $da = $lda;
        } else if($request->da == 'Outstation DA'){
            $da = $oda;
        } else {
            $da = 0;
        }
        
        $tadadata = Tada::find($request->id);

        if(!$tadadata) {
            return response()->json([
                'code' => 404,
                'message' => "Tada data not found",
            ]);
        }
        
        $tadadata->editableForm = $request->editableForm;
        $tadadata->editableTo = $request->editableTo;
        $tadadata->editableDistance = $request->distance;
        $tadadata->editableMode = $request->editableMode;
        $tadadata->etdsg = $request->etdsg;
        $tadadata->editableExpense = $request->editableExpense;
        $tadadata->editableOtherExpense = $request->editableOtherExpense;
        $tadadata->da = $da;
        $tadadata->ta = $totalTaFair;
        $tadadata->petrol = $petrol;
        $tadadata->auto = $request->auto;
        $tadadata->stationery = $request->stationery;
        $tadadata->vehmant = $request->vehmant;
        
        $tadadata->save();
        
        $dayStart = DayStart::where('date',$request->dayStartDate)->where('uid',$request->empId)
            ->update([
                'edis' => $request->edis,
                'distance' => $request->distance
            ]);
                  
        
        return response()->json([
            'code' => 200,
            'message' => "Ta Da updated successfully",
        ]);
        
        
    }

    public function approvetada(Request $request)
    {
        try {
            $tadadata = Tada::where('id', $request->id)->update(['isApproved' => true]);

            return response()->json([
                'code' => 200,
                'message' => "Tada approved successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
    
    public function rejecttada(Request $request)
    {
        try {
            $tadadata = Tada::where('id', $request->id)->update(['isReject' => true]);

            return response()->json([
                'code' => 200,
                'message' => "Leave Rejected successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
    
    // report tada
    public function getTadaExportReport(Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $employeeIds = []; // Define an array to store unique employee IDs
        $employeeData = []; // Define an array to store the final result

        // Fetch all unique employee IDs based on your conditions
        $uniqueEmployeeIds = DB::table('tbl_tada as tfa')
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.uid')
            ->leftJoin('tbl_category as tc', 'tf.region', '=', 'tc.category_id')
            ->leftJoin('tbl_designation as td', 'tf.empDesignation', '=', 'td.designationId')
            ->where('tfa.isApproved', true)
            ->where('tfa.isReject', false)
            ->whereBetween('tfa.tadaDate', [$fromDate, $toDate])
            ->when($request->empID, function ($query) use ($request) {
                return $query->where('tfa.uid', $request->empID);
            })
            ->when($request->regionID, function ($query) use ($request) {
                $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
                return $query->whereIn('tf.region', explode(',', $getAllRegionIDs));
            })
            ->select('tfa.uid', 'tf.emp_name','tf.emp_mobile','tc.category_name','td.designationName')
            ->distinct()
            ->get();

        // Loop through unique employee IDs and fetch their data
        foreach ($uniqueEmployeeIds as $employee) {
            $employeeId = $employee->uid;
            
            $employeeTadaData = DB::table('tbl_tada as tfa')
                ->leftJoin('tbl_daystart as td', function ($join) {
                    $join->on('td.uid', '=', 'tfa.uid')->on('tfa.tadaDate', '=', 'td.date');
                })
                ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.uid')
                ->where('tfa.isApproved', true)
                ->where('tfa.isReject', false)
                ->where('tfa.uid', $employeeId)
                ->whereBetween('tfa.tadaDate', [$fromDate, $toDate])
                ->select(
                    'tfa.id',
                    'tf.emp_name',
                    'tfa.tadaDate',
                        'tfa.editableForm',
                        'tfa.editableTo',
                        'tfa.editableDistance',
                        'tfa.editableMode',
                        'tfa.etdsg',
                        'tfa.editableExpense',
                        'tfa.editableOtherExpense',
                        'tfa.start_image',
                        'tfa.end_image',
                        'tf.ta',
                        'tfa.da',
                        'tfa.bill_img',
                        'tfa.auto',
                        'tfa.stationery',
                        'tfa.vehmant',
                        'tfa.petrol',
                        'tfa.tada_pdf',
                        'tfa.isApproved',
                        'td.sdis',
                        'td.edis',
                        'td.distance'
                )
                ->get()
                ->toArray();
        
            $employeeData[] = [
                'employeeName' => $employee->emp_name,
                'employeeMobile' => $employee->emp_mobile,
                'employeeRegion' => $employee->category_name,
                'employeeDesignation' => $employee->designationName,
                'tadaData' => $employeeTadaData,
            ];
            $employeeId = '';
        }
        
        return response()->json([
            'code' => 200,
            'message' => "Ta Da fetched successfully",
            'data' => $employeeData,
        ]);

    }
}
