<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Support;
use App\Models\SupportTicketUpdate; 
use App\Http\Controllers\APIController;
use Illuminate\Support\Facades\Storage;
use App\Models\Employee; 

class SupportController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    
  
    
    public function getticket(Request $request)
    {
        $result = DB::table('tbl_supportTkt as tfa');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }
        $result = $result->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.Emp_Id');

        if ($request->paginate == "true") {
            $result = $result->select('tfa.Ticket_ID', 'tf.emp_name', 'tfa.priority', 'tfa.Subject', 'tfa.Description_of_the_Issue', 'tfa.created_at', 'tfa.updated_at', 'tfa.Ticket_Status');
            $result = $result->select('tfa.*', 'tf.emp_name');
        }
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.created_at', [$fromDate, $toDate]);
        }
        if ($request->staustype) {
            $result = $result->where('tfa.Ticket_Status', $request->staustype);
        }
        // Calculate the total count before paginating
        $totalCount = $result->count();
        
        if ($request->paginate == "true") {
            $result = $result->orderBy('tfa.id', 'desc')->simplePaginate();
        } else {
            $result = $result->orderBy('tfa.id', 'desc')->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Ticket fetched successfully",
            'total_records' => $totalCount, // Include the total count in the response
            'data' => $result,
        ]);
    }
    
    public function submitsupport(Request $request)
    {
        try {
            // dd($request->all());
            $supportData = $request->id ? Support::find($request->id) : new Support();
            $supportTicketUpdateData =  new SupportTicketUpdate(); 
            $filePath = '';
            if ($request->hasFile('file')) {
                $clientDirectory = $request->header('usedwhich');
                $path = $request->file('file')->store('/'.$clientDirectory.'/support', 's3');
                $fileName = explode('/support/', $path)[1];
                $filePath = Storage::disk('s3')->url($path); // Generate a public URL for the uploaded image
            }
            $supportData->Emp_id = $request->Emp_id;
            $supportData->created_at = date('Y-m-d h:i:s');
            $supportData->priority = $request->priority;
            $supportData->Subject = $request->Subject;
            $supportData->Description_of_the_Issue = $request->Description_of_the_Issue;
            $supportData->filepath = $filePath;
            // $supportData->Date_Created = $request->Date_Created;
            $supportData->save();
            $supportId = DB::table('tbl_supportTkt') 
                ->latest()
                ->first(); // get last id of insert order 
            // dd($supportId);
            $supportTicketUpdateData->Ticket_ID = $supportId->id; // order id
            $supportTicketUpdateData->Date_Created = date('Y-m-d h:i:s'); // product id
            $supportTicketUpdateData->Description_of_Update = $request->Description_of_the_Issue;
            $supportTicketUpdateData->Update_Author = $request->Emp_id;
            // $supportTicketUpdateData->updated_at = '';
            $supportTicketUpdateData->supportTicketImg = $fileName;
            $supportTicketUpdateData->save();   
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'Error' => $e->getMessage(),
                'message' => "Something went wrong while Saving Data",
            ]);
        }
    }
    
    public function submitSupportTicketDetails(Request $request)
    { 
        try { 
            // dd($request->all());
            $supportTicketUpdateData = new SupportTicketUpdate();
            
            
            // $supportTicketUpdateData =  new SupportTicketUpdate(); 
           
            $supportTicketUpdateData->Ticket_ID = $request->Ticket_ID; // ticket id
            $supportTicketUpdateData->Date_Created = date('Y-m-d h:i:s'); 
            $supportTicketUpdateData->Description_of_Update = $request->Description_of_Update;
            $supportTicketUpdateData->Update_Author = $request->Update_Author; //employee id
            // $supportTicketUpdateData->updated_at = '';
            $supportTicketUpdateData->supportTicketImg = $request->supportTicketImg;
            $supportTicketUpdateData->save();   
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'Error' => $e->getMessage(),
                'message' => "Something went wrong while Saving Data",
            ]);
        }
    } 
    
    public function getTicketDetails(Request $request)
    {
        // dd($request->all()); 
        $reportArray = [];
        $getAllEmployees = Employee::get()->pluck('emp_name','id')->toArray();
        $result = DB::table('tbl_supportTktUpdate as tfa');
        $result = $result->select('tfa.Ticket_ID', 'tf.emp_name', 'tfa.Update_Author', 'tfa.Description_of_Update', 'tfa.created_at', 'tfa.supportTicketImg','tsu.subject','tf.emp_mobile','tds.designationName','td.category_name','td.unit','td.region','td.headquarter','td.territory','tf.emp_mobile','tf.date_of_joining','tf.parent_empid','tf.appVersion');
        $result = $result->leftJoin('tbl_supportTkt as tsu', 'tsu.id', '=', 'tfa.Ticket_ID');   
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }
        $result = $result->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.Update_Author');
        $result = $result->leftJoin('tbl_designation as tds', 'tds.designationId', '=', 'tf.empDesignation');
        $result = $result->leftJoin('tbl_category as td', 'td.category_id', '=', 'tf.region');
        $result = $result->where('tfa.Ticket_ID', $request->Ticket_ID);
        if ($request->paginate == "true") {
            $result = $result->select('tfa.Ticket_ID', 'tf.emp_name', 'tfa.Update_Author', 'tfa.Description_of_Update', 'tfa.created_at', 'tfa.supportTicketImg');
            // $result = $result->select('tfa.*', 'tf.emp_name');
        }

        if ($request->paginate == "true") {
            $result = $result->orderBy('tfa.Update_ID', 'asc')->simplePaginate();
        } else {
            $result = $result->orderBy('tfa.Update_ID', 'asc')->get()->toArray();
        }
        $getRegionList = $this->apiController->getRegionList()->getData();
        $regionObject = $getRegionList->regionList;
        
        $getRegionNameVal = [];
        foreach ($regionObject as $object) {
            $getRegionNameVal[] = (array) $object;
        }

        // dd($arrays);
        
        foreach ($result as $row) {
            $unitId = $row->unit;
            $mainRegionId = $row->region;
            $territoryId = $row->territory;
            $headquarterId = $row->headquarter;
        
            $unitName = '';
            if($unitId){
                $key = '';
                $key = array_search($unitId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $unitName = '';
                } else {
                    $unitName = $getRegionNameVal[$key]['category_name'];
                }
            }
            
            $territoryName = '';
            if($territoryId){
                $key = '';
                $key = array_search($territoryId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $territoryName = '';
                } else {
                    $territoryName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $headquarterName = '';
            if($headquarterId){
                $key = '';
                $key = array_search($headquarterId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $headquarterName = '';
                } else {
                    $headquarterName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $mainRegionName = '';
            if($mainRegionId){
                $key = '';
                $key = array_search($mainRegionId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $mainRegionName = '';
                } else {
                    $mainRegionName = $getRegionNameVal[$key]['category_name'];
                }
            }
            
            
            $region = $row->emp_name;
            $data['emp_name'] = $row->emp_name;
            $data['emp_mobile'] = $row->emp_mobile;
            $data['location'] = '';
            $data['designation'] = $row->designationName;
            $data['unit'] = $unitName;
            $data['region'] = $mainRegionName;
            $data['territory'] = $territoryName;
            $data['headquarter'] = $headquarterName;
            $data['work_region'] = $row->category_name;
            $data['reporting_manager'] = $row->parent_empid ? $getAllEmployees[$row->parent_empid] : '';
            $data['app_version'] = $row->appVersion;
            $data['date_of_joining'] = $row->date_of_joining;
            $data['Ticket_ID'] = $row->Ticket_ID;
            $data['Update_Author'] = $row->Update_Author;
            $data['Description_of_Update'] = $row->Description_of_Update;
            $data['created_at'] = $row->created_at;
            $data['supportTicketImg'] = $row->supportTicketImg;
            $data['subject'] = $row->subject;
            array_push($reportArray, $data);
        }
        return response()->json([
            'code' => 200,
            'message' => "Ticket fetched successfully",
            'data' => $reportArray,
        ]);
    }
    
    public function getTicketChatDiscussionJson(Request $request)
    {
        // dd($request->all());
        $ticketId = $request->Ticket_ID;
        $resultArray = [];
        $empId = DB::table('tbl_supportTkt')->where('id', $ticketId)->value('Emp_id');
        $result = DB::table('tbl_supportTktUpdate as tfa')
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tfa.Update_Author')
            ->select('tfa.Ticket_ID', 'tfa.Update_Author', 'tfa.Description_of_Update', 'tfa.created_at', 'tfa.supportTicketImg', 'te.emp_name')
            ->where('tfa.Ticket_ID',$ticketId);
        $result = $result->orderBy('tfa.Update_ID', 'desc')->get();
        
        $ticketCount = $result->count();
        $results = $result->toArray();
        $resultArray['supportId'] = $ticketId;
        $resultArray['threadCount'] = $ticketCount;
        
        foreach ($results as $row) {
            $author = $row->Update_Author;
            $tktGenerator = ($empId == $author) ? 'Yes' : 'No';
            
            $attachmentCount = 0;
            // $attachment = [];
            $attachmentArray['attachmentCount'] = $attachmentCount;
            
            if (!empty($row->supportTicketImg)) {
                $attachment = explode('#', $row->supportTicketImg);
                $attachmentCount = count($attachment);
                // $attachmentArray = [];
                for($i = 0; $i< count($attachment);$i++){
                    $attachmentData = array(
                            'mediaType' => pathinfo($attachment[$i], PATHINFO_EXTENSION),
                            'fileName' => $attachment[$i]
                    );
                    array_push($attachmentArray, $attachmentData);
                }
            }
            // dd($attachmentArray);
            // print_r($attachmentArray);
            // $attachmentArray1 = [];
            $resultArray[] = [
                'tktGenerator' => $tktGenerator,
                'empName' => $row->emp_name,
                'dateTime' => $row->created_at,
                'Desc' => $row->Description_of_Update,
                'isAttachment' => $row->supportTicketImg ? 'Yes' : 'No',
                'attachment' => $attachmentArray,
            ];
        }
        // print_r($resultArray);
        return response()->json([
            'code' => 200,
            'message' => "Ticket fetched successfully",
            'data' => $resultArray,
        ]);
    }
    
    public function updateCompleteStatus(Request $request)
    {
        // dd($request->fmID);
        
        $result = Support::where('id', $request->Ticket_ID)->update(['Ticket_Status' => 3]);
        

        return response()->json([
            'code' => 200,
            'success' => $result,
        ]);
    }
    
    public function data() {
        $resultArray = [];
        $sql1 = "SELECT Emp_id FROM tbl_supportTkt WHERE id = '$ticketId'";
        $result1 = mysqli_num_rows($con,$sql1);
        $data1 = mysqli_fetch_assoc($result1);
        $empId = $data1['Emp_id'];
        
        $sql = "SELECT 'tfa.Ticket_ID', 'tfa.Update_Author', 'tfa.Description_of_Update', 'tfa.created_at', 'tfa.supportTicketImg','te.emp_name' FROM tbl_supportTktUpdate as tfa LEFT JOIN tbl_employee as te ON te.id = tfa.Update_Author";
        $result = mysqli_query($con,$sql);
        $ticketCount = mysqli_num_rows($result);
        $resultArray['supportId'] = $ticketId; 
        $resultArray['threadCount'] = $ticketCount; 
        while ($row= mysqli_fetch_assoc($result)){
            $author = $row['Update_Author'];
            if($empId == $author){
                $tktGenerator = 'Yes';
            }else{
                $tktGenerator = 'No';
            }
            if(isset($row['supportTicketImg'])){
                $attachment = explode('#',$row['supportTicketImg']);
                $attachmentCount = count($attachment);
            } 
            array_push($resultArray,array(
                'tktGenerator' => $tktGenerator, 
                'empName' => $row['emp_name'],
                'dateTime' => $row['created_at'],
                'Desc' => $row['Description_of_Update'],
                'isAttachment' => $row['supportTicketImg'] ? 'Yes' : 'No',
                'attachment' => array(
                        'attachmentCount' => $attachmentCount,
                        array(
                            'mediaType' =>'',
                            'fileName' =>'',
                        )
                        
                    ),
            ));
        } 
    }
}
