<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\StockUpdate;
use App\Models\Product;
use App\Models\Agency;
use App\Http\Controllers\APIController;

class StockUpdateController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    //old code
    public function getStockUpdateData(Request $request)
    {
        $result = DB::table('tbl_stockupdate as ts');
    
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        
        $query = StockUpdate::with(['entries.product', 'agency']);

        // Apply pagination
        $perPage = $request->input('per_page', 10);
        
        $result = StockUpdate::with(['entries.product:pid,productName', 'agency:agencyId,agencyName'])
        
        ->when($request->has('agencyId'), function ($query) use ($request) {
            $query->where('agencyId', $request->input('agencyId'));
        })
        
        ->when($request->has('productId'), function ($query) use ($request) {
            $query->whereHas('entries', function ($subquery) use ($request) {
                $subquery->whereIn('productId', $request->input('productId'));
            });
        })
        
        ->when($request->has('search'), function ($query) use ($request) {
            $query->where('date', 'like', '%' . $request->input('search') . '%');
        })
        
        ->paginate($request->input('per_page', 10));
        $result = $query->paginate($perPage);

        return response()->json(['result' => $result]);
    }
    //updated code / agencywise stock update
    public function getStockUpdateData1(Request $request) 
    {
        
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $productId = $request->productId;
        $agencyId = $request->agencyIndex;
        // print_r($productId);
        $perPage = $request->input('per_page', 10); // Number of records per page, default is 10
        
        $stockIds = DB::table('tbl_stockupdate as t1')
            ->leftJoin('tbl_agency as t2', 't1.agencyId','=','t2.agencyId')
            ->leftJoin('tbl_category as t3', 't2.agencyRegion','=','t3.category_id')
            ->leftJoin('tbl_employee as t4', 't1.empId','=','t4.id')
            ->select('t1.agencyId', 'date','t1.id', DB::raw("CONVERT(CAST(CONVERT(t2.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),'t3.category_name','t4.emp_name')
            ->where('t1.agencyId', $agencyId);
        
        if ($request->timeFrameValue != "0") {
            $stockIds = $stockIds->whereBetween('date', [$fromDate, $toDate]);
        }  
        
        // Add search condition
        if ($request->keyword) {
            $stockIds->where('t2.agencyShopName', 'like', '%' .$request->keyword. '%')
                    ->orWhere('t3.category_name', 'like', '%' .$request->keyword .'%')
                    ->orWhere('t1.date', 'like', '%' .$request->keyword .'%')
                    ->orWhere('t4.emp_name', 'like', '%' .$request->keyword .'%');
        }
        
        if ($request->paginate == "true") {
            $stockIds = $stockIds->paginate($perPage);
        } else {
            $stockIds = $stockIds->get();
        }
        
        // $stockIdsCount = $stockIds->total();
        $stockResultData = array();
        
        foreach ($stockIds as $stockIdsVal) {
            $productDetails = [];
        
            foreach ($productId as $productIdVal) {
                $result = DB::table('tbl_stockupdate_entries as t')
                    ->where('stockId', '=', $stockIdsVal->id)
                    ->where('productId', '=', $productIdVal)
                    ->get();
        
                $rowAffectedForData = count($result);
        
                if ($rowAffectedForData > 0) {
                    foreach ($result as $row) {
                        if($row->quantity){
                            $quantity = $row->quantity;
                        }else{
                            $quantity = 0;
                        }
                        $stockdata = [
                            'productId' => $productIdVal,
                            'quantity' => $quantity
                        ];
                        $productDetails[] = $stockdata;
                    }
                } else {
                    $stockdata = [
                        'productId' => $productIdVal,
                        'quantity' => 0
                    ];
                    $productDetails[] = $stockdata;
                }
            }
        
            $stockResultData[] = [
                'agencyId' => $stockIdsVal->agencyId,
                'date' => $stockIdsVal->date,
                'stockId' => $stockIdsVal->id,
                'agencyName' => $stockIdsVal->agencyShopName,
                'agencyRegion' => $stockIdsVal->category_name,
                'employeeName' => $stockIdsVal->emp_name,
                'stockDetail' => $productDetails
            ];
        }
        if ($request->paginate == "true") {
            $paginationDetails = [
                'current_page' => $stockIds->currentPage(),
                'first_page_url' => $stockIds->url(1),
                'from' => $stockIds->firstItem(),
                'to' => $stockIds->lastItem(),
                'last_page' => $stockIds->lastPage(),
                'last_page_url' => $stockIds->url($stockIds->lastPage()),
                'next_page_url' => $stockIds->nextPageUrl(),
                'path' => $stockIds->path(),
                'per_page' => $stockIds->perPage(),
                'prev_page_url' => $stockIds->previousPageUrl(),
                'total' => $stockIds->total(),
            ];
        } else {
            $paginationDetails = [];
        }
        
        return response()->json(['code' => 200,  'data' => $stockResultData,'paginationDetails' => $paginationDetails]);
        
    }
    
    // employee wise stock report
    public function getEmployeewiseStockUpdateData(Request $request) 
    {
        
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $productId = $request->productId;
        $empId = $request->empID;
        // print_r($productId);
        $perPage = $request->input('per_page', 10); // Number of records per page, default is 10
        
        $stockIds = DB::table('tbl_stockupdate as t1')
            ->leftJoin('tbl_agency as t2', 't1.agencyId','=','t2.agencyId')
            ->leftJoin('tbl_category as t3', 't2.agencyRegion','=','t3.category_id')
            ->leftJoin('tbl_employee as t4', 't1.empId','=','t4.id')
            ->select('t1.*','t1.agencyId', 'date','t1.id','t2.agencyShopName','t3.category_name','t4.emp_name')
            ->where('t1.empId', $empId);
        
        if ($request->timeFrameValue != "0") {
            $stockIds = $stockIds->whereBetween('date', [$fromDate, $toDate]);
        }  
            
        
        // Add search condition
        if ($request->keyword) {
            $stockIds->where('t2.agencyShopName', 'like', '%' .$request->keyword. '%')
                    ->orWhere('t3.category_name', 'like', '%' .$request->keyword .'%')
                    ->orWhere('t1.date', 'like', '%' .$request->keyword .'%')
                    ->orWhere('t4.emp_name', 'like', '%' .$request->keyword .'%');
            
        }
        
        if ($request->paginate == "true") {
            $stockIds = $stockIds->paginate($perPage);
        } else {
            $stockIds = $stockIds->get();
        }
            
        
        // $stockIdsCount = $stockIds->total();
        $stockResultData = array();
        
        foreach ($stockIds as $stockIdsVal) {
            $productDetails = [];
        
            foreach ($productId as $productIdVal) {
                $result = DB::table('tbl_stockupdate_entries as t')
                    ->where('stockId', '=', $stockIdsVal->id)
                    ->where('productId', '=', $productIdVal)
                    ->get();
        
                $rowAffectedForData = count($result);
        
                if ($rowAffectedForData > 0) {
                    foreach ($result as $row) {
                        if($row->quantity){
                            $quantity = $row->quantity;
                        }else{
                            $quantity = 0;
                        }
                        $stockdata = [
                            'productId' => $productIdVal,
                            'quantity' => $quantity
                        ];
                        $productDetails[] = $stockdata;
                    }
                } else {
                    $stockdata = [
                        'productId' => $productIdVal,
                        'quantity' => 0
                    ];
                    $productDetails[] = $stockdata;
                }
            }
        
            $stockResultData[] = [
                'agencyId' => $stockIdsVal->agencyId,
                'date' => $stockIdsVal->date,
                'stockId' => $stockIdsVal->id,
                'agencyName' => $stockIdsVal->agencyShopName,
                'employeeName' => $stockIdsVal->emp_name,
                'agencyRegion' => $stockIdsVal->category_name,
                'stockDetail' => $productDetails
            ];
        }
        
        if ($request->paginate == "true") {
            $paginationDetails = [
                'current_page' => $stockIds->currentPage(),
                'first_page_url' => $stockIds->url(1),
                'from' => $stockIds->firstItem(),
                'to' => $stockIds->lastItem(),
                'last_page' => $stockIds->lastPage(),
                'last_page_url' => $stockIds->url($stockIds->lastPage()),
                'next_page_url' => $stockIds->nextPageUrl(),
                'path' => $stockIds->path(),
                'per_page' => $stockIds->perPage(),
                'prev_page_url' => $stockIds->previousPageUrl(),
                'total' => $stockIds->total(),
            ];
        } else {
            $paginationDetails = [];
        }
        
        return response()->json(['code' => 200,'data' => $stockResultData,'paginationDetails' => $paginationDetails]);
        
    }
}
