<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Employee;
use App\Models\ActivityTarget;
use App\Models\RegionWisePrice;
use App\Http\Controllers\ReadCSVController;
use StaticArray;
use App\Http\Controllers\APIController;

class SetTargetController extends Controller
{
    private $apiController;

    
    public function __construct(APIController $apiController, ReadCSVController $readCSVController)
    {
        $this->apiController = $apiController;
        $this->readCSVController = $readCSVController;
    }
    
    public function downloadEmployeeTargetCsv(Request $request){
        try {
            $regionId = $request->regionID;

            $result = DB::table('tbl_employee as te');
            $regionIndex = $request->regionIndex;
            // $categoryIDWithParent = $regionIndex.','.$this->apiController->getRegionId($regionIndex);
            // $getAllRegionIDs = rtrim($categoryIDWithParent,',');
            
            $result = $result
                ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
                ->select('te.id','te.eid','te.emp_name','tc.category_name','te.emp_mobile')
                ->where('te.user_role', 'employee');
            
            $result = $result->where('te.deleteFlag', 0);
            
            if ($request->regionIndex) {
                $regionId = $request->regionIndex;
                $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
                $result = $result->whereIn('te.region', explode(',', $getAllRegionIDs));
            }
            
            $result = $result->get()->toArray();
            return response()->json([
                'code' => 200,
                'data' => $result
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => 'An error occurred while generating the report.',
                'error' => $e->getMessage(),
            ]);
        }
    }
    
    private function validateCSVHeader($csvHeader, $staticHeader)
    {
        $result = false;
        if (count($csvHeader) != count($staticHeader)) {
            $result = true;
        } else {
            //  print_r($staticHeader) .'-'. print_r($csvHeader);
            for ($i = 0; $i < count($staticHeader); $i++) {
                if ($staticHeader[$i] != $csvHeader[$i]) {
                    $result = true;
                    break;
                }
            }
        }
        // echo $result;
        
        return $result;
    }
    
    //  import employee target
    public function importEmployeeTargets(Request $request)
    {
        $fromDate  = date('Y-m-01', strtotime('+1 month'));
        $toDate = date('Y-m-d', strtotime('last day of +1 month'));
        // dd($toDate);
        $file = $request->file('file');
        // dd($file);
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$employeeTargetArray);

        if ($validateCSVFIle) {
            return response()->json([
                'code' => 500,
                'message' => "Invalid CSV file uploaded",
            ]);
        }
        
        $getEmployeeNameVal = $this->apiController->getEmployeeDataArray();
        // print_r($uploadAndGetData['data']);
        foreach ($uploadAndGetData['data'] as $value) {
            if(isset($value['EmployeeMobile'])){
                $key = '';
                $key = array_search($value['EmployeeMobile'], array_column($getEmployeeNameVal, 'emp_mobile'));
                if ($key === FALSE) {
                    $region = '';
                    $empId = '';
                } else {
                    $region = $getEmployeeNameVal[$key]['region'];
                    $empId = $getEmployeeNameVal[$key]['id'];
                }
            }else{
                $region = '';
                $empId = '';
            }
                
            $checkEmployeeTargetExist = DB::table('tbl_activity_target')
                ->where('date_from', $fromDate)
                ->where('date_to', $toDate)
                ->where('empId', $empId)
                ->select('id')
                ->get()
                ->toArray();
                
            // insert target
            if (!count($checkEmployeeTargetExist)) {
                $employeeTarget = new ActivityTarget();
                $employeeTarget->regionId = $region;
                $employeeTarget->empId = $empId;
                $employeeTarget->date_from = $fromDate;
                $employeeTarget->date_to = $toDate;
                $employeeTarget->icTarget = $value['IC'];
                $employeeTarget->sdTarget = $value['SD'];
                $employeeTarget->fdTarget = $value['FD'];
                $employeeTarget->organisedMeetingTarget = $value['OrganisedFarmerMeeting'];
                $employeeTarget->groupMeetingTarget = $value['GroupMeeting'];
                $employeeTarget->avTarget = $value['AV'];
                $employeeTarget->revisit = $value['Revisit'];
                $employeeTarget->paymentSum = $value['Order'];
                $employeeTarget->orderSum = $value['Payment'];
                $employeeTarget->save();
            }else{
                // update target
            }
        }
        
        
        return response()->json([
            'code' => 200,
            'message' => "CSV file uploaded successfully",
        ]);
    }
    
    
    public function getEmployeeTargetTimeframe(Request $request){
        
        $queryResult = ActivityTarget::select(DB::raw('DISTINCT(date_from) as date_fromSlot'), 'date_to as date_toSlot')
            ->orderBy('date_from', 'DESC')
            ->get();

        $options = [];

        foreach ($queryResult as $data) {
            
            $options[] = [
                'value'    => $data->date_fromSlot.'#'.$data->date_toSlot,
                'label'    => date('d M Y', strtotime($data->date_fromSlot)).' - '.date('d M Y', strtotime($data->date_toSlot))
            ];
        }

        return response()->json(['options' => $options]);
        
    }
    
    public function viewEmployeeTarget(Request $request){
        
        $result = DB::table('tbl_activity_target as tfa')
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.empId')
            ->leftJoin('tbl_category as tcregion', 'tcregion.category_id', '=', 'tfa.regionId')
            ->where('tf.deleteFlag', false);
        
        if ($request->timeslot) {
            $timeFrame = explode('#',$request->timeslot);
            $fromDate = $timeFrame[0];
            $toDate = $timeFrame[1];
            $result = $result->where('tfa.date_from', $fromDate)
                             ->where('tfa.date_to', $toDate);
        }else{
            $fromDate = date('Y-m-01');
            $toDate = date('Y-m-d');
            $result = $result->where('tfa.date_from', $fromDate)
                             ->where('tfa.date_to', $toDate);
        }
        if ($request->regionID) {
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
            $result = $result->whereIn('tfa.regionId', explode(',', $getAllRegionIDs));
        }
        if ($request->empID) {
            $result = $result->where('tfa.empId', $request->empID);
        }
        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('tf.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tf.emp_mobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tcregion.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        $totalCount = $result->count();
        if ($request->paginate == "true") {
            $result = $result
                ->select(
                    'tfa.id',
                    'tf.emp_name',
                    'tcregion.category_name as region_category_name',
                    'tf.emp_mobile',
                    'tfa.icTarget',
                    'tfa.sdTarget',
                    'tfa.sdvTarget',
                    'tfa.fdTarget',
                    'tfa.organisedMeetingTarget',
                    'tfa.groupMeetingTarget',
                    'tfa.avTarget',
                    'tfa.paymentSum',
                    'tfa.orderSum'
                )
                ->simplePaginate();
        } else {
            $result = $result
                ->select(
                    'tfa.id',
                    'tf.emp_name',
                    'tcregion.category_name as region_category_name',
                    'tf.emp_mobile',
                    'tfa.icTarget',
                    'tfa.sdTarget',
                    'tfa.sdvTarget',
                    'tfa.fdTarget',
                    'tfa.organisedMeetingTarget',
                    'tfa.groupMeetingTarget',
                    'tfa.avTarget',
                    'tfa.paymentSum',
                    'tfa.orderSum'
                )
                ->get()
                ->toArray();
        }

        
        return response()->json([
            'code' => 200,
            'message' => "Target fetched successfully",
            'totalCount' => $totalCount,
            'data' => $result,
        ]);
    }
    
    public function EmpTarget($regionId, $fdate, $tdate)
    {
        $fetchTargetArray = [];
        $categoryType = 'te.id';
        $getAllRegionIDs = $this->apiController->getRegionId($regionId);
        
        $results = DB::table('tbl_employee AS te')
            ->leftJoin('tbl_activity_target AS tat', 'tat.empId', '=', 'te.id')
            ->select(
                'te.region',
                DB::raw("$categoryType AS emp_id"),
                DB::raw('SUM(icTarget) AS icTarget'),
                DB::raw('SUM(sdTarget) AS sdTarget'),
                DB::raw('SUM(fdTarget) AS fdTarget'),
                DB::raw('SUM(organisedMeetingTarget) AS organisedMeetingTarget'),
                DB::raw('SUM(groupMeetingTarget) AS groupMeetingTarget'),
                DB::raw('SUM(avTarget) AS avTarget'),
                DB::raw('SUM(paymentSum) AS paymentSum'),
                DB::raw('SUM(orderSum) AS orderSum')
            )
            ->where('tat.date_from', $fdate)
            ->where('tat.date_to', $tdate)
            ->whereIn('tat.regionId', explode(',', $getAllRegionIDs))
            ->groupBy($categoryType)
            ->get();

        foreach ($results as $row) {
            $ic_target = 0;
            $sd_target = 0;
            $fd_target = 0;
            $ofm_target = 0;
            $gfm_target = 0;
            $av_target = 0;
            $paymentSum = 0;
            $orderSum = 0;

            $ic_target = $row->icTarget;
            $sd_target = $row->sdTarget;
            $fd_target = $row->fdTarget;
            $ofm_target = $row->organisedMeetingTarget;
            $gfm_target = $row->groupMeetingTarget;
            $av_target = $row->avTarget;
            $empId = $row->emp_id;
            $paymentSum = $row->paymentSum;
            $orderSum = $row->orderSum;

            $fetchTargetArray[] = [
                "regionId" => $row->region,
                "icTarget" => $ic_target,
                "sdTarget" => $sd_target,
                "fdTarget" => $fd_target,
                "organisedMeetingTarget" => $ofm_target,
                "groupMeetingTarget" => $gfm_target,
                "avTarget" => $av_target,
                "empId" => $empId,
                "payment" => $paymentSum,
                "order" => $orderSum,
            ];
        }
        return $fetchTargetArray;
    }
    
    public function EmpAchieveTarget($regionId, $fdate, $tdate)
    {
        $fetchTargetAchiveArray = [];
        $categoryType = 'te.id';
        $getAllRegionIDs = $this->apiController->getRegionId($regionId);
        $results = DB::table('tbl_activity_count_current_year AS tat')
            ->leftJoin('tbl_employee AS te', 'tat.empId', '=', 'te.id')
            ->select(
                'te.region',
                DB::raw("$categoryType AS emp_id"),
                DB::raw('SUM(tat.ic) AS ic_achieved'),
                DB::raw('SUM(tat.revisit) AS revisit_achieved'),
                DB::raw('SUM(tat.sd) AS sd_achieved'),
                DB::raw('SUM(tat.fd) AS fd_achieved'),
                DB::raw('SUM(tat.ofm) AS ofm_achieved'),
                DB::raw('SUM(tat.gfm) AS gfm_achieved'),
                DB::raw('SUM(tat.av) AS av_achieved'),
                DB::raw('SUM(tat.payment) AS payment_achieved'),
                DB::raw('SUM(tat.order) AS order_achieved')
            )
            ->whereIn('te.region', explode(',', $getAllRegionIDs))
            ->whereBetween('activityDate', [$fdate, $tdate])
            ->groupBy($categoryType)
            ->get();
        
        foreach ($results as $row) {
            $ic_achieved = 0;
            $sd_achieved = 0;
            $fd_achieved = 0;
            $ofm_achieved = 0;
            $gfm_achieved = 0;
            $av_achieved = 0;
            $order_achieved = 0;
            $payment_achieved = 0;

            $icTotal = $row->ic_achieved + $row->revisit_achieved;
            $ic_achieved = $icTotal === null ? 0 : $icTotal;
            $sd_achieved = $row->sd_achieved === null ? 0 : $row->sd_achieved;
            $fd_achieved = $row->fd_achieved === null ? 0 : $row->fd_achieved;
            $ofm_achieved = $row->ofm_achieved === null ? 0 : $row->ofm_achieved;
            $gfm_achieved = $row->gfm_achieved === null ? 0 : $row->gfm_achieved;
            $av_achieved = $row->av_achieved === null ? 0 : $row->av_achieved;
            $order_achieved = $row->order_achieved === null ? 0 : $row->order_achieved;
            $payment_achieved = $row->payment_achieved === null ? 0 : $row->payment_achieved;
            $empId = $row->emp_id;

            $fetchTargetAchiveArray[] = [
                "regionId" => $row->region,
                "ic_achieved" => $icTotal,
                "sd_achieved" => $sd_achieved,
                "fd_achieved" => $fd_achieved,
                "ofm_achieved" => $ofm_achieved,
                "gfm_achieved" => $gfm_achieved,
                "av_achieved" => $av_achieved,
                "order_achieved" => $order_achieved,
                "payment_achieved" => $payment_achieved,
                "empId" => $empId,
            ];
        }

        return $fetchTargetAchiveArray;
    }
    
    public function viewEmployeeAchievedTarget(Request $request)
    {
        
        if ($request->timeslot) {
            $timeFrame = explode('#',$request->timeslot);
            $fromDate = $timeFrame[0];
            $toDate = $timeFrame[1];
            
        }else{
            $fromDate = date('Y-m-01');
            $toDate = date('Y-m-d');
        }
        
        
        $result = DB::table('tbl_employee AS t2')
            ->leftJoin('tbl_category AS t1', 't1.category_id', '=', 't2.region')
            ->select('t1.category_name', 't2.emp_name', 't2.emp_mobile', 't2.id', 't2.region')
            ->where('t2.deleteFlag', 0);
        
        if ($request->regionID) {
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
            $result = $result->whereIn('t2.region', explode(',', $getAllRegionIDs));
        }
         
        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('t2.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t2.emp_mobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t1.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        if ($request->paginate == "true") {
            $perPage = 15; // Set your desired number of items per page
            $page = $request->page ?: 1;

            $countQuery = clone $result;
            $total = $countQuery->count();

            $paginator = new \Illuminate\Pagination\LengthAwarePaginator($result->forPage($page, $perPage)->get(), $total, $perPage, $page, [
                'path' => $request->url(),
                'query' => $request->query(),
            ]);

            $paginationDetails = [
                'current_page' => $paginator->currentPage(),
                'first_page_url' => $paginator->url(1),
                'from' => $paginator->firstItem(),
                'to' => $paginator->lastItem(),
                'last_page' => $paginator->lastPage(),
                'last_page_url' => $paginator->url($paginator->lastPage()),
                'next_page_url' => $paginator->nextPageUrl(),
                'path' => $paginator->path(),
                'per_page' => $paginator->perPage(),
                'prev_page_url' => $paginator->previousPageUrl(),
                'total' => $paginator->total(),
            ];

            $result = $paginator->items();
        } else {
            $result = $result->get()->toArray();
            $paginationDetails = null;
        }
        $getEmpTargetVal = $this->EmpTarget($request->regionID, $fromDate, $toDate);
        $getEmpAchiveArray = $this->EmpAchieveTarget($request->regionID, $fromDate, $toDate);
        
        $reportArray = array();
        foreach ($result as $row) {
            $icTarget = '0';
            $sdTarget = '0';
            $fdTarget = '0';
            $ofmTarget = '0';
            $gfmTarget = '0';
            $avTarget = '0';
            $paymentTarget = '0';
            $orderTarget = '0';
            // echo $row['eid'];
            if ($row->id) {
                $key = '';
                $key = array_search($row->id, array_column($getEmpTargetVal, 'empId'));
                if ($key === false) {
                    $icTarget = '0';
                    $sdTarget = '0';
                    $fdTarget = '0';
                    $ofmTarget = '0';
                    $gfmTarget = '0';
                    $avTarget = '0';
                    $orderTarget = '0';
                    $paymentTarget = '0';
                } else {
                    $icTarget = $getEmpTargetVal[$key]['icTarget'];
                    $sdTarget = $getEmpTargetVal[$key]['sdTarget'];
                    $fdTarget = $getEmpTargetVal[$key]['fdTarget'];
                    $ofmTarget = $getEmpTargetVal[$key]['organisedMeetingTarget'];
                    $gfmTarget = $getEmpTargetVal[$key]['groupMeetingTarget'];
                    $avTarget = $getEmpTargetVal[$key]['avTarget'];
                    $paymentTarget = $getEmpTargetVal[$key]['payment'];
                    $orderTarget = $getEmpTargetVal[$key]['order'];
                }
            }
            // echo $icTarget;
            $icAchiveTarget = '0';
            $sdAchiveTarget = '0';
            $fdAchiveTarget = '0';
            $ofmAchiveTarget = '0';
            $gfmAchiveTarget = '0';
            $avAchiveTarget = '0';
            $orderAchiveTarget = '0';
            $paymentAchiveTarget = '0';
            if ($row->id) {
                $key = '';
                $key = array_search($row->id, array_column($getEmpAchiveArray, 'empId'));
                if ($key === false) {
                    $icAchiveTarget = '0';
                    $sdAchiveTarget = '0';
                    $fdAchiveTarget = '0';
                    $ofmAchiveTarget = '0';
                    $gfmAchiveTarget = '0';
                    $avAchiveTarget = '0';
                    $orderAchiveTarget = '0';
                    $paymentAchiveTarget = '0';
                } else {
                    $icAchiveTarget = $getEmpAchiveArray[$key]['ic_achieved'];
                    $sdAchiveTarget = $getEmpAchiveArray[$key]['sd_achieved'];
                    $fdAchiveTarget = $getEmpAchiveArray[$key]['fd_achieved'];
                    $ofmAchiveTarget = $getEmpAchiveArray[$key]['ofm_achieved'];
                    $gfmAchiveTarget = $getEmpAchiveArray[$key]['gfm_achieved'];
                    $avAchiveTarget = $getEmpAchiveArray[$key]['av_achieved'];
                    $orderAchiveTarget = $getEmpAchiveArray[$key]['order_achieved'];
                    $paymentAchiveTarget = $getEmpAchiveArray[$key]['payment_achieved'];
                }
            }

            

            // $empId = $row>empID;
            $data['workRegion'] = $row->category_name;
            $data['emp_name'] = $row->emp_name;
            $data['emp_mobile'] = $row->emp_mobile;
            $data['eid'] = $row->id;
            $data['ic_target'] = $icTarget;
            $data['ic_achieve'] = $icAchiveTarget;
            $data['sd_target'] = $sdTarget;
            $data['sd_achieve'] = $sdAchiveTarget;
            $data['fd_target'] = $fdTarget;
            $data['fd_achieve'] = $fdAchiveTarget;
            $data['ofm_target'] = $ofmTarget;
            $data['ofm_achieve'] = $ofmAchiveTarget;
            $data['gfm_target'] = $gfmTarget;
            $data['gfm_achieve'] = $gfmAchiveTarget;
            $data['av_target'] = $avTarget;
            $data['av_achieve'] = $avAchiveTarget;
            $data['order_target'] = $orderTarget;
            $data['order_achieve'] = $orderAchiveTarget;
            $data['payment_target'] = $paymentTarget;
            $data['payment_achieve'] = $paymentAchiveTarget;
            $reportArray[] = $data;
        }

        return response()->json([
            'report_data' => $reportArray,
            'pagination_details' => $paginationDetails,
        ]);
    }
   
}
