<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\RevisitPurpose;
use App\Models\UpdateKeyNew;
use App\Http\Controllers\APIController;

class RevisitPurposeController extends Controller
{
    private $apiController;
    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
        // $this->SendSMSController = $SendSMSController;
    }
    
    public function submitRevisit(Request $request)
    {
        if ($request->id) {
            $this->updateRevisitPurpose($request);
            return response()->json([
                'code' => 200,
                'message' => "Data update successfully",
            ]);
        } else {
            try {
                $revisitData = $request->id ? RevisitPurpose::find($request->id) : new RevisitPurpose();
    
                $revisitData->purpose_name = $request->revisitpurpose_name;
                $revisitData->revisit_status = $request->revisit_status;
                $revisitData->save();
                $id = 1;
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->purposeList += 1;
                $updateKey->save();
    
                return response()->json([
                    'code' => 200,
                    'message' => "Data Save successfully",
                ]);
            } catch (\Exception $e) {
                return response()->json([
                    'code' => 500,
                    'error' => $e->getMessage(),
                    'message' => "Something went wrong while saving data",
                ]);
            }
        }
    }
    
    private function updateRevisitPurpose($request) {
        try {
            RevisitPurpose::where('purpose_id', $request->id)
                ->update([
                    'purpose_name' => $request->revisitpurpose_name,
                    'revisit_status' => $request->revisit_status              
                ]);
            return response()->json([
                'code' => 200,
                'message' => "Revisit Purpose updated successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while updating AV Purpose",
            ]);
        }
    } 
      public function getRevisitPurpose(Request $request) {
        // try {
            $revisitData = RevisitPurpose::select('*')->where('deleteFlag', false);
            
            $revisitData->orderBy('created_at', 'desc');
          
            if ($request->keyword) {
                $revisitData = $revisitData->where(function ($query) use ($request) {
                    $query->where('purpose_name', 'like', '%' . $request->keyword . '%');
                          
                });
            }
            if ($request->paginate == "true") {
                $revisitData = $revisitData->paginate();
            } else {
                $revisitData = $revisitData->get()->toArray();
            }
                         

          return response()->json([
            'code' => 200,
            'data' => $revisitData
          ]);
        // } catch (\Exception $e) {
        //   return response()->json([
        //     'code' => 500,
        //     'message' => "Something went wrong while saving data"
        //   ]);
        // }
      }
public function getRevisit(Request $request)
{
    try {
        $result = DB::table('tbl_revisit as tfm')
            ->select('tfm.*');

        // Apply filters based on URL parameters
        if ($request->has('keyword')) {
            $result->where('tfm.revisitPurpose', 'like', '%' . $request->keyword . '%');
        }

        if ($request->has('fromDate')) {
            $result->whereDate('tfm.revisit_datetime', '>=', $request->fromDate);
        }

        if ($request->has('toDate')) {
            $result->whereDate('tfm.revisit_datetime', '<=', $request->toDate);
        }

        // You can add more filters as needed based on the request parameters

        $result->where('tfm.isDeleted', false)
            ->orderBy('tfm.rid', 'desc');

        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Revisit Purpose fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}


    public function deleteRevisit(Request $request)
    {
        try {
            RevisitPurpose::where('purpose_id', $request->id)
                ->update([
                    'deleteFlag' => 1
                ]);
            return response()->json([
                'code' => 200,
                'message' => "Revisit Purpose deleted successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting revisit purpose",
            ]);
        }
    }
public function getRevisitReport(Request $request)
{
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $empID = $request->empID;
    $query = DB::table('tbl_revisit as tr')
        ->leftJoin('tbl_employee as te', 'tr.empId', '=', 'te.id')
        ->leftJoin('tbl_farmer as tf', 'tr.farmerId', '=', 'tf.farmerId')
        ->leftJoin('tbl_category as tcc', 'tf.farmerRegion', '=', 'tcc.category_id')
        ->select('tf.farmerId', 'tr.revisit_datetime', 'tf.farmerLandAcerage', 
                    DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 'tf.farmerMobile', 
                    DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'),  
                    'te.emp_name', 'tcc.category_name', 'tr.revisitPurpose', 'tr.photo')
        ->orderBy('tr.rid', 'DESC');

    if ($request->timeFrameValue != "0") {
        $query->whereBetween('tr.revisit_datetime', [$request->fromDate . ' ' . '00:00:00', $request->toDate  . ' ' . '23:59:59']);
    }

    if ($request->empID) {
        $query->where('tr.empId', $request->empID);
    }else{
        $getAllRegionIDs = $this->apiController->getRegionId($regionID);
        $query->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
    }

    
    if ($request->keyword) {
        $query->Where(function ($query) use ($request) {
            $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%')
                ->orWhere('tr.revisit_datetime', 'like', '%' . $request->keyword . '%')
                ->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%')
                ->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%')
                ->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%')
                ->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
        });
    }

    $totalCount = $query->count();

    if ($request->paginate == "true") {
        $paginationData = $query->paginate();
        $current_page = $paginationData->currentPage();
        $first_page_url = $paginationData->url(1);
        $last_page = $paginationData->lastPage();
        $last_page_url = $paginationData->url($paginationData->lastPage());
        $next_page_url = $paginationData->nextPageUrl();
        $prev_page_url = $paginationData->previousPageUrl();
        $per_page = $paginationData->perPage();
        $from = $paginationData->firstItem();
        $to = $paginationData->lastItem();
        $total = $paginationData->total();
    } else {
        $paginationData = $query->get();
        $current_page = 1; // Set to 1 for non-paginated results
        $first_page_url = null;
        $last_page = 1;
        $last_page_url = null;
        $next_page_url = null;
        $prev_page_url = null;
        $per_page = null;
        $from = null;
        $to = null;
        $total = null;
    }

    // Create a new array with 'photo' field included
    $dataWithPhoto = $paginationData->map(function ($item) {
        return [
            'farmerId' => $item->farmerId,
            'revisit_datetime' => $item->revisit_datetime,
            'farmerLandAcerage' => $item->farmerLandAcerage,
            'farmerName' => $item->farmerName,
            'farmerMobile' => $item->farmerMobile,
            'farmerAddress' => $item->farmerAddress,
            'emp_name' => $item->emp_name,
            'category_name' => $item->category_name,
            'revisitPurpose' => $item->revisitPurpose,
            'photo' => $item->photo,
        ];
    });

    return response()->json([
        'code' => 200,
        'report_data' => [
            'current_page' => $current_page,
            'data' => $dataWithPhoto, // Use the updated data array with 'photo'
            // 'first_page_url' => $paginationData->url(1),
            // 'from' => $paginationData->firstItem(),
            // 'last_page' => $paginationData->lastPage(),
            // 'last_page_url' => $paginationData->url($paginationData->lastPage()),
            // 'links' => $paginationData->toArray()['links'],
            // 'next_page_url' => $paginationData->nextPageUrl(),
            // 'path' => $paginationData->url($paginationData->currentPage()),
            // 'per_page' => $paginationData->perPage(),
            // 'prev_page_url' => $paginationData->previousPageUrl(),
            // 'to' => $paginationData->lastItem(),
            // 'total' => $paginationData->total(),
            
            'first_page_url' => $first_page_url,
            'last_page' => $last_page,
            'last_page_url' => $last_page_url,
            'next_page_url' => $next_page_url,
            'prev_page_url' => $prev_page_url,
            'per_page' => $per_page,
            'from' => $from,
            'to' => $to,
            'total' => $total,
            'total_records' => $totalCount,
        ],
    ]);
}


}
