<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Employee;
use App\Models\Clients;
use App\Models\Farmer;
use App\Models\FarmerMeeting;
use App\Models\FarmActivity;
use App\Models\Revisit;
use App\Models\AgencyVisit;
use App\Models\Agency;
use App\Models\DayStart;
use File;
use App\Http\Controllers\APIController;

class ReportController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
  public function getProductWiseFDReport(Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $productID = $request->productIds;
    $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');

    $result = DB::table('tbl_farmactivityfd as tfd');
    if ($request->keyword) {
      $result = $result->orWhere(function($query) use($request){
      $query->orWhere('te.emp_name', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfd.FD_date', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerMobile', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerAddress', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tcc.category_name', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tp.productName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tc.cropName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfd.FD_farmerNum', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfd.FD_budget', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfd.FD_Area', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfd.FD_ProductQty', 'like', '%'.$request->keyword.'%' );
      });
    }
    $result = $result
      ->leftJoin('tbl_farmer as tf', 'tfd.farmerId', '=', 'tf.farmerId')
      ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
      ->leftJoin('tbl_crop as tc', 'tfd.cropId', '=', 'tc.cropId')
      ->leftJoin('tbl_product as tp', 'tfd.productId', '=', 'tp.pid')
      ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
      ->select('tf.farmerRegion','tfd.farmerId','tfd.FD_date', 'tf.farmerName', 'tf.farmerCity', 'tfd.FD_farmerNum', 'tfd.FD_budget', 'tfd.FD_Area', 'tfd.FD_ProductQty', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName')
      ->whereBetween('tfd.FD_date',[$fromDate, $toDate])
      ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
      if (!in_array('all', $productID)) {
        $result = $result->whereIn('tfd.productId', $productID);
      }
      if ($request->paginate == "true") {
        $result = $result->paginate();
      } else {
        $result = $result->get()->toArray();
      }

      return response()->json([
        'code' => 200,
        'report_data' => $result,
      ]);
  }
  public function getProductWiseSDReport(Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $productID = $request->productIds;
    $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');

    $result = DB::table('tbl_farmactivity as tfa');
    if ($request->keyword) {
      $result = $result->orWhere(function($query) use($request){
      $query->orWhere('te.emp_name', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfa.SD_date', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerMobile', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerAddress', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tcc.category_name', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tp.productName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tc.cropName', 'like', '%'.$request->keyword.'%' );
      });
    }
    $result = $result
      ->leftJoin('tbl_farmer as tf', 'tfa.farmerId', '=', 'tf.farmerId')
      ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
      ->leftJoin('tbl_crop as tc', 'tfa.cropId', '=', 'tc.cropId')
      ->leftJoin('tbl_product as tp', 'tfa.productId', '=', 'tp.pid')
      ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
      ->select('tf.farmerRegion','tfa.farmerId','tfa.SD_date', 'tf.farmerName', 'tf.farmerCity', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName')
      ->whereBetween('tfa.SD_date',[$fromDate, $toDate])
      ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
      if (!in_array('all', $productID)) {
        $result = $result->whereIn('tfa.productId', $productID);
      }
      if ($request->paginate == "true") {
        $result = $result->paginate();
      } else {
        $result = $result->get()->toArray();
      }

      return response()->json([
        'code' => 200,
        'report_data' => $result,
      ]);
  }
  public function getProductWiseSDVReport(Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $productID = $request->productIds;
    $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');

    $result = DB::table('tbl_farmactivity as tfa');
    if ($request->keyword) {
      $result = $result->orWhere(function($query) use($request){
      $query->orWhere('te.emp_name', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tfa.SDV_date', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerMobile', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tf.farmerAddress', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tcc.category_name', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tp.productName', 'like', '%'.$request->keyword.'%' );
      $query->orWhere('tc.cropName', 'like', '%'.$request->keyword.'%' );
      });
    }
    $result = $result
      ->leftJoin('tbl_farmer as tf', 'tfa.farmerId', '=', 'tf.farmerId')
      ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
      ->leftJoin('tbl_crop as tc', 'tfa.cropId', '=', 'tc.cropId')
      ->leftJoin('tbl_product as tp', 'tfa.productId', '=', 'tp.pid')
      ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
      ->select('tf.farmerRegion','tfa.farmerId','tfa.SDV_date', 'tf.farmerName', 'tf.farmerCity', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName')
      ->whereBetween('tfa.SDV_date',[$fromDate, $toDate])
      ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
      if (!in_array('all', $productID)) {
        $result = $result->whereIn('tfa.productId', $productID);
      }
      if ($request->paginate == "true") {
        $result = $result->paginate();
      } else {
        $result = $result->get()->toArray();
      }

      return response()->json([
        'code' => 200,
        'report_data' => $result,
      ]);
  }
  public function getProductWiseFMReport(Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $productID = $request->productIds;

    $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');
    $result = DB::table('tbl_farmermeeting as tfm');
    if ($request->keyword) {
      $result = $result->orWhere(function($query) use($request){
        $query->orWhere('te.emp_name', 'like', '%'.$request->keyword.'%' );
        $query->orWhere('tfm.fmDate', 'like', '%'.$request->keyword.'%' );
        $query->orWhere('tcc.category_name', 'like', '%'.$request->keyword.'%' );
      });
    }

    $result = $result
                  ->leftJoin('tbl_employee as te', 'tfm.empId', '=', 'te.id')
                  ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tfm.farmerRegion')
                  ->select('tfm.fmDate', 'tfm.villageNameID', 'tfm.fmNos', 'tfm.fmRemark', 'tfm.fmCropIds', 'tfm.fmProductIds', 'te.emp_name', 'tcc.category_name')
                  ->whereIn('tfm.farmerRegion', explode(',', $getAllRegionIDs))
                  ->whereBetween('tfm.fmDate',[$fromDate, $toDate]);
                  if (!in_array('all', $productID)) {
                    $result = $result->where(function ($query) use($productID) {
                         for ($i = 0; $i < count($productID); $i++){
                            $query->orwhere('tfm.fmProductIds', 'like',  '%' . $productID[$i] .'%');
                         }
                    });
                  }
                  if ($request->paginate == "true") {
                    $result = $result->paginate();
                  } else {
                    $result = $result->get()->toArray();
                  }
                  // dd($result);
    $reportArray = [];
    $getProductData = DB::table('tbl_product')->get()->pluck('productName', 'pid')->toArray();
    $getCropData = DB::table('tbl_crop')->get()->pluck('cropName', 'cropId')->toArray();
    foreach ($result as $value) {
      $data['fmDate'] = $value->fmDate;
      $data['villageNameID'] = $value->villageNameID;
      $data['emp_name'] = $value->emp_name;
      $data['category_name'] = $value->category_name;

      $allProduct = '';
      foreach (explode('#', $value->fmProductIds) as $product) {
        $allProduct .= $getProductData[$product]. ',';
      }
      $allCrop = '';
      if ($value->fmCropIds) {
        foreach (explode('#', $value->fmCropIds) as $crop) {
          $allCrop .= $getCropData[$crop]. ',';
        }
      }
      $data['all_products'] = rtrim($allProduct,',');
      $data['all_crops'] = $allCrop !== '' ? rtrim($allCrop,',') : '';

      array_push($reportArray, $data);

    }
    return response()->json([
      'code' => 200,
      'report_data' => $result,
      'data' => $reportArray,
    ]);
  }
  public function getSummayReport($gtype,$regionID) {
    $getRegion = DB::table('tbl_category')->where('parent_category_id',$regionID)->get()->toArray();
    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();
    $employeeData = DB::table('tbl_employee')->where('deleteFlag',0)->get()->pluck('emp_name', 'region')->toArray();
    $compititorData = DB::table('tbl_company_compitior')->get()->pluck('compititor_name', 'cid')->toArray();
    $reportArray = [];
    if (count($getRegion)) {
      $type = 'region';
      foreach ($getRegion as $region) {
        $regionId = $region->category_id;
        $regionIDs = $this->apiController->getRegionId($regionId);
        $result = DB::table('tbl_agency as ta')
                    ->leftJoin('tbl_agencydetail as tad', 'tad.agencyId', '=', 'ta.agencyId')
                    ->selectRaw('count(*) AS totalCount,sum(agencyTurnover) AS agencyTurnoverCount,sum(agencyGAPLTurnover) AS agencyGAPLTurnoverCount')
                    ->whereIn('ta.agencyRegion', explode(',', $regionIDs))
                    ->where('ta.agencyType', $gtype)
                    ->get()->toArray();
        $data['region_name'] = $categoryData[$regionId].'-'.$regionId;
        $data['emp_name'] = array_key_exists($regionId, $employeeData) ? $employeeData[$regionId] : '';
        $data['mapped_target'] = 'N/A';
        $data['mapped'] = $result[0]->totalCount;
        $data['achievement'] = 'N/A';
        $data['total_turnover'] = $result[0]->agencyTurnoverCount;
        $data['total_gapl_turnover'] = $result[0]->agencyGAPLTurnoverCount;

        array_push($reportArray, $data);
      }
    } else {
      $type = 'employee';
      $result = DB::table('tbl_agency as ta')
                  ->leftJoin('tbl_agencydetail as tad', 'tad.agencyId', '=', 'ta.agencyId')
                  ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion')
                  ->leftJoin('tbl_employee as te', 'te.id', '=', 'tad.empId')
                  ->select('*')
                  ->whereIn('ta.agencyRegion', explode(',', $regionID))
                  ->where('ta.agencyType', $gtype)
                  ->get()->toArray();

      $reportArray = $result;
    }
    return response()->json([
      'code' => 200,
      'report_data' => $reportArray,
      'compititor_data' => $compititorData,
      'type' => $type
    ]);
  }
  public function getStockReport(Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $agencyType = $request->agencyType;

    $productData = DB::table('tbl_product')->where('liquidationList', 1)->get()->toArray();
    $getRegion = DB::table('tbl_category')->where('parent_category_id',$regionID)
                                          ->where('category_name' , '!=', '')
                                          ->orWhere('category_id', $regionID)
                                          ->where('category_id', '!=', 1)
                                          ->get()->toArray();
    $reportArray = [];
    if (count($getRegion)) {
      $type = 'region';
      foreach ($getRegion as $region) {
        $categoryID = $region->category_id;
        $getEmployee = DB::table('tbl_employee')->where('deleteFlag',0)->where('region',$categoryID)->get()->toArray();
        $categoryIDWithParent = $this->apiController->getRegionId($categoryID);
        $getAllRegionIDs = rtrim($categoryIDWithParent,',');

        foreach ($productData as $product) {
            $result = DB::table('tbl_liquidation_detail_stock as ls')
                          ->selectRaw('MAX(`liId`) AS liId')
                          ->leftJoin('tbl_agency as ta','ls.agencyId', '=', 'ta.agencyId')
                          ->where('ta.agencyType', $agencyType)
                          ->whereIn('ls.agencyRegion', explode(',', $getAllRegionIDs))
                          ->where('ls.productId', $product->pid)
                          ->whereBetween('ls.visitDate',[$fromDate, $toDate])
                          ->groupBy('ls.agencyId')
                          ->get()->toArray();
            $liIDs = array_column($result, 'liId');

            if (count($liIDs)) {
                  $getStockData = DB::table('tbl_liquidation_detail_stock')
                                      ->selectRaw('COUNT(`liId`) agencyCount, SUM(`supply`) supply,SUM(`remaining`) remaining')
                                      ->whereIn('liId', $liIDs)
                                      ->get()->toArray();
                  $data[$product->pid]['productCatSupply'] = $getStockData[0]->supply;
                  $data[$product->pid]['productCatRemaining'] = $getStockData[0]->remaining;
                  $data[$product->pid]['productName'] = $product->productName;
            } else {
              $data[$product->pid]['productCatSupply'] = 0;
              $data[$product->pid]['productCatRemaining'] = 0;
              $data[$product->pid]['productName'] = $product->productName;
            }
        }
        $data['region_name'] = $region->category_name.'-'.$categoryID;
        $data['employee_name'] = !count($getEmployee) ? '' : $getEmployee[0]->emp_name;

        array_push($reportArray, $data);
      }
      return response()->json([
        'code' => 200,
        'report_data' => $reportArray,
        'productData' => $productData,
        'regionID' => $regionID
      ]);
    }
  }
}
