<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Http\Controllers\APIController;
use App\Models\Employee;
use App\Models\Category;
use App\Models\UpdateKeyNew;

class RegionController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }

  public function getRegionForAddRegion(Request $request) {
    $result = DB::table('tbl_category')->where('parent_category_id','!=',null);
    if ($request->id) {
      $result->where('parent_category_id',$request->id);
      $result->whereNotIn('category_id',[$request->id]);
    }
    $result = $result->get()->toArray();

    // Get All Employee
    $getAllEmployee = Employee::where('deleteFlag', 0)->get()->pluck('id')->toArray();
    $getAllCategory = Category::get()->pluck('category_id')->toArray();
    $resultData = [];
    if ($request->id) {
      foreach ($result as $region) {
        $getEmployee = Employee::select('id', 'region', 'parent_empid')->where('region',$region->category_id)->where('deleteFlag', 0)->get()->toArray();
        $count = count($getEmployee) - 1;
        $data['region_id'] = $region->category_id;
        $data['region_id_index'] = array_search($region->category_id, $getAllCategory) + 1;
        $data['region_name'] = $region->category_name;
        if(count($getEmployee)){
          $data['emp_id'] = $getEmployee[$count]['id'];
          $data['emp_id_index'] = $getEmployee[$count]['id'] ? array_search($getEmployee[$count]['id'], $getAllEmployee) + 1 : '';
          $data['emp_region_id'] = $getEmployee[$count]['region'];
          $data['emp_authority_id'] = $getEmployee[$count]['parent_empid'];
          $data['emp_authority_id_index'] = $getEmployee[$count]['parent_empid'] ? array_search($getEmployee[$count]['parent_empid'], $getAllEmployee) + 1 : '';
        } else {
          $data['emp_id'] = '';
          $data['emp_id_index'] = '';
          $data['emp_region_id'] = '';
          $data['emp_authority_id'] = '';
          $data['emp_authority_id_index'] = '';
        }

        array_push($resultData, $data);
      }
    }

    return response()->json([
      'code' => 200,
      'data' => [
        'result' => $result,
        'result_with_employee' => $resultData,
        'all_category' => $getAllCategory
      ],
    ]);
  }
  
  public function addOrUpdateRegion(Request $request) {
    $removedData = $request['removedRegion'];
    $form = $request['form'];
    $parentRegionID = $request['regionID'];
    foreach ($removedData as $value) {
      $affectedRows = Category::where('category_id', $value)->update(
        array(
          'parent_category_id' => null,
          'unit' => null,
          'region' => null,
          'territory' => null,
          'headquarter' => null,
          'empId' => null,
          'childIds' => null
        )
      );
    }
    foreach ($form as $value) {
      $region_id = $value['region_id'];
      if (!in_array($value['region_id'], $removedData) && $region_id) {
        $array = $request['type'] == 'add' ? ['category_name' => $value['region_name']] : ['category_id' => $value['region_id']];
        $affectedRows = Category::where('category_id', $region_id)->update($array);
      }
      if (!$region_id && $value['region_name']) {
        
        $checkResult = Category::where('category_name', $value['region_name'])->where('parent_category_id',$parentRegionID)->count();
        if($checkResult == 0){
            $affectedRows = new Category();
            $affectedRows->category_name = $value['region_name'];
            $affectedRows->parent_category_id = $parentRegionID;
            $affectedRows->empId = $value['emp_id'];
            $affectedRows->save();
            $region_id = (String)$affectedRows->id;
        }
      }
      $affectedRows = Employee::where('id', $value['emp_id'])->update(
        array(
          'region' => $region_id,
          'parent_empid' => $value['emp_authority_id']
        )
      );
    }
    
    $id = 1;
    $updateKey = UpdateKeyNew::find($id);
    $updateKey->empRegionList += 1;
    $updateKey->save();
    
    return response()->json([
      'code' => 200,
      'message' => "Region updated successfully",
    ]);
  }
}
