<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Http\Controllers\APIController;
use App\Models\Employee;
use App\Models\Category;

class ReadCSVController extends Controller {
  private $apiController;
  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
  private function csvToArray($filename = '', $delimiter = ',') {
    if (!file_exists($filename) || !is_readable($filename))
        return false;

    $header = null;
    $data = array();
    if (($handle = fopen($filename, 'r')) !== false) {
        while (($row = fgetcsv($handle, 1000, $delimiter)) !== false) {
            //print_r($header);
            if (!$header)
                $header = $row;
            else
                $data[] = array_combine($header, $row);
        }
        fclose($handle);
    }

    return $data;
  }
  private function getHeader($filename = '', $delimiter = ',') {
    if (!file_exists($filename) || !is_readable($filename))
        return false;

    $header = null;
    $data = array();
    if (($handle = fopen($filename, 'r')) !== false) {
      $row = fgetcsv($handle, 1000, $delimiter);
      $header = $row;
      fclose($handle);
    }

    return $header;
  }
  public function uploadAndGetData($file) {
    $destinationPath = 'uploads';
    $fileName = '_csvfile'.time().'.csv';
    $file->move($destinationPath, $fileName);
    $file = public_path('uploads/'.$fileName);
    $getHeader = $this->getHeader($file);
    $getDataWithoutHeader = $this->csvToArray($file);

    return [
      'header' => $getHeader,
      'data' => $getDataWithoutHeader,
      'filename' => $file
    ];
  }
  public function readCSVFile(Request $request) {
    try {
      $file = $request->file('file');
      $getCSVData = $this->uploadAndGetData($file);
      unlink($getCSVData['filename']);

      return response()->json([
        'code' => 200,
        'message' => "File read successfully",
        'data' => $getCSVData
      ]);
    } catch (\Exception $e) {
      echo "string".$e->getMessage();
    }


  }
}
