<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\ProductScheme;
use App\Http\Controllers\APIController;
use Illuminate\Support\Facades\Storage;
use Auth;
use Carbon\Carbon;

class ProductSchemeController extends Controller
{
    public function addProductScheme(Request $request)
    {
        $productscheme = $request->id ? ProductScheme::find($request->id) : new ProductScheme();

       $filePath = '';
    if ($request->hasFile('file')) {
   
    $clientDirectory = $request->header('usedwhich');
      $path = $request->file('file')->store('/'.$clientDirectory.'/schemes', 's3');
      $fileName = explode('/schemes/', $path)[1];
      $filePath = Storage::disk('s3')->url($path); // Generate a public URL for the uploaded image
    }

        $productscheme->schemename = $request->schemeName;
        $productscheme->productDescription = $request->productDescription;
        $productscheme->file_type = $request->file_type;
        $productscheme->path = $fileName;
        $productscheme->date = $request->date;
        $productscheme->region = $request->region;
        // $productscheme->status = $request->status ? 1 : 0;
        $productscheme->save();

        return response()->json([
            'code' => 200,
            'message' => $request->id ? 'Product Scheme updated' : 'Product Scheme added',
        ]);
    }
    public function getProductScheme(Request $request)
{
    try {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        $result = DB::table('tbl_scheme as ts');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ts.schemename', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tce.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result->leftJoin('tbl_category as tce', 'tce.category_id', '=', 'ts.region')->select('*');

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('ts.date', [$fromDate, $toDate]);
        }

        if ($request->staustype != '') {
            $result = $result->where('ts.isActivated', $request->staustype);
        }

        if ($request->regionIndex && $request->regionIndex != 'NA') {
            $result = $result->where('ts.region', $request->regionIndex);
        }

        // Get the total record count
        $totalCount = $result->count();

        $result = $result->orderBy('ts.id', 'DESC')->paginate();

        return response()->json([
            'code' => 200,
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data",
        ]);
    }
}

    public function getDeactivatedProductScheme(Request $request)
    {
        try {
            $result = DB::table('tbl_scheme as ts');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('ts.schemename', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ts.date', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tce.category_name', 'like', '%' . $request->keyword . '%');
                });
            }
            // dd($request->fileType);
            $result = $result
                ->leftJoin('tbl_category as tce', 'tce.category_id', '=', 'ts.region')
                ->select('*')
                ->where('ts.isActivated', false);

            if ($request->fileType && $request->fileType != 'NA') {
                $result = $result->where('ts.file_type', $request->fileType);
            }
            if ($request->regionIndex && $request->regionIndex != 'NA') {
                $result = $result->where('ts.region', $request->regionIndex);
            }
            $result = $result->orderBy('ts.id', 'desc')->paginate();

            return response()->json([
                'code' => 200,
                'data' => $result,
            ]);
        } catch (\Exception $e) {
            dd($e->getMessage());
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    public function deleteProductScheme(Request $request)
    {
        $productscheme = ProductScheme::find($request->id);
        $productscheme->isActivated = false;
        $productscheme->isDeleted = true;
        $productscheme->save();

        return response()->json([
            'code' => 200,
            'message' => "Product Scheme deleted successfully",
        ]);
    }
    //   public function ApproveProductScheme(Request $request) {
    //     $productscheme = ProductScheme::find($request->id);
    //     $productscheme->isActivated = true;
    //     $productscheme->save();

    //     return response()->json([
    //       'code' => 200,
    //       'message' => "Product Scheme Approve successfully",
    //     ]);
    //   }
    public function ApproveProductScheme(Request $request)
    {
        try {
            $productscheme = ProductScheme::where('id', $request->id)->update(['isActivated' => true]);

            return response()->json([
                'code' => 200,
                'message' => "Scheme activated successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
}
