<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Product;
use App\Models\ActivityProduct;
use App\Models\UpdateKeyNew;
use App\Models\RegionWisePrice;
use App\Http\Controllers\ReadCSVController;
use StaticArray;

class ProductController extends Controller
{
    private $readCSVController;

    public function __construct(APIController $apiController, ReadCSVController $readCSVController)
    {
        $this->readCSVController = $readCSVController;
    }
    // add activity product
   public function submitProduct(Request $request)
{
    $validator = Validator::make($request->all(), [
        'productName' => 'required|string',
        'productType' => 'required|integer',
        'status' => 'required|boolean',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'code' => 400,
            'message' => 'Validation error',
            'errors' => $validator->errors(),
        ], 400);
    }

    if ($request->id) {
        return $this->updationProduct($request);
    } else {
        $productData = new ActivityProduct();

        $productData->productName = $request->productName;
        $productData->productType = $request->productType;
        $productData->status = $request->status;
        $productData->save();

        $updateKey = UpdateKeyNew::find(1);
        $updateKey->activityProductList += 1;
        $updateKey->save();

        return response()->json([
            'code' => 200,
            'message' => 'Data saved successfully',
        ]);
    }
} 

// update activity product
public function updationProduct(Request $request)
{
    
    $productData = ActivityProduct::where('pid', $request->id)->first();

    if (!$productData) {
        return response()->json([
            'code' => 404,
            'message' => 'Product not found',
        ], 404);
    }

    ActivityProduct::where('pid', $request->id)
        ->update([
            'productName' => $request->productName,
            'productType' => $request->productType,
            'status' => $request->status
        ]);
    
    return response()->json([
        'code' => 200,
        'message' => 'Data updated successfully',
    ]);
}

// get activity product
    public function getProduct(Request $request)
{
    try {
        $result = DB::table('tbl_activity_product as tpc');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tpc.productName', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result->leftJoin('tbl_product_type as te', 'te.id', '=', 'tpc.productType')
            ->where('tpc.isDeleted', false)
            ->orderBy('tpc.created_at', 'desc');

        // Get the total record count
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select('tpc.pid', 'tpc.productName', 'te.prodType', 'tpc.status');
        } else {
            $result = $result->select('tpc.*', 'te.*');
        }

        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        dd($e->getMessage());
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data",
        ]);
    }
}

// delete activity product
    public function deleteProduct(Request $request)
    {
        $agency = ActivityProduct::where('pid', $request->id)->update(['isDeleted' => true]);

        return response()->json([
            'code' => 200,
            'message' => "Product deleted successfully",
        ]);
    }
    private function validateCSVHeader($csvHeader, $staticHeader)
    {
        $result = false;
        if (count($csvHeader) != count($staticHeader)) {
            $result = true;
        } else {
            for ($i = 0; $i < count($staticHeader); $i++) {
                if ($staticHeader[$i] != $csvHeader[$i]) {
                    $result = true;
                    break;
                }
            }
        }
        return $result;
    }
    
    //  import billing product
    public function importproductV1(Request $request)
    {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$productArray);

        if ($validateCSVFIle) {
            return response()->json([
                'code' => 500,
                'message' => "Invalid CSV file uploaded",
            ]);
        }

        foreach ($uploadAndGetData['data'] as $value) {
            $getProductType = DB::table('tbl_product_type')
                ->select('id')
                ->where('prodType', $value['ProductType'])
                ->get()
                ->toArray();
            $checkProductExist = DB::table('tbl_product')
                ->where('productName', $value['ProductName'])
                ->select('pid')
                ->get()
                ->toArray();
            if (!count($checkProductExist)) {
                $product = new Product();
                $product->productName = $value['ProductName'];
                $product->productType = $getProductType[0]->id;
                $product->tradeDiscount = $value['TradeDiscount'];
                $product->gst = $value['GST'];
                $product->save();

                $regionwisePrice = new RegionWisePrice();
                $regionwisePrice->regionId = $request->region_id;
                $regionwisePrice->productId = $product->pid;
                $regionwisePrice->price = $value['Rate'];
                $regionwisePrice->gst_no = $value['GST'];
                $regionwisePrice->save();
            }
        }
        
        $id = 1;
        $updateKey = UpdateKeyNew::find($id);
        $updateKey->productList += 1;
        $updateKey->save();
            
        return response()->json([
            'code' => 200,
            'message' => "CSV file uploaded successfully",
        ]);
    }
    
    public function importproduct(Request $request) {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        // dd($uploadAndGetData['data']);
        $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$productArray);
    
        if ($validateCSVFIle) {
          return response()->json([
            'code' => 500,
            'message' => "Invalid CSV file uploaded",
          ]);
        }
        
        foreach ($uploadAndGetData['data'] as $value) {
        //   $getProductType = DB::table('tbl_product_type')->select('id')->where('prodType', $value['ProductType'])->first()->get()->toArray();
            $checkProductExist = DB::table('tbl_product')->where('productName', $value['ProductName'])->select('pid')->get()->toArray();
            $getProductType = DB::table('tbl_product_type')->select('id')->where('prodType', $value['ProductType'])->first();
            $checkProductExist = DB::table('tbl_product')->where('productName', $value['ProductName'])->select('pid')->get()->toArray();
            // print_r($getProductType);
            if ($getProductType) {
                $getProductType = $getProductType->id;
            } else {
                $getProductType = 0; 
            }
          if (!count($checkProductExist)) {
            $product = new Product();
            $product->skuId = $value['skuId'];
            $product->productName = $value['ProductName'];
            $product->productType = $getProductType;
            $product->tradeDiscount = $value['TradeDiscount'];
            $product->gst = $value['GST'];
            $product->save();
            
            $productId = $product->pid;
          }else{
            $productId = $checkProductExist[0]->pid;  
          }
          
          $checkProductPriceExist = DB::table('tbl_regionwise_price')->where('productId', $productId)->where('regionId',$request->region_id)->select('rpId')->get()->toArray();
          if (!count($checkProductPriceExist))
          {
            $regionwisePrice = new RegionWisePrice();
            $regionwisePrice->regionId = $request->region_id;
            $regionwisePrice->productId = $productId;
            $regionwisePrice->price = $value['Rate'];
            $regionwisePrice->gst_no = $value['GST'];
            $regionwisePrice->save();
          }else{
            $rpID = $checkProductPriceExist[0]->rpId;
            $updateData = RegionWisePrice::where('rpId', $rpID)->update([
            'regionId' => $request->region_id,
            'productId' => $productId, 
            'price' => $value['Rate'],
            'gst_no' => $value['GST']
            
            ]);  
          }
        }
    
        return response()->json([
          'code' => 200,
          'message' => "CSV file uploaded successfully",
        ]);
  }
    public function importActivityProduct(Request $request)
    {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$activityProductArray);
        // print_r($uploadAndGetData['header']);
        if ($validateCSVFIle) {
            return response()->json([
                'code' => 500,
                'message' => "Invalid CSV file uploaded",
            ]);
        }

        foreach ($uploadAndGetData['data'] as $value) {
            $getProductType = DB::table('tbl_product_type')
                ->select('id')
                ->where('prodType', $value['ProductType'])
                ->get()
                ->toArray();
            $checkProductExist = DB::table('tbl_activity_product')
                ->where('productName', $value['ProductName'])
                ->select('pid')
                ->get()
                ->toArray();
            if (!count($checkProductExist)) {
                $product = new ActivityProduct();
                $product->productName = $value['ProductName'];
                $product->productType = $getProductType[0]->id;
                $product->save();
            }
        }
        
        $id = 1;
        $updateKey = UpdateKeyNew::find($id);
        $updateKey->activityProductList += 1;
        $updateKey->save();
        return response()->json([
            'code' => 200,
            'message' => "CSV file uploaded successfully",
        ]);
    }
}
