<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\User;
use App\Models\ProductCatlog;
use App\Models\PrpductCatlogController;
use App\Models\UpdateKeyNew;
use App\Http\Controllers\APIController;
use Auth;
use Carbon\Carbon;

class ProductCatlogController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }

    public function addProductCatlog(Request $request)
    {
        if ($request->id) {
            $productcatlog = ProductCatlog::find($request->id);
        } else {
            $productcatlog = new ProductCatlog();
        }

        $fileName = '';

        if ($request->hasFile('file')) {
            // $file = $request->file('file');
            // $fileName = time().'_'.$file->getClientOriginalName();
            $clientDirectory = $request->header('usedwhich');
            $path = $request->file('file')->store('/' . $clientDirectory . '/product-catlog', 's3');
            $fileName = explode('/product-catlog/', $path)[1];
            $filePath = Storage::disk('s3')->url($path); // Generate a public URL for the uploaded image

            // $destinationPath = 'uploads';
            // if ($request->file_type === 3) {
            //   $destinationPath = 'pdf';
            // } else if ($request->file_type === 2) {
            //   $destinationPath = 'audio';
            // } else if ($request->file_type === 1) {
            //   $destinationPath = 'video';
            // }
            // $filePath = $destinationPath.'/'.$fileName;
            // $file->move($destinationPath, $fileName);
        } else {
            $fileName = $request->videoUrl;
        }

        if ($request->file_type == 1) {
            $fileName = $request->videoUrl;
        }

        $productcatlog->name = $request->productName;
        $productcatlog->description = $request->productDescription;
        $productcatlog->file_type = $request->file_type;
        $productcatlog->path = $fileName;
        $productcatlog->date = $request->date;
        $productcatlog->sendtoType = $request->sendtoType == 'employee' ? 1 : 2;
        $productcatlog->sendto_id = $request->sendToId;
        $productcatlog->save();

        $id = 1;
        $updateKey = UpdateKeyNew::find($id);
        $updateKey->catlogList += 1;
        $updateKey->save();

        return response()->json([
            'code' => 200,
            'message' => "New Product Catlog added",
        ]);
    }
    public function getProductCatlog(Request $request)
    {
        try {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $toDate = $request->toDate;
            $result = DB::table('tbl_productcatlog as tpc');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('tpc.name', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_category as tce', 'tce.category_id', '=', 'tpc.sendto_id')
                ->leftJoin('tbl_employee as te', 'te.id', '=', 'tpc.sendto_id')
                ->select('tpc.*', 'te.*', 'tce.*', 'tpc.id as cid')
                ->whereBetween('tpc.date', [$fromDate, $toDate])
                ->where('tpc.isDeleted', false);
            if ($request->fileType && $request->fileType != 'NA') {
                $result = $result->where('tpc.file_type', $request->fileType);
            }
            if ($request->sendToID) {
                $result = $result->where('tpc.sendto_id', $request->sendToID);
            }
            if ($request->sendToType) {
                $result = $result->where('tpc.sendtoType', $request->sendToType);
            }
            $result = $result->orderBy('tpc.id', 'DESC')->paginate();

            return response()->json([
                'code' => 200,
                'data' => $result,
            ]);
        } catch (\Exception $e) {
            dd($e->getMessage());
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    public function deleteProductCatlog(Request $request)
    {
        $productcatlog = ProductCatlog::find($request->id);
        $productcatlog->isDeleted = true;
        $productcatlog->save();

        return response()->json([
            'code' => 200,
            'message' => "Product Catlog deleted successfully",
        ]);
    }
}
