<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Product;
use App\Models\PaymentTarget;
use App\Http\Controllers\APIController;
use Carbon\Carbon;

class PaymentTargetController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    public function submitPaymentTarget(Request $request)
    {
        // dd($request->all());
        try {
            $result = DB::table('tbl_employee')->where('id',$request->empId)->first();
            $empRegion = $result->region;
            $getlastDateOfMonth = date('t');
            $fromDate = date('Y-m-01');
            $toDate = date('Y-m-'.$getlastDateOfMonth);
            
            if ($request->id) {
                $PaymentTargetData = PaymentTarget::find($request->id);
            } else {
                $PaymentTargetData = new PaymentTarget();
            }
            
            $PaymentTargetData->empId = $request->empId; 
            $PaymentTargetData->regionId = $empRegion; 
            $PaymentTargetData->fromDate = $fromDate;
            $PaymentTargetData->toDate = $toDate;
            $PaymentTargetData->agencyId = $request->agencyId;
            $PaymentTargetData->amount = $request->amount;
            $PaymentTargetData->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }
    
    public function getPaymentTarget(Request $request)
    {
        try 
        {
            $result = DB::table('tbl_payment_target as t1')
                    ->leftJoin('tbl_employee as t2', 't2.id', '=', 't1.empId')
                    ->leftJoin('tbl_agency as t3', 't3.agencyId', '=', 't1.agencyId')
                    ->where('t1.deleteFlag',0);
            if ($request->timeslot) {
                $timeFrame = explode('#',$request->timeslot);
                $fromDate = $timeFrame[0];
                $toDate = $timeFrame[1];
                $result = $result->where('t1.fromDate', $fromDate)
                                 ->where('t1.toDate', $toDate);
            }else{
                $getlastDateOfMonth = date('t');
                $fromDate = date('Y-m-01');
                $toDate = date('Y-m-'.$getlastDateOfMonth);
                $result = $result->where('t1.fromDate', $fromDate)
                                 ->where('t1.toDate', $toDate);
            }
            
            if ($request->empID) {
                $result = $result->where('t1.empId', $request->empID);
            }
            if ($request->keyword) {
                $result = $result->where(function ($query) use ($request) {
                    $query
                        ->where('t2.emp_name', 'like', '%' . $request->keyword . '%')
                        ->orWhere('t3.agencyShopName', 'like', '%' . $request->keyword . '%');
                });
            }
            $totalCount = $result->count();
            if ($request->paginate == "true") {
                $result = $result
                    ->select('t1.id as paymentTargetId','t1.amount','t3.agencyShopName','t2.emp_name','t1.agencyId','t1.empId')
                    ->simplePaginate();
            } else {
                $result = $result
                    ->select('t1.amount','t3.agencyShopName','t2.emp_name')
                    ->get()
                    ->toArray();
            }
            
            return response()->json([
                'code' => 200,
                'message' => "Payment Target fetched successfully",
                'totalCount' => $totalCount,
                'data' => $result,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }
    //delete payment target
    public function deletePaymentTarget(Request $request)
    {
        try
        {
            $PaymentTarget = PaymentTarget::find($request->id);
            $PaymentTarget->deleteFlag = 1;
            $PaymentTarget->updated_at = date('Y-m-d h:i:s');
            $PaymentTarget->save();
    
            return response()->json([
                'code' => 200,
                'message' => "Payment target deleted successfully",
            ]);
        }catch(\Exception $e){
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong",
            ]);
        }
    }
    public function getEmployeePaymentTargetTimeframe(Request $request){
        
        $queryResult = PaymentTarget::select(DB::raw('DISTINCT(fromDate) as fromDateSlot'), 'toDate as toDateSlot')
            ->orderBy('fromDate', 'DESC')
            ->get();

        $options = [];

        foreach ($queryResult as $data) {
            
            $options[] = [
                'value'    => $data->fromDateSlot.'#'.$data->toDateSlot,
                'label'    => date('d M Y', strtotime($data->fromDateSlot)).' - '.date('d M Y', strtotime($data->toDateSlot))
            ];
        }

        return response()->json(['options' => $options]);
        
    }
    public function fetchPaymentAchieved($from, $to,$regionID)
    {
        
        $getAllRegionId = $this->apiController->getRegionId($regionID);
        // Fetch order achieved data
        $paymentAchievedArray = DB::table('tbl_payment as t1')
                    ->whereIn('t1.region', explode(',', $getAllRegionId)) 
                    ->whereBetween('t1.chequeDate', [$from, $to])
                    ->groupBy('t1.dealerName', 't1.collected_by')
                    ->select('t1.dealerName', 't1.collected_by', DB::raw('SUM(t1.amountPaid) as totAmountPaid'))
                    ->get();

        $response = [];

        // Build the response array indexed by empId and pid
        foreach ($paymentAchievedArray as $rowData) {
            $response[$rowData->collected_by][$rowData->dealerName] = $rowData->totAmountPaid;
        }

        return $response;
    }
    
    public function getPaymentAchieveTarget(Request $request){
        if($request->timeslot){
            $timeslotVal = explode('#',$request->timeslot);
            $from = $timeslotVal[0];
            $to = $timeslotVal[1];
        }else{
            $from = date('Y-m-01');
            $to = date('Y-m-t');
        }
        $paymentAchievedArray = $this->fetchPaymentAchieved($from,$to,$request->regionIndex);
        // Fetch order target data
        $paymentTargets = DB::table('tbl_payment_target as t1')
                        ->select('t1.*', 't2.*', 't3.*', 't1.id as paymentTId')
                        ->leftJoin('tbl_employee as t2', 't2.id', '=', 't1.empId')
                        ->leftJoin('tbl_agency as t3', 't3.agencyId', '=', 't1.agencyId')
                        ->where('t1.fromDate', $from)
                        ->where('t1.toDate', $to)
                        ->where('t1.deleteFlag', 0);
        
        if($request->empID){
            $paymentTargets = $paymentTargets->where('t1.empId',$request->empID);
        }else{
            $getAllEmployeeId = $this->apiController->getEmployeeId($request->regionIndex);
            // print
            $paymentTargets = $paymentTargets->whereIN('t1.empId',$getAllEmployeeId);
        } 
        if ($request->keyword) {
            $paymentTargets = $paymentTargets->where(function ($query) use ($request) {
                $query->where('t2.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t3.agencyShopName', 'like', '%' . $request->keyword . '%');
            });
        }

        if($request->paginate == 'true'){
            $paymentTargets = $paymentTargets->paginate(15);
            $paginationDetails = $paymentTargets->toArray();
            unset($paginationDetails['data']);
            
        } else {
            $paymentTargets = $paymentTargets->get();
            $paginationDetails = null;
        }
        $paymentAchieveTargetData = array();
        // Merge achieved quantity with order target data
        foreach ($paymentTargets as $paymentTarget) {
            if (isset($paymentAchievedArray[$paymentTarget->eid][$paymentTarget->agencyId])) {
                $achiveAmount = $paymentAchievedArray[$paymentTarget->eid][$paymentTarget->agencyId];
            } else {
                $achiveAmount = 0; 
            }
            array_push($paymentAchieveTargetData,array(
                'emp_name' => $paymentTarget->emp_name,
                'agencyShopName' => $paymentTarget->agencyShopName,
                'targetAmount' => $paymentTarget->amount,
                'achiveAmount' => $achiveAmount
            ));
        }
        
        
        return response()->json([
            'report_data' => $paymentAchieveTargetData,
            'pagination_details' => $paginationDetails,
        ]); 

    }
    
    
    
    
}