<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\PaymentPurpose;
use App\Models\UpdateKeyNew;
use App\Http\Controllers\APIController;

class PaymentPurposeController extends Controller
{
    private $apiController;
    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
        // $this->SendSMSController = $SendSMSController;
    }
    
    public function submitPaymentPurpose(Request $request)
    {
        if ($request->id) {
            $this->updatePaymentPurpose($request);
            return response()->json([
                'code' => 200,
                'message' => "Data update successfully",
            ]);
        } else {
            try {
                $revisitData = $request->id ? PaymentPurpose::find($request->id) : new PaymentPurpose();
    
                $revisitData->purpose_name = $request->Paymentpurpose_name;
                $revisitData->revisit_status = $request->revisit_status;
                $revisitData->save();
                $id = 1;
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->purposeList += 1;
                $updateKey->save();
    
                return response()->json([
                    'code' => 200,
                    'message' => "Data Save successfully",
                ]);
            } catch (\Exception $e) {
                return response()->json([
                    'code' => 500,
                    'error' => $e->getMessage(),
                    'message' => "Something went wrong while saving data",
                ]);
            }
        }
    }
    
    private function updatePaymentPurpose($request) {
        try {
            PaymentPurpose::where('purpose_id', $request->id)
                ->update([
                    'purpose_name' => $request->Paymentpurpose_name,
                    'revisit_status' => $request->revisit_status              
                ]);
            return response()->json([
                'code' => 200,
                'message' => "Revisit Purpose updated successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while updating AV Purpose",
            ]);
        }
    } 
      public function getPaymentPurpose(Request $request) {
        // try {
            $revisitData = PaymentPurpose::select('*')->where('deleteFlag', false);
            
            $revisitData->orderBy('created_at', 'desc');
          
            if ($request->keyword) {
                $revisitData = $revisitData->where(function ($query) use ($request) {
                    $query->where('purpose_name', 'like', '%' . $request->keyword . '%');
                          
                });
            }
            if ($request->paginate == "true") {
                $revisitData = $revisitData->paginate();
            } else {
                $revisitData = $revisitData->get()->toArray();
            }
                         

          return response()->json([
            'code' => 200,
            'data' => $revisitData
          ]);
        // } catch (\Exception $e) {
        //   return response()->json([
        //     'code' => 500,
        //     'message' => "Something went wrong while saving data"
        //   ]);
        // }
      }



    public function deletePaymentPurpose(Request $request)
    {
        try {
            PaymentPurpose::where('purpose_id', $request->id)
                ->update([
                    'deleteFlag' => 1
                ]);
            return response()->json([
                'code' => 200,
                'message' => "Revisit Purpose deleted successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting revisit purpose",
            ]);
        }
    }



}
