<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Payment;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\APIController;
use Illuminate\Support\Facades\Auth;
class PaymentController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }

    public function getPayment(Request $request)
    {

        $result = DB::table('tbl_payment as tp');

        $fromDate = date('Y-m-d 00:00:00', strtotime($request->fromDate));
        $toDate = date('Y-m-d 23:59:59', strtotime($request->toDate));

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentMethod', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.amountPaid', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.UTRNo', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.bankName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.branchName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentAgainst', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.check_numb', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.chequeDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                // $query->orWhere('tc.tbl_category', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
            ->where('tp.approvstatus', 0);

        // Get the total record count
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select(
                'tp.id',
                DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tc.category_name',
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate',
                'tp.UTRNo'
            );
        } else {
            $result = $result->select('tp.id',
                DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tc.category_name',
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate',
                'tp.UTRNo');
        }

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.created_at', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tp.collected_by', $request->empID);
        }

        if ($request->regionIndex) {
            $regionId = $request->regionIndex;
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
            $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        }

        if ($request->agencyIndex) {
            $result = $result->where('tp.dealerName', $request->agencyIndex);
        }

        $result = $result->orderBy('tp.created_at', 'desc');

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Payment fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }
    
    // agencywise payment data
    public function getAgencyWisePayment(Request $request)
    {
    //     $companyCode = $request->eid;
        
    //     if ($companyCode == NULL) {
    //         $companyCode = $username;
    //         $username = $username . "-admin";
    //     }
        
    //     $dbName = "imconnect_" . $companyCode;
        
    //     $clientStatus = DB::connection('mysql')
    //         ->table('tbl_clients')
    //         ->where('dbname', $companyCode)
    //         ->where('status', 'Active')
    //         ->first(); // Use first() to retrieve a single client record
        
    //     if (!$clientStatus) {
    //         // Log an error message to help with troubleshooting
    //         \Log::error('Company status not found for dbname: ' . $companyCode);
            
    //         return response()->json([
    //             'code' => 500,
    //             'message' => "Services Suspended for the Company!",
    //         ]);
    //     }

    // // Extract the cuname from the authenticated user
    // // Assuming you have a method or attribute on the user model to get the cuname
    //     $cuname = $user->c_name; // Make sure you replace this with the actual way to get the cuname
        $result = DB::table('tbl_payment as tp');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $regionID = $request->regionID;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentMethod', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.amountPaid', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.UTRNo', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.bankName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.branchName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentAgainst', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.check_numb', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.chequeDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                // $query->orWhere('tc.tbl_category', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
            ->where('tp.approvstatus', 0);

        if ($request->paginate == "true") {
            $result = $result->select(
                'tp.id',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tc.category_name',
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate',
                'tp.UTRNo'
            );
        } else {
            $result = $result->select(
                'tp.id',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tc.category_name',
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate',
                'tp.UTRNo'
            );
        }

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.created_at', [$fromDate, $toDate]);
        }

        if ($request->agencyIndex) {
            $result = $result->where('tp.dealerName', $request->agencyIndex);
        }else{
            $getAllRegionIDs = $this->apiController->getRegionId($regionID);
            $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        }

        
        $result = $result->orderBy('tp.created_at', 'desc');
        // Get the total record count
        $totalCount = $result->count();
        
        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Payment fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
            // 'cuname' => $cuname, // Add 'cuname' 
        ]);
    }
    
    // employeewise payment data
    public function getEmployeeWisePayment(Request $request)
    {
        
        $result = DB::table('tbl_payment as tp');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $regionID = $request->regionID;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentMethod', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.amountPaid', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.UTRNo', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.bankName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.branchName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentAgainst', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.check_numb', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.chequeDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                // $query->orWhere('tc.tbl_category', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
            ->where('tp.approvstatus', 0);

        if ($request->paginate == "true") {
            $result = $result->select(
                'tp.id',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tc.category_name',
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate',
                'tp.UTRNo'
            );
        } else {
            $result = $result->select('tp.*', 'te.*', 'ta.*', 'tc.category_name');
        }

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.chequeDate', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('te.id', $request->empID);
        }else{
            $getAllRegionIDs = $this->apiController->getRegionId($regionID);
            $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        }

        // if ($request->regionIndex) {
        //     $regionId = $request->regionIndex;
        //     $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
        //     $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        // }

        // if ($request->agencyIndex) {
        //     $result = $result->where('tp.dealerName', $request->agencyIndex);
        // }

        $result = $result->orderBy('tp.id', 'desc');
        // Get the total record count
        $totalCount = $result->count();
        
        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Payment fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
            // 'cuname' => $cuname, // Add 'cuname' 
        ]);
    }

    public function submitPayment(Request $request)
    {
        try {
            $paymentData = $request->id ? Payment::find($request->id) : new Payment();
            $filePath = '';
            if ($request->hasFile('file')) {
                $clientDirectory = $request->header('usedwhich');
                $path = $request->file('file')->store('/' . $clientDirectory . '/payment', 's3');
                $fileName = explode('/payment/', $path)[1];
                $filePath = Storage::disk('s3')->url($path); // Generate a public URL for the uploaded image
            }

            $paymentData->payId = 'p' . date('Ymdhis');
            $paymentData->date = $request->date;
            $paymentData->dealerName = $request->agency;
            $paymentData->paymentMethod = $request->paymentMethod;
            $paymentData->amountPaid = $request->amountPaid;
            $paymentData->UTRNo = $request->UTRNo;
            $paymentData->bankName = $request->bankName;
            $paymentData->branchName = $request->branchName;
            $paymentData->depositedIn = $request->depositedIn;
            $paymentData->paymentAgainst = $request->paymentAgainst;
            $paymentData->collected_by = $request->collected_by;
            $paymentData->check_numb = $request->check_numb;
            $paymentData->chequeDate = $request->chequeDate;
            $paymentData->payimg = $filePath;
            $paymentData->region = $request->region;
            $paymentData->approvstatus = 0;
            $paymentData->save();

            return response()->json([
                'code' => 200,
                // 'message' => "Data Save successfully"
                'message' => $request->id ? 'payment updated' : 'payment added',
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    
    public function getApprovedRejectPayment(Request $request)
    {
        $result = DB::table('tbl_payment as tp');

        $fromDate = date('Y-m-d 00:00:00', strtotime($request->fromDate));
        $toDate = date('Y-m-d 23:59:59', strtotime($request->toDate));

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentMethod', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.amountPaid', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.UTRNo', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.bankName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.branchName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.approvstatus', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentAgainst', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.check_numb', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.chequeDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                // $query->orWhere('tc.tbl_category', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
            ->where(function ($query) {
                $query->where('tp.approvstatus', 1)->orWhere('tp.approvstatus', 2);
            });

        // Get the total record count
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select(
                'tp.id',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.approvstatus',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate'
            );
        } else {
            $result = $result->select(
                'tp.id',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.approvstatus',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate');
        }

        $result = $result->orderBy('tp.id', 'desc');

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.created_at', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tp.collected_by', $request->empID);
        }

        if ($request->regionIndex) {
            $regionId = $request->regionIndex;
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
            $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        }

        if ($request->agencyIndex) {
            $result = $result->where('tp.dealerName', $request->agencyIndex);
        }

        if ($request->staustype) {
            $result = $result->where('tp.approvstatus', $request->staustype);
        }

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Payment fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }
    
    // agencywise payment report
    public function getAgencyWiseApprovedRejectPayment(Request $request)
    {
        $result = DB::table('tbl_payment as tp');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentMethod', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.amountPaid', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.UTRNo', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.bankName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.branchName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.approvstatus', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentAgainst', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.check_numb', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.chequeDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                // $query->orWhere('tc.tbl_category', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region');

        
        if ($request->paginate == "true") {
            $result = $result->select(
                'tp.id',
                'tp.dealerName',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.approvstatus',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate'
            );
        } else {
            $result = $result->select(
                'tp.id',
                'tp.dealerName',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.approvstatus',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate');
        }

        $result = $result->orderBy('tp.id', 'desc');

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.chequeDate', [$fromDate, $toDate]);
        }

        if ($request->agencyIndex) {
            $result = $result->where('tp.dealerName', $request->agencyIndex);
        }else{
            $regionId = $request->regionID;
            $getAllRegionIDs = $this->apiController->getRegionId($regionId);
            $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        }

        if ($request->staustype) {
            $result = $result->where('tp.approvstatus', $request->staustype);
        }else{
            $result = $result->whereIN('tp.approvstatus', [1,2]);
        }
        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Payment fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }
    
    // employeewise payment report
    public function getEmployeeWiseApprovedRejectPayment(Request $request)
    {
        $result = DB::table('tbl_payment as tp');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentMethod', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.amountPaid', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.UTRNo', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.bankName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.branchName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.approvstatus', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.paymentAgainst', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.check_numb', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.chequeDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.depositedIn', 'like', '%' . $request->keyword . '%');
                // $query->orWhere('tc.tbl_category', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region');

        
        if ($request->paginate == "true") {
            $result = $result->select(
                'tp.id',
                'tp.dealerName',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.approvstatus',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate'
            );
        } else {
            $result = $result->select(
                'tp.id',
                'tp.dealerName',
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                 DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.approvstatus',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.chequeNo',
                'tp.chequeDate');
        }

        $result = $result->orderBy('tp.id', 'desc');

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.chequeDate', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('te.id', $request->empID);
        }else{
            $regionId = $request->regionID;
            $getAllRegionIDs = $this->apiController->getRegionId($regionId);
            $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
        }

        if ($request->staustype) {
            $result = $result->where('tp.approvstatus', $request->staustype);
        }else{
            $result = $result->whereIn('tp.approvstatus', [1,2]);
        }
        
        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([ 
            'code' => 200,
            'message' => "Payment fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }

    public function approvePayment(Request $request)
    {
        try {
            $approveData = Payment::where('id', $request->id)->update([
                'approvstatus' => 1,
                'Aprove_Date' => now(), // Use `now()` function to get the current date and time
            ]);

            return response()->json([
                'code' => 200,
                'message' => "Payment Approved successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong ",
            ]);
        }
    }

    public function rejectPayment(Request $request)
    {
        try {
            $approveData = Payment::where('id', $request->id)
                ->where('approvstatus', 0)
                ->update([
                    'approvstatus' => 2,
                    'Aprove_Date' => now(), // Use `now()` function to get the current date and time
                ]);

            return response()->json([
                'code' => 200,
                'message' => "Payment Rejected successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong ",
            ]);
        }
    }
}
