<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Outstanding;
use App\Http\Controllers\APIController;
use Illuminate\Support\Facades\Storage;
class OutstandingController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
  public function addOutstanding(Request $request) {
    $outstanding = $request->id ? Outstanding::find($request->id) : new Outstanding();

    $filePath = '';
    if ($request->hasFile('file')) {
    //   $file = $request->file('file');
    //   $fileName = time().'_'.$file->getClientOriginalName();

    //   $destinationPath = 'uploads';

    //   $filePath = $destinationPath.'/'.$fileName;
    //   $file->move($destinationPath, $fileName);
    $clientDirectory = $request->header('usedwhich');
      $path = $request->file('file')->store('/'.$clientDirectory.'/outstanding', 's3');
      $fileName = explode('/outstanding/', $path)[1];
      $filePath = Storage::disk('s3')->url($path); // Generate a public URL for the uploaded image
    }

    $outstanding->outstandingname = $request->outstandingname;
    $outstanding->disc =  $request->disc;
    $outstanding->filepath =  $fileName;
    $outstanding->region =  $request->region;
    $outstanding->activestatus =  $request->activestatus ? 1 : 0;
    $outstanding->save();


    return response()->json([
      'code' => 200,
      'message' => $request->id ? 'Oustanding updated' : 'Oustanding added',
    ]);
  }
        public function getOutstanding(Request $request)
{
    $result = DB::table('tbl_outstanding as tp')
        ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
        ->select('tp.id', 'tp.created_at', 'tp.outstandingname', 'tc.category_name', 'tp.filepath', 'tp.disc', 'tp.activestatus')
        ->orderBy('tp.created_at', 'desc'); // Specify the table alias 'tp' for created_at column

    $fromDate = $request->fromDate;
    $toDate = $request->toDate;
    $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
    //$getAllRegionIDs = rtrim($categoryIDWithParent,',');
    //$getAllRegionIDs = $categoryIDWithParent;

    if ($request->keyword) {
        $result = $result->where(function($query) use($request) {
            $query->where('tp.outstandingname', 'like', '%'.$request->keyword.'%');
            $query->orWhere('tc.category_name', 'like', '%'.$request->keyword.'%');
        });
    }

    if ($request->staustype) {
        $value = $request->staustype == 1 ? 0 : 1;
        $result = $result->where('tp.activestatus', $value);
    }

    // Get the total record count
    $totalCount = $result->count();

    // If time frame value is not "0", apply date filter
    if ($request->timeFrameValue != "0") {
        $result = $result->whereBetween('tp.created_at', [$fromDate, $toDate]);
    }
    
    if ($request->regionIndex && $request->regionIndex != 'NA') {
        $result = $result->whereIn('tp.region', explode(',', $getAllRegionIDs));
    }
    
    // Handle pagination
    if ($request->paginate == "true") {
        $result = $result->simplePaginate();
    } else {
        $result = $result->get()->toArray();
    }

    return response()->json([
        'code' => 200,
        'message' => "Outstanding fetched successfully",
        'data' => $result,
        'total_records' => $totalCount, // Include total record count in the response
    ]);
}


 public function activeOutstanding(Request $request) {
        try {
              $approveData = Outstanding::where('id', $request->id)

                       ->update([
                          'activestatus' => 1,
                          'Aprove_Date' => now() // Use `now()` function to get the current date and time
                      ]);


              return response()->json([
                'code' => 200,
                'message' => "Oustanding Activated successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong "
          ]);
          }

    }

     public function inactiveOutstanding(Request $request) {
        try {
              $approveData = Outstanding::where('id', $request->id)
                       ->update([
                          'activestatus' => 0,
                          'Aprove_Date' => now() // Use `now()` function to get the current date and time
                      ]);


              return response()->json([
                'code' => 200,
                'message' => "Oustanding Deactivated successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong "
          ]);
          }

    }
}
