<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Product;
use App\Models\RegionwisePrice;
use App\Models\OrderTarget;
use App\Models\Order;
use App\Http\Controllers\APIController;
use Carbon\Carbon;

class OrderTargetController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    public function submitOrderTarget(Request $request)
    {
        // dd($request->all());
        try {
            $result = DB::table('tbl_employee')->where('id',$request->empId)->first();
            $empRegion = $result->region;
            $getlastDateOfMonth = date('t');
            $fromDate = date('Y-m-01');
            $toDate = date('Y-m-'.$getlastDateOfMonth);
            if ($request->id) {
                $orderTargetData = OrderTarget::find($request->id);
            } else {
                $orderTargetData = new OrderTarget();
            }
            $orderTargetData->empId = $request->empId; 
            $orderTargetData->regionId = $empRegion; 
            $orderTargetData->fromDate = $fromDate;
            $orderTargetData->toDate = $toDate;
            $orderTargetData->productId = $request->productId;
            $orderTargetData->quantity = $request->quantity;
            $orderTargetData->amount = $request->amount;
            $orderTargetData->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }
    
    public function getOrderTarget(Request $request)
    {
        try 
        {
            $result = DB::table('tbl_order_target as t1')
                    ->leftJoin('tbl_employee as t2', 't2.id', '=', 't1.empId')
                    ->leftJoin('tbl_product as t3', 't3.pid', '=', 't1.productId')
                    ->where('t1.deleteFlag',0);
            if ($request->timeslot) {
                $timeFrame = explode('#',$request->timeslot);
                $fromDate = $timeFrame[0];
                $toDate = $timeFrame[1];
                $result = $result->where('t1.fromDate', $fromDate)
                                 ->where('t1.toDate', $toDate);
            }else{
                $getlastDateOfMonth = date('t');
                $fromDate = date('Y-m-01');
                $toDate = date('Y-m-'.$getlastDateOfMonth);
                $result = $result->where('t1.fromDate', $fromDate)
                                 ->where('t1.toDate', $toDate);
            }
            
            if ($request->empID) {
                $result = $result->where('t1.empId', $request->empID);
            }
            if ($request->keyword) {
                $result = $result->where(function ($query) use ($request) {
                    $query
                        ->where('t2.emp_name', 'like', '%' . $request->keyword . '%')
                        ->orWhere('t3.productName', 'like', '%' . $request->keyword . '%');
                });
            }
            $totalCount = $result->count();
            if ($request->paginate == "true") {
                $result = $result
                    ->select('t1.id as orderTargetId','t1.quantity','t1.amount','t3.productName','t2.emp_name','t1.productId','t1.empId')
                    ->simplePaginate();
            } else {
                $result = $result
                    ->select('t1.quantity','t1.amount','t3.productName','t2.emp_name')
                    ->get()
                    ->toArray();
            }
            
            return response()->json([
                'code' => 200,
                'message' => "Order Target fetched successfully",
                'totalCount' => $totalCount,
                'data' => $result,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }
     
    //delete order target
    public function deleteOrderTarget(Request $request)
    {
        try
        {
            $OrderTarget = OrderTarget::find($request->id);
            $OrderTarget->deleteFlag = 1;
            $OrderTarget->updated_at = date('Y-m-d h:i:s');
            $OrderTarget->save();
    
            return response()->json([
                'code' => 200,
                'message' => "Order target deleted successfully",
            ]);
        }catch(\Exception $e){
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong",
            ]);
        }
    }
    public function getEmployeeOrderTargetTimeframe(Request $request){
        
        $queryResult = OrderTarget::select(DB::raw('DISTINCT(fromDate) as fromDateSlot'), 'toDate as toDateSlot')
            ->orderBy('fromDate', 'DESC')
            ->get();

        $options = [];

        foreach ($queryResult as $data) {
            
            $options[] = [
                'value'    => $data->fromDateSlot.'#'.$data->toDateSlot,
                'label'    => date('d M Y', strtotime($data->fromDateSlot)).' - '.date('d M Y', strtotime($data->toDateSlot))
            ];
        }

        return response()->json(['options' => $options]);
        
    }
    
    //regionwise price
    public function fetchRegionwiseProductData(Request $request)
    {
        try {
            $empId = $request->empId;
            $productId = $request->productId;
            // dd($request->all());
            $result = DB::table('tbl_employee')->where('id',$empId)->first();
            $empbillingRegion = $result->billingRegion;
            
            $price = RegionwisePrice::where('regionId', $empbillingRegion)
                        ->where('productId', $productId)
                        ->value('price');
           
            return response()->json([
                'code' => 200,
                'price' => $price,
                'message' => "Data fetch successfull",
            ]);
        } catch (\Exception $e) {
            // dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
    
    
    public function viewEmployeeOrderAchievedTarget(Request $request)
    {
        
        if ($request->timeslot) {
            $timeFrame = explode('#',$request->timeslot);
            $fromDate = $timeFrame[0];
            $toDate = $timeFrame[1];
        }else{
            $fromDate = date('Y-m-01');
            $toDate = date('Y-m-d');
        }
        $regionID = $request->regionIndex;
        
        $result = DB::table('tbl_order_target AS t1')
            ->leftJoin('tbl_employee AS t2', 't1.empId', '=', 't2.id')
            ->leftJoin('tbl_product AS t3', 't1.productId', '=', 't3.pid')
            ->select('t2.*','t2.emp_name', 't2.emp_mobile','t3.product_name')
            ->where('t2.deleteFlag', 0);
        
        if ($request->empID) {
            $result = $result->where('t1.empId', $request->empID);
        }else{
            $getAllEmp = $this->apiController->getEmployeeId($regionID);
            $result = $result->whereIn('t1.empId', explode(',', $getAllEmp));
        }
         
        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('t2.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t2.emp_mobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t1.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        if ($request->paginate == "true") {
            $perPage = 15; 
            $page = $request->page ?: 1;

            $countQuery = clone $result;
            $total = $countQuery->count();

            $paginator = new \Illuminate\Pagination\LengthAwarePaginator($result->forPage($page, $perPage)->get(), $total, $perPage, $page, [
                'path' => $request->url(),
                'query' => $request->query(),
            ]);

            $paginationDetails = [
                'current_page' => $paginator->currentPage(),
                'first_page_url' => $paginator->url(1),
                'from' => $paginator->firstItem(),
                'to' => $paginator->lastItem(),
                'last_page' => $paginator->lastPage(),
                'last_page_url' => $paginator->url($paginator->lastPage()),
                'next_page_url' => $paginator->nextPageUrl(),
                'path' => $paginator->path(),
                'per_page' => $paginator->perPage(),
                'prev_page_url' => $paginator->previousPageUrl(),
                'total' => $paginator->total(),
            ];

            $result = $paginator->items();
        } else {
            $result = $result->get()->toArray();
            $paginationDetails = null;
        }
        
        $reportArray = array();
        foreach ($result as $row) {
            $achieveOrder = DB::table('tb');
            // $empId = $row>empID;
            $data['emp_name'] = $row->emp_name;
            $data['emp_mobile'] = $row->emp_mobile;
            $data['productName'] = $icTarget;
            $data['target'] = $icAchiveTarget;
            $data['achieved'] = $sdTarget;
            
            $reportArray[] = $data;
        }

        return response()->json([
            'report_data' => $reportArray,
            'pagination_details' => $paginationDetails,
        ]);
    }
    
    public function fetchOrderAchieved($from, $to,$regionID)
    {
        
        $getAllEmployeeId = $this->apiController->getEmployeeId($regionID);
        // Fetch order achieved data
        $orderAchievedArray = DB::table('tbl_orderbookentries as t1')
            ->leftJoin('tbl_ordernew as t2', 't1.oid', '=', 't2.oid')
            ->whereIn('t2.emp_id', $getAllEmployeeId) // Assuming getAllEmployeeId() is defined somewhere to get employee IDs
            ->whereBetween('t2.date', [$from, $to])
            ->groupBy('t1.pid', 't2.emp_id')
            ->select('t1.pid', 't2.emp_id', DB::raw('SUM(t1.quantity) as totQty'))
            ->get();

        $response = [];

        // Build the response array indexed by empId and pid
        foreach ($orderAchievedArray as $rowData) {
            $response[$rowData->emp_id][$rowData->pid] = $rowData->totQty;
        }

        return $response;
    }
    
    public function getOrderAchieveTarget(Request $request){
        if($request->timeslot){
            $timeslotVal = explode('#',$request->timeslot);
            $from = $timeslotVal[0];
            $to = $timeslotVal[1];
        }else{
            $from = date('Y-m-01');
            $to = date('Y-m-t');
        }
        $orderAchievedArray = $this->fetchOrderAchieved($from,$to,$request->regionIndex);
        // Fetch order target data
        $orderTargets = DB::table('tbl_order_target as t1')
                        ->select('t1.*', 't3.emp_name', 't2.productName')
                        ->leftJoin('tbl_employee as t3', 't3.id', '=', 't1.empId')
                        ->leftJoin('tbl_product as t2', 't2.pid', '=', 't1.productId')
                        ->where('fromDate', $from)
                        ->where('toDate', $to)
                        ->where('t1.deleteFlag', 0);
        
        if($request->empID){
            $orderTargets = $orderTargets->where('empId',$request->empID);
        }else{
            $getAllEmployeeId = $this->apiController->getEmployeeId($request->regionIndex);
            // print
            $orderTargets = $orderTargets->whereIN('empId',$getAllEmployeeId);
        } 
        if ($request->keyword) {
            $orderTargets = $orderTargets->where(function ($query) use ($request) {
                $query->where('t3.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t2.productName', 'like', '%' . $request->keyword . '%');
            });
        }

        if($request->paginate == 'true'){
            $orderTargets = $orderTargets->paginate(15);
            $paginationDetails = $orderTargets->toArray();
            unset($paginationDetails['data']);
            
        } else {
            $orderTargets = $orderTargets->get();
            $paginationDetails = null;
        }
        $orderAchieveTargetData = array();
        // Merge achieved quantity with order target data
        foreach ($orderTargets as $orderTarget) {
            if (isset($orderAchievedArray[$orderTarget->empId][$orderTarget->productId])) {
                $achiveQuantity = $orderAchievedArray[$orderTarget->empId][$orderTarget->productId];
            } else {
                $achiveQuantity = 0; 
            }
            array_push($orderAchieveTargetData,array(
                'emp_name' => $orderTarget->emp_name,
                'product_name' => $orderTarget->productName,
                'targetQuantity' => $orderTarget->quantity,
                'achiveQuantity' => $achiveQuantity
            ));
        }
        
        
        return response()->json([
            'report_data' => $orderAchieveTargetData,
            'pagination_details' => $paginationDetails,
        ]); 

    }
    
}