<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderBookEntries;
use App\Models\Dispatch;
use App\Models\Product;
use App\Models\RegionwisePrice;
use App\Http\Controllers\APIController;
use Carbon\Carbon;
class OrderController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    public function addOrder(Request $request)
    {
        // dd($request->all());
        try {
            $orderData = new Order();

            $orderData->billid = 'b'.date('Ymdhis'); // bill id
            $orderData->did = $request->did; // agency id
            $orderData->pid = implode('#', $request->pid); // product id
            $orderData->total = implode('#', $request->subtotal);
            $orderData->date = $request->date;
            $orderData->qty = implode('#', $request->qty);
            $orderData->rate = implode('#', $request->rate);
            $orderData->subtotal = implode('#', $request->subtotal);
            $orderData->pterm = $request->pterm; // payment mode
            $orderData->emp_id = $request->emp_id;
            $orderData->agencyType = $request->agencyType;
            $orderData->remark = $request->remark;
            $orderData->created_at = date('Y-m-d');
            $orderData->save();
            // save productwise order data in orderentries table
            $pid = $request->pid;
            $rate = $request->rate;
            $qty = $request->qty;
            $subtotal = $request->subtotal;
            $orderID = $orderData->id;
            // print_r($pid);
            for ($i = 0; $i < count($pid); $i++) {
                $orderBookEntriesData = new OrderBookEntries();
                $orderBookEntriesData->oid = $orderID; // order id
                $orderBookEntriesData->pid = $pid[$i]; // product id
                $orderBookEntriesData->rate = $rate[$i];
                $orderBookEntriesData->quantity = $qty[$i];
                $orderBookEntriesData->subtotal = $subtotal[$i];
                $orderBookEntriesData->approvalStatus = 0;
                $orderBookEntriesData->save();
            }

            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }
    public function getpendingapprovalorder(Request $request)
    {
        $result = DB::table('tbl_ordernew as tp');
    
        $fromDate = date('Y-m-d', strtotime($request->fromDate));
        $toDate = date('Y-m-d', strtotime($request->toDate));
    
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tc.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }
        
        $result = $result
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tp.did')
            ->leftJoin('tbl_product as to', 'to.pid', '=', 'tp.pid')
            ->where('tp.approval', 0);
    
        // Get the total record count
        $totalCount = $result->count();
    
        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.date', [$fromDate, $toDate]);
        }
        if ($request->empID) {
            $result = $result->where('tp.emp_id', $request->empID);
        }
        if ($request->agencyId) {
            $result = $result->where('tp.did', $request->agencyId);
        }
        if ($request->regionIndex) {
            $result = $result->where('tp.region', $request->regionIndex);
        }
    
        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->select('tp.oid', 'tp.date', 'tp.created_at', DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval', 'tp.img')
                ->orderBy('tp.oid', 'desc') // Order by tp.created_at in descending order
                ->simplePaginate();
        } else {
            $result = $result->select('tp.oid', 'tp.date', 'tp.created_at', DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval', 'tp.img')
                ->orderBy('tp.oid', 'desc') // Order by tp.created_at in descending order
                ->get()
                ->toArray();
        }
    
        $array = DB::table('tbl_product')->get()->pluck('productName', 'pid')->toArray();
        return response()->json([
            'code' => 200,
            'message' => "Order fetched successfully",
            'data' => $result,
            'allProduct' => $array,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }

    public function getRejectedOrderList(Request $request)
    {
        $result = DB::table('tbl_ordernew as tp');
    
        $fromDate = date('Y-m-d', strtotime($request->fromDate));
        $toDate = date('Y-m-d', strtotime($request->toDate));
    
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tc.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }
        
        $result = $result
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tp.did')
            ->leftJoin('tbl_product as to', 'to.pid', '=', 'tp.pid')
            ->where('tp.approval', 3);
    
        // Get the total record count
        $totalCount = $result->count();
    
        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.date', [$fromDate, $toDate]);
        }
        if ($request->empID) {
            $result = $result->where('tp.emp_id', $request->empID);
        }
        if ($request->agencyId) {
            $result = $result->where('tp.did', $request->agencyId);
        }
        if ($request->regionIndex) {
            $result = $result->where('tp.region', $request->regionIndex);
        }
    
        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->select('tp.oid', 'tp.date', 'tp.created_at', DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval', 'tp.img')
                ->orderBy('tp.oid', 'desc') // Order by tp.created_at in descending order
                ->simplePaginate();
        } else {
            $result = $result->select('tp.oid', 'tp.date', 'tp.created_at', DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval', 'tp.img')
                ->orderBy('tp.oid', 'desc') // Order by tp.created_at in descending order
                ->get()
                ->toArray();
        }
    
        $array = DB::table('tbl_product')->get()->pluck('productName', 'pid')->toArray();
        
        return response()->json([
            'code' => 200,
            'message' => "Order fetched successfully",
            'data' => $result,
            'allProduct' => $array,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }

    public function getpendingdeliveryorder(Request $request)
    {
        $result = DB::table('tbl_ordernew as tp');
    
        $fromDate = date('Y-m-d 00:00:00', strtotime($request->fromDate));
        $toDate = date('Y-m-d 23:59:59', strtotime($request->toDate));
    
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tc.agencyShopName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            });
        }
        
        $result = $result
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tp.did')
            ->where('tp.approval', 1);
    
        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tp.date', [$fromDate, $toDate]);
        }
        if ($request->empID) {
            $result = $result->where('tp.emp_id', $request->empID);
        }
        if ($request->agencyId) {
            $result = $result->where('tp.did', $request->agencyId);
        }
    
        // Get the total record count
        $totalCount = $result->count();
    
        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->select('tp.oid', 'tp.date', 'tp.created_at', 'tc.agencyId', DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval')
                ->orderBy('tp.oid', 'desc') // Order by tp.created_at in descending order
                ->simplePaginate();
        } else {
            $result = $result->select('tp.oid', 'tp.date', 'tp.created_at', 'tc.agencyId', DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval')
                ->orderBy('tp.oid', 'desc') // Order by tp.created_at in descending order
                ->get()
                ->toArray();
        }
    
        $array = DB::table('tbl_product')->get()->pluck('productName', 'pid')->toArray();
    
        return response()->json([
            'code' => 200,
            'message' => "Order fetched successfully",
            'data' => $result,
            'allProduct' => $array,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    }


    public function Approvepending(Request $request)
    {
        try {
            $approveData = Order::where('oid', $request->oid)->update([
                'approval' => 1,
                'Aprove_Date' => now(), // Use `now()` function to get the current date and time
            ]);

            return response()->json([
                'code' => 200,
                'message' => "order approved successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong ",
            ]);
        }
    }

    public function rejectApprovepending(Request $request)
    {
        try {
            $approveData = Order::where('oid', $request->oid)->update([
                'approval' => 3,
                'Aprove_Date' => now(), // Use `now()` function to get the current date and time
            ]);

            return response()->json([
                'code' => 200,
                'message' => "Order Reject successfully",
            ]);
        } catch (\Exception $e) {
            // dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong ",
            ]);
        }
    }
    public function approvefordispatch(Request $request)
    {
        try {
            $approveData = Order::where('oid', $request->oid)->update([
                'approval' => 2,
                'Aprove_Date' => now(), // Use `now()` function to get the current date and time
            ]);

            return response()->json([
                'code' => 200,
                'message' => "Order Reject successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong ",
            ]);
        }
    }

    public function fetchRegionwiseProductData(Request $request)
    {
        try {
            $regionId = $request->regionId;
            $productId = $request->productId;
            // dd($request->all());

            $price = RegionwisePrice::where('regionId', $regionId)
                        ->where('productId', $productId)
                        ->value('price');
            // $priceCount = $RegionwisePrice->count();
            // if($priceCount > 0 ){
            //     $price = $price;
            // }else{
            //     $price = 'N/A';
            // }
            return response()->json([
                'code' => 200,
                'price' => $price,
                'message' => "Data fetch successfull",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }

    public function dispatchOrder(Request $request) {
        try {
            if ($request->oid) {
                $dispatchData = $request->id ? Dispatch::find($request->id) : new Dispatch();
                $dispatchData->disINVNo = 'DIS-'.date('Ymdhis'); // bill id
                $dispatchData->disname = $request->disname; // agency id
                $dispatchData->disproname = implode('#', $request->disproname); // product id
                $dispatchData->disqty = implode('#', $request->disqty);
                $dispatchData->disrate = implode('#', $request->disrate);
                $dispatchData->distamt = implode('#', $request->distamt);
                $dispatchData->distno = $request->distno;
                $dispatchData->distcode = $request->distcode;
                $dispatchData->disdno = $request->disdno;
                $dispatchData->distime = $request->distime;
                $dispatchData->save();

                $result = DB::table('tbl_ordernew')
                              ->where('oid', $request->oid)
                              ->update([
                                'approval' => 2
                              ]);

              return response()->json([
                'code' => 200,
                 'message' => $request->id ? 'Dispatched data updated' : 'Dispatched Successfully',
              ]);
            } else {
                return response()->json([
                    'code' => 200,
                     'message' => 'Order not found',
                ]);
            }
        } catch (\Exception $e) {
          return response()->json([
            'code' => 500,
            'error' => $e->getMessage(),
            'message' => "Something went wrong while saving data"
          ]);
        }
    }

    public function EditPendingOrder(Request $request)
    {
        try {
          if ($request['oid']) {
              foreach ($request['deletedData'] as $value) {
                  OrderBookEntries::where('oid', $request['oid'])->where('pid', $value)->delete();
              }
              foreach ($request['productData'] as $key => $value) {
                  OrderBookEntries::where('oid', $request['oid'])->where('pid', $key)->update([
                      'quantity' => $value['qty'],
                      'subtotal' => $value['total_value']
                  ]);
              }
              $pidArray = array_column($request['productData'], 'pid');
              $qtyArray = array_column($request['productData'], 'qty');
              $subtotalArray = array_column($request['productData'], 'total_value');
              Order::where('oid', $request->oid)
                    ->update([
                        'pid' => implode('#', $pidArray), // product id
                        'total' => implode('#', $subtotalArray),
                        'qty' => implode('#', $qtyArray),
                        'subtotal' => implode('#', $subtotalArray),
                    ]);
          }

          return response()->json([
              'code' => 200,
              'message' => "Pending order updated successfully",
          ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }

public function getDispatchOrderList(Request $request)
{
    $result = DB::table('tbl_dispatch as td');
    $fromDate = Carbon::parse($request->fromDate)->startOfDay();
    $toDate = Carbon::parse($request->toDate)->endOfDay();
    $reportArray = [];

    if ($request->keyword) {
        $result = $result->orWhere(function ($query) use ($request) {
            $query->orWhere('tc.agencyShopName', 'like', '%' . $request->keyword . '%');
        });
    }

    $result = $result->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'td.disname');



    if ($request->paginate == "true") {
        $result = $result->select('td.id', 'td.disINVNo', 'td.disname', 'td.disproname', 'td.disqty', 'td.disrate', 'td.distamt', 'td.distno', 'td.distcode', 'td.disdno', 'td.distime', DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"));
    } else {
        $result = $result->select('td.id', 'td.disINVNo', 'td.disname', 'td.disproname', 'td.disqty', 'td.disrate', 'td.distamt', 'td.distno', 'td.distcode', 'td.disdno', 'td.distime', DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"));
    }

    if ($request->timeFrameValue != "0") {
        $result = $result->whereBetween('td.distime', [$fromDate, $toDate]);
    }

    if ($request->agencyId) {
        $result = $result->where('td.disname', $request->agencyId);
    }
    // Get the total record count
    $totalCount = $result->count();
    // Handle pagination
    if ($request->paginate == "true") {
        $result = $result->simplePaginate();
    } else {
        $result = $result->get()->toArray();
    }
    
    $array = DB::table('tbl_product')->get()->pluck('productName', 'pid')->toArray();

    return response()->json([
        'code' => 200,
        'message' => "Dispatch data fetched successfully",
        'data' => $result,
        'allProduct' => $array,
        'total_records' => $totalCount, // Include total record count in the response
    ]);
}

    public function getOrderById($id) {
      $getOrder = Order::where('oid', $id)->get()->toArray();
      return response()->json([
          'code' => 500,
          'message' => "successfully fetched data",
          'data' => $getOrder
      ]);
    }
    public function updatePendingDelivery(Request $request) {
        if ($request->oid) {
            foreach ($request->deletedData as $value) {
                OrderBookEntries::where('oid', $request->oid)->where('pid', $value)->delete();
            }
            foreach ($request->updateData as $key => $value) {
                OrderBookEntries::where('oid', $request->oid)->where('pid', $key)->update([
                    'quantity' => $value['qty'],
                    'subtotal' => $value['total_value']
                ]);
            }
            $pidArray = array_keys($request->updateData);
            $rateArray = array_column($request->updateData, 'rate');
            $qtyArray = array_column($request->updateData, 'qty');
            $subtotalArray = array_column($request->updateData, 'total_value');
            Order::where('oid', $request->oid)->update([
                'qty' => implode('#', $qtyArray),
                'subtotal' => implode('#', $subtotalArray),
                'total' => implode('#', $subtotalArray),
                'rate' => implode('#', $rateArray),
                'pid' => implode('#', $pidArray),
            ]);
            return response()->json([
                'code' => 200,
                'message' => "successfully updated data",
            ]);
        } else {
            return response()->json([
                'code' => 200,
                'message' => "Order ID not found",
            ]);
        }
    }
}
