<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderBookEntries;
use App\Models\Dispatch;
use App\Http\Controllers\APIController;

class MobileAppPermissionController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    
    public function getDesignationMenu(Request $request){
        $result = DB::table('tbl_app_control_permission as tp');
        // Get the total record count
        $totalCount = $result->count();
        
        $result = $result->select('tp.*')
            ->where('tp.status', '1') 
            ->orderBy('tp.id', 'asc') 
            ->get()
            ->toArray();
        $reportArray = array();
        // print_r($result);
        foreach ($result as $row) {
            $getAllCountData = DB::table('tbl_app_designation_permission as t2')
                ->select('t2.status')
                ->where('designation_id', $request->designation_id)
                ->where('menu_id', $row->id)
                ->get();
            $totalCount1 = $getAllCountData->count();
            if($totalCount1 > 0){
                // $getAllCountData = $getAllCountData->get();
                $status =  $getAllCountData->first()->status;
            }else{
                $status =  1;
            }
                // status = 0 = inactive and status = 1 means active
            if($status == 0){ $statusBoolen = false; }else{ $statusBoolen = true; }
            $data['id'] = $row->id;
            $data['menu_name'] = $row->app_menu;
            $data['status'] = $status;
            $data['statusBoolen'] = $statusBoolen;
            array_push($reportArray, $data);
                    
        }
       
        return response()->json([
            'code' => 200,
            'message' => "Data fetched successfully",
            'data' => $reportArray,
            'total_records' => $totalCount, 
        ]);
    }
    
    public function setDesignationwiseAppPermission(Request $request){
        try{
            
            $menu_id = $request->menu_id; 
            $designation_id = $request->designation_id; 
            $status = $request->status; 
            
            // Check if record exists
            $count = DB::table('tbl_app_designation_permission')
                ->where('menu_id', $menu_id)
                ->where('designation_id', $designation_id)
                ->count();
            
            if ($count == 0) {
                // Record exists, perform INSERT
                DB::table('tbl_app_designation_permission')->insert([
                    'menu_id' => $menu_id,
                    'designation_id' => $designation_id,
                    'status' => $status,
                ]);
            
                
            } else {
                // Record doesn't exist, perform UPDATE
                DB::table('tbl_app_designation_permission')
                    ->where('menu_id', $menu_id)
                    ->where('designation_id', $designation_id)
                    ->update(['status' => $status]);
                
            }
            
            return response()->json(['code' => 200,'message' => 'Data saved successfully']);

        }catch (\Exception $e) {
            return response()->json(
                [
                    'code' => 500,
                    'error' => $e->getMessage(),
                    'message' => "Something went wrong ",
                ]
            );
        }
    }
    
}
