<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderBookEntries;
use App\Models\Dispatch;
use App\Models\Product;
use App\Models\RegionwisePrice;
use App\Http\Controllers\APIController;

class MailerController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }


    public function getMailer(Request $request)
    {
         // Validate the request data
        $validatedData = $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'comments' => 'required',
            'phone_number' => 'required',
        ]);

        // Send the email
        Mail::send('emails.contact', $validatedData, function ($message) use ($validatedData) {
            $message->to('srbraut3@gmail.com.com');
            $message->subject('New contact form submission');
            $message->from($validatedData['email'], $validatedData['name']);
        });

        return response()->json(['message' => 'Email sent successfully']);
    }




}
