<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\leaveType;
use App\Models\DesignationWiseLeave;
use App\Http\Controllers\APIController;

class LeaveTypeController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }

    public function submitLeaveType(Request $request) {
       try {
            if($request->id) {
                $leavetypeData = leaveType::find($request->id);
            } else {
                $leavetypeData = new leaveType();
            }
            $leavetypeData->leavetype = $request->leavetype;
            $leavetypeData->leave_status = $request->leave_status;
            
            $leavetypeData->save();
              return response()->json([
                'code' => 200,
                'message' => "Data Save successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data"
          ]);
          }
       
    }
    public function getLeaveTypeList()
    {
        $result = DB::table('tbl_leavetype')
            ->where('isDeleted','0')
            ->get()
            ->toArray();
        return $result;
    }
    public function getleavetype(Request $request) {
    try {
        $leavetypeData = leaveType::select('*')->where('isDeleted', false)->orderBy('created_at', 'desc');

        if ($request->paginate == "true") {
            $leavetypeData = $leavetypeData->select('*');
        } else {
            $leavetypeData = $leavetypeData->select('*');
        }
        
        $totalCount = $leavetypeData->count();
        
        if ($request->paginate == "true") {
            $leavetypeData = $leavetypeData->simplePaginate();
        } else {
            $leavetypeData = $leavetypeData->get()->toArray();
        }

        // Get the total record count
        

        return response()->json([
            'code' => 200,
            'data' => $leavetypeData,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        dd($e);
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data"
        ]);
    }
}

    public function deleteLeavetype(Request $request) {
        try {
            $leavetypeData = leaveType::find($request->id);
           $leavetypeData->isDeleted = true;
            $leavetypeData->save();
           
              return response()->json([
                'code' => 200,
                'message' => "data deleted successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }
       
    }
    
    public function submitDesignationLeaveCount(Request $request) {
        try 
        {
            if($request->id) {
                $leavetypeData = DesignationWiseLeave::find($request->id);
            } else {
                $leavetypeData = new DesignationWiseLeave();
            }
            $leavetypeData->leaveType = $request->leaveType;
            $leavetypeData->designationId = $request->designationId;
            $leavetypeData->leaveCount = $request->leaveCount;
            
            $leavetypeData->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully"
            ]);
        } catch (\Exception $e) {
            // dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data"
            ]);
        }
       
    }
    
    public function getDesignationLeaveTypeCount(Request $request)
    {
        //try {
            $DesignationWiseLeave = DesignationWiseLeave::select('tbl_designation_wise_leave.*','designationName','t3.leavetype as leaveTypeName')
                                    ->leftJoin('tbl_designation as t2','tbl_designation_wise_leave.designationId','t2.designationId')
                                    ->leftJoin('tbl_leavetype as t3','tbl_designation_wise_leave.leaveType','t3.id')
                                    ->where('tbl_designation_wise_leave.isDeleted', false)->orderBy('created_at', 'desc');
            
            if ($request->keyword) {
                $DesignationWiseLeave = $DesignationWiseLeave->where(function ($query) use ($request) {
                    $query->orWhere('designationName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t3.leavetype', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('leaveCount', 'like', '%' . $request->keyword . '%');
                });
            }
            $totalCount = $DesignationWiseLeave->count();
            
            if ($request->paginate == "true") {
                $DesignationWiseLeave = $DesignationWiseLeave->simplePaginate();
            } else {
                $DesignationWiseLeave = $DesignationWiseLeave->get()->toArray();
            }
    
            // Get the total record count
            
    
            return response()->json([
                'code' => 200,
                'data' => $DesignationWiseLeave,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        // } catch (\Exception $e) {
        //     //dd($e);
        //     return response()->json([
        //         'code' => 500,
        //         'message' => "Something went wrong while saving data"
        //     ]);
        // }
    }
    
    //delete
    public function deleteDesignationwiseLeaveCount(Request $request)
    {
        try
        {
            $DesignationWiseLeave = DesignationWiseLeave::find($request->id);
            $DesignationWiseLeave->isDeleted = 1;
            $DesignationWiseLeave->updated_at = date('Y-m-d h:i:s');
            $DesignationWiseLeave->save();
    
            return response()->json([
                'code' => 200,
                'message' => "Designation leave count deleted successfully",
            ]);
        }catch(\Exception $e){
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong",
            ]);
        }
    }
    
}
