<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Leave;
use App\Http\Controllers\APIController;

class LeaveController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
public function getnotapproveleave(Request $request) {
    try {
        $result = DB::table('tbl_leave_application as tfa');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.emp_mobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.leavetype', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.emp_id')
            ->leftJoin('tbl_leavetype as tc', 'tc.id', '=', 'tfa.leave_type_id')
            ->where('tf.deleteFlag', false)
            ->where('tfa.isApproved', false)
            ->where('tfa.isReject', false);

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.request_date', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tfa.emp_id', $request->empID);
        }

        if ($request->regionID) {
            $regionId = $request->regionID;
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
            $result = $result->whereIn('tf.region', explode(',', $getAllRegionIDs));
        }
        
        $result = $result->orderBy('tfa.leave_id', 'desc');

        // Get the total record count
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select(
                'tfa.leave_id',
                'tf.emp_name',
                'tf.emp_mobile',
                'tc.leavetype',
                'tfa.leave_from',
                'tfa.leave_upto',
                'tfa.total_days',
                'tfa.leave_reason',
                'tfa.request_date'
            )->simplePaginate();
        } else {
            $result = $result->select('tfa.*', 'tf.*', 'tc.*')->get()->toArray();
        }
        
        return response()->json([
            'code' => 200,
            'message' => "Not approved leave fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // In case of any exception, it's better to log the error for debugging purposes
        // Log::error($e);
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}

public function getleavehistory(Request $request) {
    try {
        $result = DB::table('tbl_leave_application as tfa');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tf.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.emp_mobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.leavetype', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.leave_from', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.leave_upto', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.leave_reason', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.total_days', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.request_date', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.emp_id')
            ->leftJoin('tbl_leavetype as tc', 'tc.id', '=', 'tfa.leave_type_id')
            ->where('tf.deleteFlag', false)
            ->where('tfa.isApproved', true)
            ->where('tfa.isReject', false);

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.request_date',[$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tfa.emp_id', $request->empID);
        }
        
        if ($request->LeavetypeId) {
            $result = $result->where('tfa.leave_type_id', $request->LeavetypeId);
        }
        
        $result = $result->orderBy('tfa.leave_id', 'desc');
        // Get the total record count
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select(
                'tfa.leave_id',
                'tf.emp_name',
                'tf.emp_mobile',
                'tc.leavetype',
                'tfa.leave_from',
                'tfa.leave_upto',
                'tfa.total_days',
                'tfa.leave_reason',
                'tfa.request_date',
                'tfa.leave_type_id'
            )->simplePaginate();
        } else {
            $result = $result->select('tfa.*', 'tf.*', 'tc.*')->get()->toArray();
        }
        
        
        
        return response()->json([
            'code' => 200,
            'message' => "Leave history fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // In case of any exception, it's better to log the error for debugging purposes
        // Log::error($e);
        return response()->json([
            'code' => 500,
            'error' =>$e->getMessage(),
            'message' => "Something went wrong while fetching data",
        ]);
    }
}



//   public function approveleave(Request $request) {
//         try {
           
//           $leaveData = Leave::where('leave_id', $request->leave_id)
//                      ->update(['isApproved' => true]);
             
          
           
//               return response()->json([
//                 'code' => 200,
//                 'message' => "Leave approved successfully"
//               ]);
//         } catch (\Exception $e) {
//             dd($e);
//               return response()->json([
//             'code' => 500,
//             'message' => "Something went wrong while deleting crop"
//           ]);
//           }
       
//     }
    public function approveleave(Request $request) {
        try {
           
           $approveData = Leave::where('leave_id', $request->leave_id)
                      ->where('isApproved', 0)
                      ->update([
                          'isApproved' => 1,
                          'Aprove_Date' => now() // Use `now()` function to get the current date and time
                      ]);  
          
             return response()->json([
                'code' => 200,
                'message' => "Leave approved successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }
    }
     public function rejectleave(Request $request) {
        try {
              $leaveData = Leave::where('leave_id', $request->leave_id)
                     ->update(['isReject' => true]);
           
           
              return response()->json([
                'code' => 200,
                'message' => "Leave Rejected successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }
       
    }
    public function submitHoliday(Request $request) {
        try {
            if($request->id) {
                $HolidayData = Holiday::find($request->id);
            } else {
               $HolidayData = new Holiday(); 
            }
            
            $HolidayData->region = $request->region;
            $HolidayData->date = $request->date;
            $HolidayData->holiday_name = $request->holiday_name;
            
            
            $HolidayData->save();
              return response()->json([
                'code' => 200,
                'message' => " Holiday Save successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data"
          ]);
          }
       
    }
     public function getHoliday(Request $request) {
        try {
            $HolidayData = Holiday::select('*')->where('isDeleted', false)->orderBy('created_at', 'desc')->get()->toArray();
           
              return response()->json([
                'code' => 200,
                'data' => $HolidayData
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data"
          ]);
          }
       
    }
    public function deleteHoliday(Request $request) {
        try {
            $HolidayData =  Holiday::find($request->id);
            $HolidayData->isDeleted = true;
            $HolidayData->save();
           
              return response()->json([
                'code' => 200,
                'message' => " Holiday deleted successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }
       
    }
 
}
