<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use League\Flysystem\FilesystemAdapter;
use Aws\S3\S3Client;

class ImageController extends Controller
{
    public function upload(Request $request)
    {
        // Validate the uploaded file, e.g., check for image file types, size limits, etc.
        $request->validate([
            'image' => 'required|image',
        ]);

        $disk = Storage::disk('s3');

        // Store the uploaded image in the AWS S3 bucket
        $path = $request->file('image')->store('/skr/agency', 's3');
        // dd($path);

        // Generate a public URL for the uploaded image
        $url = Storage::disk('s3')->url($path);

        // Return the URL or perform any additional actions as needed
        return response()->json(['url' => $url]);
    }
}
