<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\holiday;
use App\Http\Controllers\APIController;

class HolidayController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }


    public function submitHoliday(Request $request) {
        try {
            if($request->id) {
                $HolidayData = Holiday::find($request->id);
            } else {
               $HolidayData = new Holiday(); 
            }
            
            $HolidayData->region = $request->region;
            $HolidayData->date = $request->date;
            $HolidayData->holiday_name = $request->holiday_name;
            
            
            $HolidayData->save();
              return response()->json([
                'code' => 200,
                'message' => " Holiday Save successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while saving data"
          ]);
          }
       
    }
    public function getHoliday(Request $request) {
    try {
        $HolidayData = DB::table('tbl_holydaycalender as thc')
                        ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'thc.region')
                        ->where('isDeleted', false)
                        ->orderBy('created_at', 'desc');
        
        // Get the total record count
        $totalCount = $HolidayData->count();

        // Check if pagination is requested
        if ($request->paginate == "true") {
            // If pagination is requested, add the select statement here
            $HolidayData = $HolidayData->select('thc.*', 'tc.category_name')->simplePaginate();
        } else {
            // If pagination is not requested, add the select statement here
            $HolidayData = $HolidayData->select('thc.*', 'tc.category_name')->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'data' => $HolidayData,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // In case of any exception, it's better to log the error for debugging purposes
        // Log::error($e);
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data"
        ]);
    }
}


    public function deleteHoliday(Request $request) {
        try {
            $HolidayData =  Holiday::find($request->id);
            $HolidayData->isDeleted = true;
            $HolidayData->save();
           
              return response()->json([
                'code' => 200,
                'message' => " Holiday deleted successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }
       
    }
 
}
