<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\leaveType;
use App\Models\Employee;
use App\Models\OrderTarget;
use App\Models\DayStart;
use App\Models\Category;
use App\Models\LeaveApplicationDetail;
use App\Models\DesignationWiseLeave;
use App\Models\SalaryGenerate;
use App\Models\Allowance;
use App\Models\Deduction;
use App\Http\Controllers\APIController;
use Carbon\Carbon;
use app\Helpers;
use DateTime;
use DateInterval;
use DatePeriod;

class HRMSController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    public function fetchBalanceLeave($startFinancialYear, $endDate, $designationId)
    {
        $totalLeaves = DesignationWiseLeave::where('designationId', $designationId)
                                    ->where('isDeleted',0)
                                    ->sum('leaveCount');

        return $totalLeaves;
    }
    public function countSundaysBetweenDates($fromDate, $toDate)
    {
        $sundays = [];
        $start = new DateTime($fromDate);
        $end = new DateTime($toDate);
        $interval = new DateInterval('P1D'); // 1 day interval

        $period = new DatePeriod($start, $interval, $end);
        foreach ($period as $date) {
            if ($date->format('l') === 'Sunday') {
                $sundays[] = $date->format('Y-m-d');
            }
        }
        return $sundays;
    }
    
    public function getSalarySlip(Request $request){
        $month = $request->month;
        $year = $request->year;
        $empId = $request->empID;
        
        $region = Employee::select('region','empDesignation')->where('id',$empId)->first();
        // dd($region);
        $regionId = isset($region)?$region->region:'';
        $designationId = isset($region)?$region->empDesignation:'';
        $currentYear = $year; 
        
        if ($month < 4) {
            $startFinancialYear = ($currentYear - 1) . '-04-01';
            $endFinancialYear = $currentYear . '-03-31';
        } else {
            $startFinancialYear = $currentYear . '-04-01';
            $endFinancialYear = ($currentYear + 1) . '-03-31';
        }
        
        
        $fromDate  = date($year.'-'.$month.'-01');
        $toDate = date($year.'-'.$month.'-31');
       
        $dateTime1 = new DateTime($fromDate);
        $dateTime2 = new DateTime($toDate);
        $interval = $dateTime1->diff($dateTime2);
        
        $totalDays = $interval->days+1;
        $currentMonth15 = date('Y-m-15'); 
        
        $fromDateObj = new DateTime($fromDate);
        if ($fromDateObj > new DateTime($currentMonth15)) {
            // 'if';
            $salaryArray = array(); // Empty array if $fromDate is greater than the 15th of the current month
        } else {
            $inputCategoryId = $regionId; // Replace with your desired category_id
            if($inputCategoryId == 1){
                $unitId = 1;
            }else{
                $unitResult = DB::select(DB::raw("SELECT FindImportantCategory(?) as unitName"), [$inputCategoryId]);
                // print_r($unitResult);
                // Access the result
                $unitName = $unitResult[0]->unitName;
                
                $category = Category::where('category_name', $unitName)->first();
                if ($category) {
                    $unitId = $category->category_id;
                } else {
                    $unitId = '';
                }
            }
            
            if ($unitId == 1) {
                $holidayDateArray = DB::table('tbl_holydaycalender')
                    ->selectRaw('date')
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->where('isDeleted', '0')
                    ->get()
                    ->pluck('date')
                    ->toArray(); 
            } else {
                $holidayDateArray = DB::table('tbl_holydaycalender')
                    ->selectRaw('date')
                    ->where('region', $unitId)
                    ->where('isDeleted', '0')
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->get()
                    ->pluck('date')
                    ->toArray(); 
            }
            
            $weekOffDate = $this->countSundaysBetweenDates($fromDate, $toDate);
            $totalSundays = count($weekOffDate);
            
            $holidayCount = count($holidayDateArray);
            $totalHoliday = $totalSundays+$holidayCount;
            $totalWorkingDay = $totalDays-$totalHoliday;
            
            $paidDays = DayStart::where('uid', $empId)
                        ->whereBetween('date', [$fromDate, $toDate])
                        ->count();

            // Query to count total leaves taken
            $leavesTake = LeaveApplicationDetail::where('emp_id', $empId)
                            ->whereBetween('leave_date', [$fromDate, $toDate])
                            ->count();
            
            $salaryDetails = Employee::select(
                'tbl_employee.id',
                'tbl_employee.date_of_joining',
                'tbl_employee.emp_name',
                'tbl_employee.emp_mobile',
                'tbl_employee.pan_no',
                'tbl_employee.pt_number',
                'tbl_employee.gross_salary',
                'tbl_employee.basic_pay',
                'tbl_employee.HRA',
                'tbl_employee.medical',
                'tbl_employee.professional_tax',
                'tbl_employee.insurance',
                'tbl_employee.PT',
                'tbl_employee.income_tax',
                'tbl_designation.designationName',
                'tbl_category.category_name as city'
            )
            ->leftJoin('tbl_designation', 'tbl_employee.empDesignation', '=', 'tbl_designation.designationId')
            ->leftJoin('tbl_category', 'tbl_employee.region', '=', 'tbl_category.category_id')
            ->where('tbl_employee.id', $empId)
            ->get();
        
            $salaryDetailsArray = [];
            
            // Process retrieved data
            foreach ($salaryDetails as $data) {
                //$designationId = $data->empDesignation;
                $totalLeaves = $this->fetchBalanceLeave($startFinancialYear, $toDate, $designationId);
                $grossSalary = $data['gross_salary'];
                $earning = $data['basic_pay']+$data['HRA']+$data['medical'];
                $deduction = $data['professional_tax']+$data['insurance']+$data['PT']+$data['income_tax'];
                
                $salaryDetailsArray[] = [
                    'id' => $data->id,
                    'dateOfJoining' => $data->date_of_joining,
                    'city' => $data->city,
                    'emp_name' => $data->emp_name,
                    'emp_mobile' => $data->emp_mobile,
                    'designation' => $data->designationName,
                    'pan_no' => $data->pan_no,
                    'pt_number' => $data->pt_number,
                    'gross_salary' => $data->gross_salary,
                    'basic_pay' => $data->basic_pay,
                    'HRA' => $data->HRA,
                    'medical' => $data->medical,
                    'professional_tax' => $data->professional_tax,
                    'insurance' => $data->insurance,
                    'PT' => $data->PT,
                    'income_tax' => $data->income_tax,
                ];
            }
            $payment = array();
            $absentDays = $totalWorkingDay - ($paidDays+$leavesTake);
            //fetch lwp
            $edate = date('Y-m-d', strtotime('-1 month', strtotime($toDate))); 
            $endDate  = date('Y-m-d', strtotime('-1 day', strtotime($edate)));
            
            $query1 = LeaveApplicationDetail::where('emp_id', $empId)
                ->whereBetween('leave_date', [$startFinancialYear, $endDate])
                ->count();
            
            $totalTakenLeaves = $query1;
            
            if ($totalTakenLeaves >= $totalLeaves) {
                $totalBalanceLeave = 0;
            } else {
                $totalBalanceLeave = $totalLeaves - $totalTakenLeaves;
            }
            
            // Calculate total days in the month
            $totalDays = cal_days_in_month(CAL_GREGORIAN, $month, $year);
            $perDayCost = $grossSalary / $totalDays;
            
            if ($totalBalanceLeave == 0) {
                $allLeaves = $totalWorkingDay - $paidDays;
                $totalLWPAmount = $allLeaves * $perDayCost;
                $paidLeaves = 0;
                $lwp = 0;
            } else {
                $totalTakenLeavesCurMonth = LeaveApplicationDetail::where('emp_id', $empId)
                    ->whereBetween('leave_date', [$fromDate, $toDate])
                    ->count();
            
                if ($totalBalanceLeave > $totalTakenLeavesCurMonth) {
                    $totalLWPAmount = $absentDays * $perDayCost;
                    $lwp = $absentDays;
                    $paidLeaves = $leavesTake;
                } else {
                    $lwp = ($totalTakenLeavesCurMonth - $totalBalanceLeave) + $absentDays;
                    $totalLWPAmount = $lwp * $perDayCost;
                    $paidLeaves = $totalTakenLeavesCurMonth - $totalBalanceLeave;
                }
            }
            
            $finalDeduction = $deduction + $totalLWPAmount;
            
            array_push(
                $payment,array(
                    'monthName' => date('F Y',strtotime($fromDate)),
                    'workingDays' => $totalWorkingDay,
                    'LWP' => $lwp,
                    'PaidLeaves' => $paidLeaves,
                    'presentDays' => $paidDays,
                    'totalPayable' => number_format($grossSalary-$finalDeduction,2),
                    'totalEarning' => $earning,
                    'totalDeductions' => number_format($finalDeduction,2),
                    'absentDays' => $totalWorkingDay-$paidDays,
                    'balanceLeave' => $totalBalanceLeave,
                    'balanceLeaveAmount' => number_format($totalLWPAmount,2)
                ));
            $mergedArray = array_merge($salaryDetailsArray[0], $payment[0]);
            $salaryArray = array($mergedArray);
            
            return response()->json(['code' => 200,'data' => $salaryArray]);
        }
    }
    
    public function fetchEmployeewisBalanceLeave(Request $request){
        if($request->empID){
            $getAllEmpId = [$request->empID];
        }else{
            $getAllEmpId = $this->apiController->getEmployeeId($request->regionIndex);
        }
        // echo $getAllEmpId;
        $currentDate = date('Y-m-d'); 
        $currentYear = date('Y', strtotime($currentDate)); 
        if (date('n', strtotime($currentDate)) < 4) {
            $startFinancialYear = ($currentYear - 1) . '-04-01';
            $endFinancialYear = $currentYear . '-03-31';
        } else {
            $startFinancialYear = $currentYear . '-04-01';
            $endFinancialYear = ($currentYear + 1) . '-03-31';
        }
        
        $results = Employee::select('*')
            ->whereIn('id', $getAllEmpId)
            ->where('deleteFlag', 0)
            ->orderBy('emp_name');
            
        if ($request->keyword) {
            $results = $results->where(function ($query) use ($request) {
                $query->orWhere('emp_name', 'like', '%' . $request->keyword . '%');
            });
        }
        if($request->paginate == 'true'){
            $results = $results->paginate(15);
            $paginationDetails = $results->toArray();
            unset($paginationDetails['data']);
            
        } else {
            $results = $results->get();
            $paginationDetails = null;
        }
        $leaveBalanceResponse = [];
        foreach ($results as $row) {
            $empId = $row->id;
            $region = Employee::select('region','empDesignation')->where('id',$empId)->first();
            // dd($region);
            $regionId = isset($region)?$region->region:'';
            $designationId = isset($region)?$region->empDesignation:'';
            $query2 = $leaveTypes = LeaveType::select('tbl_leavetype.*', 'tbl_designation_wise_leave.leaveCount', 'tbl_designation_wise_leave.id as leaveTypeId')
                        ->leftJoin('tbl_designation_wise_leave', function ($join) use ($designationId) {
                            $join->on('tbl_leavetype.id', '=', 'tbl_designation_wise_leave.leaveType')
                                ->where('tbl_designation_wise_leave.designationId', $designationId)
                                ->where('tbl_designation_wise_leave.isDeleted', 0);
                        })
                        ->where('tbl_leavetype.leave_status', 1)
                        ->where('tbl_leavetype.isDeleted', 0)
                        ->get();
            
            $leaveTypeCount = $query2->count();
            $leaveData = [];
            $totalLeaves = 0;
            $totalTakenLeaves = 0;
            
            foreach ($query2 as $data) {
                $leaveCount = $data->leaveCount ?? 0;
                $leaveType = $data->id;
                $leaveSql = LeaveApplicationDetail::selectRaw('COUNT(*) as totalTakenLeavesCurMonth')
                    ->leftJoin('tbl_leave_application', 'tbl_leave_application_details.leave_id', '=', 'tbl_leave_application.leave_id')
                    ->where('tbl_leave_application_details.emp_id', $empId)
                    ->where('tbl_leave_application.leave_type_id', $leaveType)
                    ->whereBetween('tbl_leave_application_details.leave_date', [$startFinancialYear, $endFinancialYear])
                    ->first();
                
                $totalTakenLeaves += $leaveSql->totalTakenLeavesCurMonth ?? 0;
                $totalLeaves += $leaveCount;
                
                $leaveData[] = [
                    'leaveTypeId' => $data['id'],
                    'leaveType' => $data['leavetype'],
                    'totalLeaveCount' => $leaveCount,
                    'totalLeaveTaken' => $leaveSql->totalTakenLeavesCurMonth ?? 0
                ];
            }
            // dd($leaveData);
            $sqlLeaveBal = LeaveApplicationDetail::selectRaw('COUNT(*) as totalApply, SUM(CASE WHEN tbl_leave_application.isApproved = 1 THEN 1 ELSE 0 END) AS totalApproved')
                ->leftJoin('tbl_leave_application', 'tbl_leave_application_details.leave_id', '=', 'tbl_leave_application.leave_id')
                ->where('tbl_leave_application_details.emp_id', $empId)
                ->whereBetween('tbl_leave_application_details.leave_date', [$startFinancialYear, $endFinancialYear])
                ->first();
            
            $balanceLeave = ($totalTakenLeaves >= $totalLeaves) ? 0 : $totalLeaves - $totalTakenLeaves;
            
            $leaveBalanceResponse[] = [
                'employeeName' => $row->emp_name,
                'totalLeaves' => $totalLeaves,
                'balanceLeave' => $balanceLeave,
                'approvedLeave' => ($sqlLeaveBal->totalApproved) ? $sqlLeaveBal->totalApproved : 0,
                'applyLeave' => ($sqlLeaveBal->totalApply) ? $sqlLeaveBal->totalApply : 0,
                'leaveTypeCount' => $leaveTypeCount,
                'leaveData' => $leaveData,
            ];
        }
        
        return response()->json(['code' => 200,'data'=>$leaveBalanceResponse,'paginate' => $paginationDetails]);
    }
    
    
    //======================================= Salary Generation ===================================
    public function generateSalarySlip(Request $request){ 
        
        try {
            $data = $request->json()->all();
            
            if (isset($data['id'])) { 
                $SalaryGenerate = SalaryGenerate::find($data['id']);
            } else {
                $SalaryGenerate = new SalaryGenerate();
            }
            // Check if a Salary slip with the same name already exists
            $existingDeduction = SalaryGenerate::where('empId', $request->empId)->where('year', $request->year)->where('month', $request->month)->where('deleteFlag', 0)->first();
            
            if ($existingDeduction) {
                return response()->json([
                    'code' => 201,
                    'message' => "Salary slip with the same month and employee  already exists"
                ]);
            } else {
                $SalaryGenerate->empId = $data['empId'];
                $SalaryGenerate->year = $data['year'];
                $SalaryGenerate->month = $data['month'];
                $SalaryGenerate->salaryDetail = json_encode($data['salary_details']);
                $SalaryGenerate->generated_by = $data['generated_by'];
                $SalaryGenerate->created_at = date('Y-m-d h:i:s');
                
                $SalaryGenerate->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "Slip generated successfully"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                //'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data"
            ]);
        }
    }
    
    public function getEmployeeDataForSalGenerate(Request $request){
        try {
            $year = $request->year;
            $month = $request->month;
            $empResult = DB::table('tbl_employee as t1')
                            ->select('t1.*','t2.designationName','t3.category_name')
                            ->leftJoin('tbl_designation as t2','t1.empDesignation','t2.designationId')
                            ->leftJoin('tbl_category as t3','t1.region','t3.category_id')
                            ->where('id',$request->empId)
                            ->first();
                            
            $leaveArray = $this->getLeavesData($year, $month, $empResult->region, $empResult->id);
                
            if (isset($leaveArray[0])) {
                $lwp = $leaveArray[0]['LWP'];
                $workingDay = $leaveArray[0]['workingDays'];
            } else {
                $lwp = 0; 
                $workingDay = 0; 
            }
            
            $earningList = Allowance::where('deleteFlag',0)->pluck('allowanceName','id');
            $deductionList = Deduction::where('deleteFlag',0)->pluck('deductionName','id');
            $earningArray = json_decode($empResult->earning,true);
            $deductionArray = json_decode($empResult->deduction,true);
            
            $earningsWithName = [];
            foreach ($earningList as $id => $name) {
                $earningsWithName[$name] = isset($earningArray[$id]) ? $earningArray[$id] : 0;
            }
            
            $deductionsWithName = [];
            foreach ($deductionList as $id => $name) {
                $deductionsWithName[$name] = isset($deductionArray[$id]) ? $deductionArray[$id] : 0;
            }
            $totalEarning = array_sum(array_values($earningsWithName));
            $totalDeduction = array_sum(array_values($deductionsWithName));
            $totalPayable = $totalEarning - $totalDeduction;
            
            $totalDays = cal_days_in_month(CAL_GREGORIAN,$month,$year);
            $perDaySalary = $totalPayable/$totalDays;
            
            $lwpAmount = $lwp*$perDaySalary;
            
            $deductionsWithName['LWP Amount'] = $lwpAmount;
                
            $data = [
                "empName" => $empResult->emp_name,
                "employee_no" => $empResult->EDP_code,
                "date_of_joining" => $empResult->date_of_joining,
                "designation" => $empResult->date_of_joining,
                "department" => '',
                "designation" => $empResult->designationName,
                "region" => $empResult->category_name,
                "workingDays" => $workingDay,
                "lwp" => $lwp,
                "bankDetail" => json_decode($empResult->bankDetails,true),
                "earning" => $earningsWithName,
                "deduction" => $deductionsWithName,
                "totalEarning" => $totalEarning,
                "totalDeduction" => $totalDeduction,
                "netPay" => $totalPayable,
                "netPayInWord" =>  $this->convertNumberToWords($totalPayable),
                
            ]; 
            return response()->json([
                'code' => 200,
                'message' => "Salary data fetched successfully",
                'data' => $data
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
    
    public function getSalarySlipV2(Request $request){
        $month = $request->month;
        $year = $request->year;
        $empId = $request->empID;
        
        $query = DB::table('tbl_salary_generate as t1')->leftJoin('tbl_employee as t2','t1.empId','t2.id')
                    ->where('t1.empId',$empId)
                    ->where('t1.year',$year)
                    ->where('t1.month',$month)
                    ->get()->toArray();
        $count1 = count($query);

        $dateObj = Carbon::createFromFormat('m', $month);
        $monthName = $dateObj->format('F');
        //$data = array();
        if ($count1 > 0) {
            foreach ($query as $row) {
                $salaryData = json_decode($row->salaryDetail, true);

                $earningsCount = count($salaryData['earnings']);
                $deductionsCount = count($salaryData['deductions']);

                $salaryData['earnings_row_count'] = $earningsCount;
                $salaryData['deductions_row_count'] = $deductionsCount;

                $modifiedSalaryJsonData = json_encode($salaryData, JSON_PRETTY_PRINT);
                $leaveArray = $this->getLeavesData($year, $month, $row->region, $empId);

                $data = [
                    "empId" => $row->empId,
                    "Month" => $monthName . ' ' . $year,
                    "salaryDetails" => json_decode($modifiedSalaryJsonData),
                    "leaveDetails" => $leaveArray,
                ];
            }
            return response()->json(['code'=>200,'data'=> $data]);
        }else{
            return response()->json(['code'=>201,'message'=> 'Data not available']);
        }
    }
    
    //=============================== Salary Report ========================================
    public function getEmployeewiseSalaryReport(Request $request){
        try {
            $year = $request->year;
            $month = $request->month;
            
            $getAllRegionId = $this->apiController->getRegionId($request->regionIndex);
            //dd($getAllRegionId);
            $empResults = DB::table('tbl_employee as t1')
                            ->select('t1.*','t2.designationName','t3.category_name')
                            ->leftJoin('tbl_designation as t2','t1.empDesignation','t2.designationId')
                            ->leftJoin('tbl_category as t3','t1.region','t3.category_id')
                            ->whereIn('t1.region',explode(',',$getAllRegionId))
                            ->where('t1.deleteFlag',0);
            if ($request->keyword) {
                $empResults = $empResults->Where(function ($query) use ($request) {
                    $query->orWhere('t1.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t1.emp_mobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t2.designationName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t3.category_name', 'like', '%' . $request->keyword . '%');
                    
                });
            }
            
            if($request->paginate == 'true'){
                $empResults = $empResults->paginate(10);
            }else{
                $empResults = $empResults->get();
            }
            //dd($empResults);
            foreach($empResults as $empResult)
            {
                $leaveArray = $this->getLeavesData($year, $month, $empResult->region, $empResult->id);
                
                if (isset($leaveArray[0])) {
                    $lwp = $leaveArray[0]['LWP'];
                } else {
                    $lwp = 0; 
                }
                //dd($leaveArray);
                //$lwp = $leaveArray['LWP'];
                
                $earningList = Allowance::where('deleteFlag',0)->pluck('allowanceName','id');
                $deductionList = Deduction::where('deleteFlag',0)->pluck('deductionName','id');
                $earningArray = json_decode($empResult->earning,true);
                $deductionArray = json_decode($empResult->deduction,true);
                
                $earningsWithName = [];
                foreach ($earningList as $id => $name) {
                    $earningsWithName[$name] = isset($earningArray[$id]) ? $earningArray[$id] : 0;
                }
                
                $deductionsWithName = [];
                foreach ($deductionList as $id => $name) {
                    $deductionsWithName[$name] = isset($deductionArray[$id]) ? $deductionArray[$id] : 0;
                }
                $totalEarning = array_sum(array_values($earningsWithName));
                $totalDeduction = array_sum(array_values($deductionsWithName));
                $totalPayable = $totalEarning - $totalDeduction;
                
                $totalDays = cal_days_in_month(CAL_GREGORIAN,$month,$year);
                $perDaySalary = $totalPayable/$totalDays;
                
                $lwpAmount = $lwp*$perDaySalary;
                
                $deductionsWithName['LWP Amount'] = $lwpAmount;
                
                $data[] = [
                    "year" => $year,
                    "month" => $month,
                    "status" => 0, // sending it only for front end logic
                    "empId" => $empResult->id,
                    "empName" => $empResult->emp_name,
                    "employee_no" => $empResult->EDP_code,
                    "empMobile" => $empResult->emp_mobile,
                    "date_of_joining" => $empResult->date_of_joining,
                    "designation" => $empResult->date_of_joining,
                    "department" => '',
                    "designation" => $empResult->designationName,
                    "region" => $empResult->category_name,
                    "bankDetail" => json_decode($empResult->bankDetails,true),
                    "lwp" => $lwp,
                    "earning" => $earningsWithName,
                    "deduction" => $deductionsWithName,
                    "totalEarning" => $totalEarning,
                    "totalDeduction" => $totalDeduction,
                    "netPay" => $totalPayable,
                    "netPayInWord" =>  $this->convertNumberToWords($totalPayable)
                ]; 
            }
            if($request->paginate == 'true'){
                $paginate = $empResults->toArray();
                unset($paginate['data']);
            }else{
                $paginate = null;
            }
            
            return response()->json([
                'code' => 200,
                'message' => "Salary data fetched successfully",
                'data' => $data,
                'paginate' => $paginate
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
    
    //============================ common required functions ===============================
    public function getLeavesData($year,$month,$regionId,$empId){
        $currentYear = $year; 
        
        if ($month < 4) {
            $startFinancialYear = ($currentYear - 1) . '-04-01';
            $endFinancialYear = $currentYear . '-03-31';
        } else {
            $startFinancialYear = $currentYear . '-04-01';
            $endFinancialYear = ($currentYear + 1) . '-03-31';
        }
        
        
        $fromDate  = date($year.'-'.$month.'-01');
        $toDate = date($year.'-'.$month.'-31');
       
        $dateTime1 = new DateTime($fromDate);
        $dateTime2 = new DateTime($toDate);
        $interval = $dateTime1->diff($dateTime2);
        
        $totalDays = $interval->days+1;
        
        $fromDateObj = new DateTime($fromDate);
        
        $inputCategoryId = $regionId; // Replace with your desired category_id
        if($inputCategoryId == 1){
            $unitId = 1;
        }else{
            $unitResult = DB::select(DB::raw("SELECT FindImportantCategory(?) as unitName"), [$inputCategoryId]);
            // print_r($unitResult);
            // Access the result
            $unitName = $unitResult[0]->unitName;
            
            $category = Category::where('category_name', $unitName)->first();
            if ($category) {
                $unitId = $category->category_id;
            } else {
                $unitId = '';
            }
        }
        
        if ($unitId == 1) {
            $holidayDateArray = DB::table('tbl_holydaycalender')
                ->selectRaw('date')
                ->whereBetween('date', [$fromDate, $toDate])
                ->where('isDeleted', '0')
                ->get()
                ->pluck('date')
                ->toArray(); 
        } else {
            $holidayDateArray = DB::table('tbl_holydaycalender')
                ->selectRaw('date')
                ->where('region', $unitId)
                ->where('isDeleted', '0')
                ->whereBetween('date', [$fromDate, $toDate])
                ->get()
                ->pluck('date')
                ->toArray(); 
        }
       
        $weekOffDate = $this->countSundaysBetweenDates($fromDate, $toDate);
        $totalSundays = count($weekOffDate);
        
        $holidayCount = count($holidayDateArray);
        $totalHoliday = $totalSundays+$holidayCount;
        $totalWorkingDay = $totalDays-$totalHoliday;
        
        $empData = Employee::select('region','empDesignation')->where('id',$empId)->first();
        // dd($empData);
        $designationId = isset($empData)?$empData->empDesignation:'';
        $totalLeaves = $this->fetchBalanceLeave($startFinancialYear, $toDate, $designationId);
        
        $paidDays = DayStart::where('uid', $empId)
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->count();
        
        // Query to count total leaves taken
        $leavesTake = LeaveApplicationDetail::where('emp_id', $empId)
                        ->whereBetween('leave_date', [$fromDate, $toDate])
                        ->count();
        
        
        $payment = array();
        $absentDays = $totalWorkingDay - ($paidDays+$leavesTake);
        //fetch lwp
        $edate = date('Y-m-d', strtotime('-1 month', strtotime($toDate))); 
        $endDate  = date('Y-m-d', strtotime('-1 day', strtotime($edate)));
        
        $query1 = LeaveApplicationDetail::where('emp_id', $empId)
            ->whereBetween('leave_date', [$startFinancialYear, $endDate])
            ->count();
        
        $totalTakenLeaves = $query1;
        
        if ($totalTakenLeaves >= $totalLeaves) {
            $totalBalanceLeave = 0;
        } else {
            $totalBalanceLeave = $totalLeaves - $totalTakenLeaves;
        }
        
        // Calculate total days in the month
        $totalDays = cal_days_in_month(CAL_GREGORIAN, $month, $year);
        
        if ($totalBalanceLeave == 0) {
            $allLeaves = $totalWorkingDay - $paidDays;
            $paidLeaves = 0;
            $lwp = 0;
        } else {
            $totalTakenLeavesCurMonth = LeaveApplicationDetail::where('emp_id', $empId)
                ->whereBetween('leave_date', [$fromDate, $toDate])
                ->count();
        
            if ($totalBalanceLeave > $totalTakenLeavesCurMonth) {
                $lwp = $absentDays;
                $paidLeaves = $leavesTake;
            } else {
                $lwp = ($totalTakenLeavesCurMonth - $totalBalanceLeave) + $absentDays;
                $paidLeaves = $totalTakenLeavesCurMonth - $totalBalanceLeave;
            }
        }
        
        
        array_push(
            $payment,array(
                'monthName' => date('F Y',strtotime($fromDate)),
                'workingDays' => $totalWorkingDay,
                'LWP' => $lwp,
                'PaidLeaves' => $paidLeaves,
                'presentDays' => $paidDays,
                'balanceLeave' => $totalBalanceLeave
        ));
        return $payment;
    }
    /// convert digit to word 
    public function convertNumberToWords($number)
    {
        $hyphen = '-';
        $conjunction = ' and ';
        $separator = ', ';
        $negative = 'negative ';
        $decimal = ' point ';
        $dictionary = [
            0 => 'Zero',
            1 => 'One',
            2 => 'Two',
            3 => 'Three',
            4 => 'Four',
            5 => 'Five',
            6 => 'Six',
            7 => 'Seven',
            8 => 'Eight',
            9 => 'Nine',
            10 => 'Ten',
            11 => 'Eleven',
            12 => 'Twelve',
            13 => 'Thirteen',
            14 => 'Fourteen',
            15 => 'Fifteen',
            16 => 'Sixteen',
            17 => 'Seventeen',
            18 => 'Eighteen',
            19 => 'Nineteen',
            20 => 'Twenty',
            30 => 'Thirty',
            40 => 'Forty',
            50 => 'Fifty',
            60 => 'Sixty',
            70 => 'Seventy',
            80 => 'Eighty',
            90 => 'Ninety',
            100 => 'Hundred',
            1000 => 'Thousand',
            1000000 => 'Million',
            1000000000 => 'Billion',
            1000000000000 => 'Trillion',
            1000000000000000 => 'Quadrillion',
            1000000000000000000 => 'Quintillion'
        ];

        if (!is_numeric($number)) {
            return false;
        }

        if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
            // overflow
            trigger_error(
                'convertNumberToWords only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
                E_USER_WARNING
            );
            return false;
        }

        if ($number < 0) {
            return $negative . $this->convertNumberToWords(abs($number));
        }

        $string = $fraction = null;

        if (strpos($number, '.') !== false) {
            list($number, $fraction) = explode('.', $number);
        }

        switch (true) {
            case $number < 21:
                $string = $dictionary[$number];
                break;
            case $number < 100:
                $tens = ((int) ($number / 10)) * 10;
                $units = $number % 10;
                $string = $dictionary[$tens];
                if ($units) {
                    $string .= $hyphen . $dictionary[$units];
                }
                break;
            case $number < 1000:
                $hundreds = $number / 100;
                $remainder = $number % 100;
                $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
                if ($remainder) {
                    $string .= $conjunction . $this->convertNumberToWords($remainder);
                }
                break;
            default:
                $baseUnit = pow(1000, floor(log($number, 1000)));
                $numBaseUnits = (int) ($number / $baseUnit);
                $remainder = $number % $baseUnit;
                $string = $this->convertNumberToWords($numBaseUnits) . ' ' . $dictionary[$baseUnit];
                if ($remainder) {
                    $string .= $remainder < 100 ? $conjunction : $separator;
                    $string .= $this->convertNumberToWords($remainder);
                }
                break;
        }

        if (null !== $fraction && is_numeric($fraction)) {
            $string .= $decimal;
            $words = [];
            foreach (str_split((string) $fraction) as $number) {
                $words[] = $dictionary[$number];
            }
            $string .= implode(' ', $words);
        }

        return $string;
    }
}