<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\FarmerMeeting;
use App\Models\UpdateKeyNew;
use App\Http\Controllers\APIController;

class FmController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
        public function getFMApprovalReport(Request $request)
{
    try {
        $result = DB::table('tbl_farmermeeting as tfm');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function($query) use($request){
                $query->orWhere('tfm.farmerRegion', 'like', '%'.$request->keyword.'%' );
                $query->orWhere('tfm.fmType', 'like', '%'.$request->keyword.'%' );
                $query->orWhere('te.emp_name', 'like', '%'.$request->keyword.'%' );
            });
        }

        $result =$result
                    ->leftJoin('tbl_employee as te', 'te.id', '=', 'tfm.empId')
                    ->leftJoin('tbl_meeting as tm', 'tm.meeting_id', '=', 'tfm.fmType')
                    ->where('tfm.approvstatus', 0);

        if ($request->paginate == "true") {
            $result = $result->select('tfm.fmId', 'tfm.fmDate', 'te.emp_name', 'tm.meeting_name', 'tfm.fmRemark', 'tfm.fmNos',
                                     DB::raw("CONVERT(CAST(CONVERT(tfm.villageNameID USING latin1) AS BINARY) USING utf8mb4) as villageNameID")
            );
        } else {
            $result = $result->select('tfm.*', 'te.*', 'tm.*');
        }

        // If time frame value is not "0", apply date filter
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfm.fmDate',[$fromDate,$toDate]);
        }

        // If region index is provided, apply region filter
        if ($request->empID) {
            $result = $result->where('tfm.empId', $request->empID);
        }

        if ($request->regionID) {
            $regionId = $request->regionID;
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionID);
            $result = $result->whereIn('te.region', explode(',', $getAllRegionIDs));
        }

        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "FM fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}

public function approvefm(Request $request) {
        try {

           $approveData = FarmerMeeting::where('fmId', $request->fmId)
                      ->where('approvstatus', 0)
                      ->update([
                          'approvstatus' => 1,
                          'Aprove_Date' => now() // Use `now()` function to get the current date and time
                      ]);
            $id = 1;
            $updateKey = UpdateKeyNew::find($id);
            $updateKey->FMGroupList += 1;
            $updateKey->FMNightList += 1;
            $updateKey->save();

             return response()->json([
                'code' => 200,
                'message' => "FM approved successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }

    }
     public function rejectfm(Request $request) {
        try {
              $approveData = FarmerMeeting::where('fmId', $request->fmId)
                       ->where('approvstatus', 0)
                       ->update([
                          'approvstatus' => 2,
                          'Aprove_Date' => now() // Use `now()` function to get the current date and time
              ]);

              $id = 1;
              $updateKey = UpdateKeyNew::find($id);
              $updateKey->FMGroupList += 1;
              $updateKey->FMNightList += 1;
              $updateKey->save();

              return response()->json([
                'code' => 200,
                'message' => "FM Rejected successfully"
              ]);
        } catch (\Exception $e) {
            dd($e);
               return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop"
          ]);
          }

    }
}
