<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\UpdateKeyNew;
use App\Models\FeildDay;
use App\Http\Controllers\APIController;

class FdController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    public function getFdApprovalReport(Request $request)
{
    try {
        $result = DB::table('tbl_farmactivityFD as tfd');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.FD_date', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_farmer as tf', 'tfd.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tfd.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->where('te.deleteFlag', false);

        if ($request->paginate == "true") {
            $result = $result->select('tfd.fafdId', 'tfd.FD_Req_Date', 
                                         DB::raw("CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),
                                         DB::raw("CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"),
                                        'tf.farmerMobile', 'te.emp_name', 'tcc.category_name');
        } else {
            $result = $result->select('tfd.fafdId', 'tfd.FD_Req_Date', 
                                         DB::raw("CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),
                                         DB::raw("CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"),
                                        'tf.farmerMobile', 'te.emp_name', 'tcc.category_name');
        }

        $result = $result->where('tfd.approvstatus', 0);

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfd.FD_Req_Date', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tfd.empId', $request->empID);
        }

        if ($request->regionID) {
            $regionId = $request->regionID;
            $categoryIDWithParent = $regionId . ',' . $this->apiController->getRegionId($regionId);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $result = $result->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
        }

        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "FD fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}

    public function approvefd(Request $request)
    {
        try {
            $fdData = FeildDay::where('fafdId', $request->fafdId)->update([
                'approvstatus' => 1,
                'Aprove_Date' => now(), // Use `now()` function to get the current date and time
            ]);
            
            $id = 1;
            $updateKey = UpdateKeyNew::find($id);
            $updateKey->FDList += 1;
            $updateKey->save();
            $updatedList = $updateKey->FDList;

            return response()->json([
                'code' => 200,
                'message' => "Fd approved successfully",
            ]);
        } catch (\Exception $e) {
            dd($e->getMessage());
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
    public function rejectfd(Request $request)
    {
        try {
            $fdData = FeildDay::where('fafdId', $request->fafdId)
                ->where('approvstatus', 0)
                ->update([
                    'approvstatus' => 2,
                    'Aprove_Date' => now(), // Use `now()` function to get the current date and time
                ]);

            return response()->json([
                'code' => 200,
                'message' => "Fd Rejected successfully",
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
}
