<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\FarmerProfileSeason;
use App\Http\Controllers\APIController;

class FarmerProfileSeasonController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }

    public function submitFarmerSeason(Request $request)
    {
        try {
            if ($request->id) {
                $FarmerProfileSeasonData = FarmerProfileSeason::find($request->id);
                $FarmerProfileSeasonData->durationName = $request->FarmerProfileSeasonName;
                $FarmerProfileSeasonData->activeStatus = $request->activeStatus;
                $FarmerProfileSeasonData->save();
                
                $lastInsertedId = $request->id;
                
                if($request->activeStatus == 0 && $lastInsertedId) {
                    FarmerProfileSeason::where('id', '!=', $lastInsertedId)
                                    ->update([
                                            'activeStatus' => 1,
                                            'deactivated_on' => date('Y-m-d h:i:s')
                                    ]); 
                    
                    FarmerProfileSeason::where('id', '=', $lastInsertedId)
                                    ->update([
                                            'activated_on' => date('Y-m-d h:i:s')
                                    ]);
                }
                
                return response()->json([
                    'code' => 200,
                    'message' => "Data Updated successfully",
                ]);
            } else {
                $FarmerProfileSeasonData = new FarmerProfileSeason();
                
                $rowAffectedForData = FarmerProfileSeason::where('durationName', $request->FarmerProfileSeasonName)
                    ->where('deleteFlag', 0)
                    ->count();
            
                if ($rowAffectedForData == 0 || $rowAffectedForData > 1) {
                    $FarmerProfileSeasonData->durationName = $request->FarmerProfileSeasonName;
                    $FarmerProfileSeasonData->activeStatus = $request->activeStatus;
                    $FarmerProfileSeasonData->save();
                    
                    $lastInsertedId = $FarmerProfileSeasonData->id;
                    
                    if($request->activeStatus == 0 && $lastInsertedId) {
                        FarmerProfileSeason::where('id', '!=', $lastInsertedId)
                                        ->update([
                                                'activeStatus' => 1,
                                                'deactivated_on' => date('Y-m-d h:i:s')
                                        ]); 
                        
                        FarmerProfileSeason::where('id', '=', $lastInsertedId)
                                        ->update([
                                                'activated_on' => date('Y-m-d h:i:s')
                                        ]);
                    }
                    
                    return response()->json([
                        'code' => 200,
                        'message' => "Data Save successfully",
                    ]);
                }else{
                    return response()->json(['code' => 201, 'message' => 'Data already available']);
                }
            }
            
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    
    public function getFarmerProfileSeason(Request $request)
    {
        try {
            $FarmerProfileSeasonData = FarmerProfileSeason::select('id', 'durationName', 'activated_on', 'deactivated_on', 'activeStatus')
                ->where('deleteFlag', 0)
                ->orderBy('id', 'desc');

            if ($request->paginate == "true") {
                $FarmerProfileSeasonData = $FarmerProfileSeasonData->select('id', 'durationName', 'activated_on', 'deactivated_on', 'activeStatus');
            } else {
                $FarmerProfileSeasonData = $FarmerProfileSeasonData->select('id', 'durationName', 'activated_on', 'deactivated_on', 'activeStatus');
            }

            $totalCount = $FarmerProfileSeasonData->count();

            if ($request->paginate == "true") {
                $FarmerProfileSeasonData = $FarmerProfileSeasonData->simplePaginate();
            } else {
                $FarmerProfileSeasonData = $FarmerProfileSeasonData->get()->toArray();
            }

            // Get the total record count

            return response()->json([
                'code' => 200,
                'data' => $FarmerProfileSeasonData,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                // 'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteFarmerProfileSeason(Request $request)
    {
        try {
            if($request->id){
                $FarmerProfileSeasonData = FarmerProfileSeason::find($request->id);
                $FarmerProfileSeasonData->deleteFlag = 1;
                $FarmerProfileSeasonData->save();
    
                return response()->json([
                    'code' => 200,
                    'message' => "data deleted successfully",
                ]);
            }else{
                return response()->json([
                    'code' => 500,
                    'error' => $e->getMessage(),
                    'message' => "Data not available",
                ]);
            }
        } catch (\Exception $e) {
            // dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting data",
            ]);
        }
    }
}
