<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\Agency;
use App\Models\AgencyDetail;
use App\Http\Controllers\APIController;

class FarmerProfileReportController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
   
    public function getFarmerProfileData(Request $request)
    {
        
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $farmerID = $request->farmerID;

        $result = DB::table('tbl_farmer_profiling as tf')
                    ->select('tf.id', 'cropId', 'acerage', 'farmerProfileDate', 'tf.productIds','tf.productAcreage','tf.using_company_product',
                        'tf.activity_time as factivity_time', 'te.emp_name',
                        DB::raw('CONVERT(CAST(CONVERT(tc.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                        'tcc.category_name','durationName');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerProfileDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ts.durationName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('ft.typeName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('fbp.patternName', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_farmer as tc', 'tc.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tc.farmerRegion')
            ->leftJoin('tbl_farmerProfilingSeason as ts', 'ts.id', '=', 'tf.seasonId')
            ->leftJoin('tbl_farmer_type as ft', 'tc.farmerType', '=', 'ft.id')
            ->leftJoin('tbl_farmerBuyingPattern as fbp', 'tc.farmerBuyingPattern', '=', 'fbp.id')
            ->orderBy('tf.id', 'desc');

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tf.farmerProfileDate', [$fromDate, $toDate]);
        }

        if ($request->farmerID) {
            $result = $result->where('tf.farmerId', $request->farmerID);
        }else {
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
            $result = $result->whereIn('tc.farmerRegion', explode(',', $getAllRegionIDs));
        }
        
        if ($request->farmerSeason) {
            $result = $result->where('tf.seasonId', $farmerSeason);
        }
        
        if ($request->farmerCrop) {
            $result = $result->where(function ($query) use ($request) {
                $query->where('tf.cropId', 'like', '%#' . $request->farmerCrop . '#%')
                      ->orWhere('tf.cropId', 'like', '%' . $request->farmerCrop . '#%')
                      ->orWhere('tf.cropId', 'like', '%#' . $request->farmerCrop . '%');
            });
        }
        
        if ($request->productIds) {
            $result = $result->where(function ($query) use ($request) {
                $query->where('tf.productIds', 'like', '%#' . $request->productIds . '#%')
                      ->orWhere('tf.productIds', 'like', '%' . $request->productIds . '#%')
                      ->orWhere('tf.productIds', 'like', '%#' . $request->productIds . '%');
            });
        }
        
        if ($request->waterDepend) {
            $result = $result->where('tc.farmerWaterDependency', $request->waterDepend );
        }
        if ($request->productUse) {
            $result = $result->where('tf.using_company_product', $request->productUse);
        }
        if ($request->farmerBuyingPattern) {
            $result = $result->where('tc.farmerBuyingPattern', $request->farmerBuyingPattern);
        }
        if ($request->farmerType) {
            $result = $result->where('tc.farmerType', $request->farmerType);
        }
        
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->paginate(15);
        } else {
            $result = $result->get();
        }
        
        $cropData = $this->apiController->getAllCropsList();
        
        $data = [];
        if(count($result) > 0){
            foreach ($result as $row) {
                $cropAcreage = ($row->acerage)? explode('#',$row->acerage):[];
                // $cropAcreage = explode('#',$row->acerage);
                $crop_name = [];
                if($row->cropId){
                    $cropNameString = explode('#',$row->cropId);
                    for($j = 0;$j < count($cropNameString);$j++){
                        $cid = $cropNameString[$j];
                        $key2 = '';
                        $key2 = array_search($cid, array_column($cropData, 'cropId'));
                        if ($key2 === false) {
                            $crop_name[] = 'NA';
                        } else {
                            $crop_name[] = $cropData[$key2]['cropName'];
                        }
                    }
                }
                
                $ProductValArry = $this->apiController->getAllProductsList();
                
                $farmerProductNameArray = [];
                
                $farmerProductAcreageArray = ($row->productAcreage) ? explode('#', $row->productAcreage) : [];
    
                if ($row->productIds) {
                    $farmerProductArray = explode('#', $row->productIds);
                    foreach ($farmerProductArray as $Product) {
                        $key = array_search($Product, array_column($ProductValArry, 'pid'));
                        if ($key !== false) {
                            $farmerProductNameArray[] = $ProductValArry[$key]['productName'];
                        }
                    }
                }
                
                $data[] = [
                    'id' => $row->id,
                    'farmerName' => $row->farmerName,
                    'date' => $row->farmerProfileDate,
                    'activity_time' => $row->factivity_time,
                    'empName' => $row->emp_name,
                    'seasonName' => $row->durationName,
                    'crop' => $crop_name,
                    'acreage' => $cropAcreage,
                    'using_company_product' => $row->using_company_product,
                    'products' => $farmerProductNameArray,
                    'productAcreage' => $farmerProductAcreageArray,
                ];
            }
            $paginate = $result->toArray();
            unset($paginate['data']);
            return response()->json(['code' => 200, 'message' => 'Data fetch successfully','data' => $data,'pagination' => $paginate]);
        }else{
            return response()->json(['code' => 201, 'message' => 'Data not available','data' => $data]);
        }
        
        // return response()->json([
        //     'code' => 200,
        //     'report_data' => $result,
        //     'total_records' => $totalCount,
        // ]);
    
    }
    
    // existing farmer
    public function getExistingFarmerProfileData(Request $request)
    {
        
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $farmerSeason = $request->farmerSeason;

        $result = DB::table('tbl_farmer_profiling as tf')
                    ->select('tf.id', 'cropId', 'acerage', 'farmerProfileDate', 'tf.productIds','tf.productAcreage','tf.using_company_product',
                        'tf.activity_time as factivity_time', 'te.emp_name','tc.farmerName','tcc.category_name','durationName')
                    ->where('tf.using_company_product',1);

        if ($request->keyword) {
            $result = $result->Where(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerProfileDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_farmer as tc', 'tc.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tc.farmerRegion')
            ->leftJoin('tbl_farmerProfilingSeason as ts', 'ts.id', '=', 'tf.seasonId')
            ->orderBy('tf.id', 'desc');

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tf.farmerProfileDate', [$fromDate, $toDate]);
        }

        if ($request->farmerSeason) {
            $result = $result->where('tf.seasonId', $farmerSeason);
        }

        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->paginate(15);
        } else {
            $result = $result->get();
        }
        
        $cropData = $this->apiController->getAllCropsList();
        $data = [];
        if(count($result) > 0){
            foreach ($result as $row) {
                $cropAcreage = ($row->acerage)? explode('#',$row->acerage):[];
                // $cropAcreage = explode('#',$row->acerage);
                $crop_name = [];
                if($row->cropId){
                    $cropNameString = explode('#',$row->cropId);
                    for($j = 0;$j < count($cropNameString);$j++){
                        $cid = $cropNameString[$j];
                        $key2 = '';
                        $key2 = array_search($cid, array_column($cropData, 'cropId'));
                        if ($key2 === false) {
                            $crop_name[] = 'NA';
                        } else {
                            $crop_name[] = $cropData[$key2]['cropName'];
                        }
                    }
                }
                
                $ProductValArry = $this->apiController->getAllProductsList();
                
                $farmerProductNameArray = [];
                
                $farmerProductAcreageArray = ($row->productAcreage) ? explode('#', $row->productAcreage) : [];
    
                if ($row->productIds) {
                    $farmerProductArray = explode('#', $row->productIds);
                    foreach ($farmerProductArray as $Product) {
                        $key = array_search($Product, array_column($ProductValArry, 'pid'));
                        if ($key !== false) {
                            $farmerProductNameArray[] = $ProductValArry[$key]['productName'];
                        }
                    }
                }
                
                $data[] = [
                    'id' => $row->id,
                    'farmerName' => $row->farmerName,
                    'date' => $row->farmerProfileDate,
                    'activity_time' => $row->factivity_time,
                    'empName' => $row->emp_name,
                    'seasonName' => $row->durationName,
                    'crop' => $crop_name,
                    'acreage' => $cropAcreage,
                    'using_company_product' => $row->using_company_product,
                    'products' => $farmerProductNameArray,
                    'productAcreage' => $farmerProductAcreageArray,
                ];
            }
            $paginate = $result->toArray();
            unset($paginate['data']);
            return response()->json(['code' => 200, 'message' => 'Data fetch successfully','data' => $data,'pagination' => $paginate]);
        }else{
            return response()->json(['code' => 201, 'message' => 'Data not available','data' => $data]);
        }
        
        // return response()->json([
        //     'code' => 200,
        //     'report_data' => $result,
        //     'total_records' => $totalCount,
        // ]);
    
    }
    
}
