<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Employee;
use App\Models\Clients;
use App\Models\Farmer;
use App\Models\FarmerMeeting;
use App\Models\FarmActivity;
use App\Models\Revisit;
use App\Models\AgencyVisit;
use App\Models\Agency;
use App\Models\DayStart;
use App\Models\EmpActivityCount;
use File;
use App\Http\Controllers\APIController;

class ExportController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
  public function exportOverallRegionReport($regionID, Request $request) {
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $categoryIDWithParent = $regionID.','.$this->apiController->getChildren($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');

    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();

    $dataArray = [];
    foreach (explode(',', $getAllRegionIDs) as $value) {
      $getAllCountData = DB::table('tbl_activity_count_current_year')
                            ->selectRaw('sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count')
                            ->whereBetween('activityDate', [$fromDate, $toDate])
                            ->where('regionId', $value)
                            ->get()->toArray();
      $data['Region Name'] = $categoryData[$value];
      $data['IC Count'] = $getAllCountData[0]->ic_count ? $getAllCountData[0]->ic_count : 0;
      $data['SD Count'] = $getAllCountData[0]->sd_count ? $getAllCountData[0]->sd_count : 0;
      $data['SDV Count'] = $getAllCountData[0]->sdv_count ? $getAllCountData[0]->sdv_count : 0;
      $data['FD Count'] = $getAllCountData[0]->fd_count ? $getAllCountData[0]->fd_count : 0;
      $data['FM Count'] = $getAllCountData[0]->fm_count ? $getAllCountData[0]->fm_count : 0;
      $data['Agency Visit Count'] = $getAllCountData[0]->av_count ? $getAllCountData[0]->av_count : 0;
      $data['Revisit Count'] = $getAllCountData[0]->revisit_count ? $getAllCountData[0]->revisit_count : 0;
      $data['Dealer Profile Count'] = $getAllCountData[0]->dealer_profile_count ? $getAllCountData[0]->dealer_profile_count : 0;
      $data['Liquidation Count'] = $getAllCountData[0]->liquidation_count ? $getAllCountData[0]->liquidation_count : 0;

      array_push($dataArray, $data);
    }

    return response()->json([
      'code' => 200,
      'dataArray' => $dataArray,
    ]);
  }
  public function exportFieldActivityReport($regionID, Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $productIDs = $request->productIds;
    $cropIDs = $request->cropIds;

    $categoryIDWithParent = $regionID.','.$this->apiController->getChildren($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');

    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();
    $reportArray = [];
    foreach (explode(',', $getAllRegionIDs) as $value) {
      $data['Region Name'] = $categoryData[$value];
      $data['SD Count'] = $this->apiController->findSDAndSDVProduct('SD_date',$value,$productIDs,$cropIDs,$fromDate,$toDate);
      $data['SDV Count'] = $this->apiController->findSDAndSDVProduct('SDV_date',$value,$productIDs,$cropIDs,$fromDate,$toDate);
      $data['FD Count'] = $this->apiController->findProduct_fd($value,$productIDs,$cropIDs,$fromDate,$toDate);
      $data['FM Count'] = $this->apiController->findProduct_fm($value,$productIDs,$cropIDs,$fromDate,$toDate);

      array_push($reportArray, $data);
    }

    return response()->json([
      'code' => 200,
      'dataArray' => $reportArray,
    ]);
  }
  public function exportOverallAttendanceReport($regionID, Request $request) {
    $date = $request->date;

    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();
    $categoryIDWithParent = $regionID.','.$this->apiController->getChildren($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');
    $reportArray = [];

    foreach (explode(',', $getAllRegionIDs) as $value) {
      $empIDs = $this->apiController->getEmployeeId($value);

      $dayStart = DayStart::select('*')->whereIn('uid', $empIDs)->where('date',$date)->count();

      $data['region_name'] = $categoryData[$value].'-'.$value;
      $data['unit'] = $categoryData[$regionID];
      $data['total'] = count($empIDs);
      $data['present'] = $dayStart;
      $data['absent'] = count($empIDs) - $dayStart;

      array_push($reportArray, $data);
    }
    return response()->json([
      'code' => 200,
      'dataArray' => $reportArray,
    ]);
  }
   public function exportregionwiseAttendanceReport($regionID, Request $request) {
    $from_date = $request->from_date;
    $to_date = $request->to_date;
    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();
    $categoryIDWithParent = $regionID.','.$this->apiController->getChildren($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');
    $reportArray = [];

    foreach (explode(',', $getAllRegionIDs) as $value) {
      $empIDs = $this->apiController->getEmployeeId($value);

      $dayStart = DayStart::select('*')->whereIn('uid', $empIDs)->where('date',[$from_date, $to_date])->count();

      $data['region_name'] = $categoryData[$value].'-'.$value;
      $data['unit'] = $categoryData[$regionID];
      $data['total'] = count($empIDs);
      $data['present'] = $dayStart;
      $data['absent'] = count($empIDs) - $dayStart;

      array_push($reportArray, $data);
    }
    return response()->json([
      'code' => 200,
      'dataArray' => $reportArray,
    ]);
  }
  public function exportSummaryReport($gtype,$regionID) {
    $getRegion = DB::table('tbl_category')->where('parent_category_id',$regionID)->get()->toArray();
    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();
    $employeeData = DB::table('tbl_employee')->where('deleteFlag',0)->get()->pluck('emp_name', 'region')->toArray();
    $compititorData = DB::table('tbl_company_compitior')->get()->pluck('compititor_name', 'cid')->toArray();
    $reportArray = [];

    $regionIDs = $this->apiController->getRegionId($regionID);

    $result = DB::table('tbl_agency as ta')
                ->leftJoin('tbl_agencydetail as tad', 'tad.agencyId', '=', 'ta.agencyId')
                ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion')
                ->leftJoin('tbl_employee as te', 'te.id', '=', 'tad.empId')
                ->select('*')
                ->whereIn('ta.agencyRegion', explode(',', $regionIDs))
                ->where('ta.agencyType', $gtype)
                ->get()->toArray();

    $i = 1;
    foreach ($result as $value) {
      $data['Sr. No'] = $i;
      $data['Region Name'] = $value->category_name;
      $data['Employee Name'] = $value->emp_name;
      $data['Account Type'] = '';
      $data['SAP Code'] = $value->distributorCode;
      $data['Owner Name'] = $value->agencyName;
      $data['Shop Name'] = $value->agencyShopName;
      $data['Agency Mobile'] = $value->agencyMobile;
      $data['Total T/O (Ts. Lakh)'] = $value->agencyTurnover ? $value->agencyTurnover : '';
      $data['PGR'] = $value->sealerPgrPer ? $value->sealerPgrPer : '';
      $data['Plant Nutrition'] = $value->sellerPN ? $value->sellerPN : '';
      $data['Herbicide'] = $value->agencyHerbicidePer ? $value->agencyHerbicidePer : '';
      $data['Insecticides'] = $value->agencyInsecticidePer ? $value->agencyInsecticidePer : '';
      $data['Fungicides'] = $value->delaerFungicidePer ? $value->delaerFungicidePer : '';
      $data['Total GAVL T/O (Rs. Lakh)'] = $value->agencyGAPLTurnover ?  $value->agencyGAPLTurnover : '';
      $data['GAVL PGR'] = $value->sealerGAPLPgrPer ? $value->sealerGAPLPgrPer : '';
      $data['Plant Nutrition'] = $value->GAPLPN ? $value->GAPLPN : '';
      $data['Herbicide'] = $value->agencyGAPLHerbicidePer ? $value->agencyGAPLHerbicidePer : '';
      $data['Insecticides'] = $value->agencyGAPLInsecticidePer ? $value->agencyGAPLInsecticidePer : '';
      $data['Fungicides'] = $value->delaerGAPLFungicidePer ? $value->delaerGAPLFungicidePer : '';
      $data['First Company'] = array_key_exists($value->agencyFirstCompanyName, $compititorData) ? $compititorData[$value->agencyFirstCompanyName] : '';
      $data['First Company Total (T/O)'] = $value->agencyFirstCompanyTr ?  $value->agencyFirstCompanyTr : '';
      $data['Second Company'] = array_key_exists($value->agencySecCompanyName, $compititorData) ? $compititorData[$value->agencySecCompanyName] : '';
      $data['Second Company Total (T/O)'] = $value->agencySecCompanyTr ? $value->agencySecCompanyTr : '';
      $data['No of Farmers'] = $value->agencyFarmerNetwork ? $value->agencyFarmerNetwork : '';

      array_push($reportArray, $data);
      $i++;
    }

    return response()->json([
      'code' => 200,
      'dataArray' => $reportArray,
    ]);
  }
  private function getliquidationVisitList($regionIds,$fromDate,$toDate,$agencyType){
    $i = 0;
    $dateArray = array();

    $liquiData = DB::table('tbl_agencyvisit as tav')
                     ->leftJoin('tbl_agency as ta', 'tav.agencyId', '=', 'ta.agencyId')
                     ->select('tav.agencyId', 'ta.agencyRegion', 'ta.agencyShopName', 'ta.distributorCode', 'tav.empId')
                     ->where('tav.liquidation', 1)
                     ->where('ta.agencyType', $agencyType)
                     ->whereIn('tav.agencyRegion', explode(',',$regionIds))
                     ->whereBetween('tav.visitDate',[$fromDate, $toDate])
                     ->groupBy('tav.agencyId')
                     ->get()->toArray();

    return $liquiData;
  }
  private function liquidationEmployeeDetail($regionId){
    $empData = DB::table('tbl_employee as te')
                   ->leftJoin('tbl_designation as td', 'td.designationId', '=', 'te.empDesignation')
                   ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
                   ->whereIn('te.region', explode(',', $regionId))
                   ->where('te.deleteFlag', 0)
                   ->whereNotIn('te.empDesignation', [24])
                   ->get()->toArray();

    $employeeDetailArray = array();
    foreach ($empData as $value) {
      $employeeDetail['empId'] = $value->id;
      $employeeDetail['edpNum'] = $value->EDP_code;
      $employeeDetail['empName'] = $value->emp_name;
      $employeeDetail['empDesignation'] = $value->designationName;
      $employeeDetail['regionId'] = $value->region;
      $employeeDetail['regionName'] = $value->category_name;

      $employeeDetailArray[$value->id] = $employeeDetail;
      // array_push($employeeDetailArray, $employeeDetail);
    }

    return $employeeDetailArray;
  }
  public function exportStockReport(Request $request) {
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;
    $agencyType = $request->agencyType;

    $categoryData = DB::table('tbl_category')->get()->pluck('category_name', 'category_id')->toArray();
    $employeeData = DB::table('tbl_employee')->where('deleteFlag',0)->get()->pluck('emp_name', 'region')->toArray();
    $allProducts = $this->apiController->getAllProductName('All');

    $regionIDs = $this->apiController->getRegionId($regionID);
    $getLiquidationVisitList = $this->getliquidationVisitList($regionIDs, $fromDate, $toDate, $agencyType);
    $liquidationEmployeeDetail = $this->liquidationEmployeeDetail($regionIDs);

    foreach ($allProducts as $product){
        $pid = $product['pid'];
        $getliquidationDetail[] = $this->apiController->getliquidationDetail($regionIDs,$pid,$fromDate,$toDate,$agencyType);
    }
    $i = 1;
    $dataArray = [];
    foreach ($getLiquidationVisitList as $value) {
      $data['SrNo'] = $i;
      $data['UnitName'] = array_key_exists($regionID, $categoryData) ? $categoryData[$regionID] : '';
      $data['Region'] = '-';
      $data['Headquarter'] = '-';
      $data['WorkRegion'] = '-';
      $data['DistributorCode'] = $value->distributorCode;
      $data['AgencyName'] = $value->agencyShopName;
      $data['EDPNo'] = array_key_exists($value->empId, $liquidationEmployeeDetail) ? $liquidationEmployeeDetail[$value->empId]['edpNum'] : '';
      $data['EmployeeName'] = array_key_exists($value->empId, $liquidationEmployeeDetail) ? $liquidationEmployeeDetail[$value->empId]['empName'] : '';
      $data['Designation'] = array_key_exists($value->empId, $liquidationEmployeeDetail) ? $liquidationEmployeeDetail[$value->empId]['empDesignation'] : '';

      foreach ($allProducts as $product) {
        $keyIdPid = array_search($product['pid'], array_column($allProducts,'pid'));
        if ($keyIdPid) {
          $keyId = array_search($value->agencyId, array_column($getliquidationDetail[$keyIdPid],'agencyId'));
          if ($keyId) {
            $data[$product['pid']]['visitDate'] = $getliquidationDetail[$keyIdPid][$keyId]['visitDate'];
            $data[$product['pid']]['supply'] = $getliquidationDetail[$keyIdPid][$keyId]['supply'];
            $data[$product['pid']]['remaining'] = $getliquidationDetail[$keyIdPid][$keyId]['remaining'];
          } else {
            $data[$product['pid']]['visitDate'] = '-';
            $data[$product['pid']]['supply'] = 0;
            $data[$product['pid']]['remaining'] = 0;
          }
        }
      }

      array_push($dataArray, $data);
      $i++;
    }
    return response()->json([
      'code' => 200,
      'dataArray' => $dataArray,
    ]);
  }
}
