<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Employee;
use App\Models\UpdateKeyNew;
use App\Models\Category;
use App\Http\Controllers\ReadCSVController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\APIController;
use App\Http\Controllers\SendSMSController;
use Illuminate\Support\Facades\Crypt;
use StaticArray;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;

class EmployeeController extends Controller
{
    private $readCSVController;
    private $commonController;
    private $apiController;
    public function __construct(ReadCSVController $readCSVController, CommonController $cmnCtrl, APIController $apiController)
    {
        $this->readCSVController = $readCSVController;
        $this->commonController = $cmnCtrl;
        $this->apiController = $apiController;
        // $this->SendSMSController = $SendSMSController;
    }

    private function generatePassword($fullname, $mobiile)
    {
        $combineString = strtoupper(str_replace([".", " "], "", $fullname));
        $first4CharFromFullName = substr($combineString, 0, 4);
        $first4CharFromMobile = substr($mobiile, -4);

        return $first4CharFromFullName . $first4CharFromMobile;
    }
    public function addEmployee(Request $request)
    {
        $dbName = $request->header('usedwhich');

        if ($request->id) {
            $employee = Employee::find($request->id);
        } else {
            $employee = new Employee();

            $eidExist = Employee::where('emp_mobile', $request->personalInfo['mobile'])->exists();
            if ($eidExist) {
                return response()->json([
                    'code' => 500,
                    'message' => "Employee mobile already exists",
                ]);
            }

            $nextId = Employee::max('id') + 1; // Get the next available ID
            $eid = $dbName . '-emp' . $nextId;
            $employee->eid = $eid;
            // $employee->password = md5($this->generatePassword($request->personalInfo['username'], $request->personalInfo['mobile']));
            $randomNumber = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $employee->password = md5($randomNumber);
        }

        $employee->emp_name = $request->personalInfo['username'];
        $employee->emp_mobile = $request->personalInfo['mobile'];
        $employee->emp_email = $request->personalInfo['email'];
        $employee->dob = $request->personalInfo['dob'];
        $employee->address = $request->addressDetails['address'];
        $employee->tehsil = $request->addressDetails['tehsil'];
        $employee->district = $request->addressDetails['district'];
        $employee->state = $request->addressDetails['state'];
        $employee->villages = $request->addressDetails['villages'];
        $employee->empDesignation = $request->workDetails['designation'];
        $employee->web = $request->workDetails['web'];
        $employee->parent_empid = $request->workDetails['authority_emp'];
        $employee->addDate = $request->workDetails['doa'];
        $employee->date_of_joining = $request->workDetails['doj'];
        $employee->EDP_code = $request->workDetails['edp'];
        $employee->region = $request->workDetails['region'];
        $employee->billingRegion = $request->workDetails['billingRegion'];
        $employee->kmlimit = $request->allowencess['dailyKm'];
        $employee->lda = $request->allowencess['localDA'];
        $employee->oda = $request->allowencess['outstationDA'];
        $employee->ta = $request->allowencess['setTa2W'];
        $employee->taCar = $request->allowencess['setTa4W'];

        $employee->save();

        $id = 1;
        $updateKey = UpdateKeyNew::find($id);
        $updateKey->empList += 1;
        $updateKey->save();
        $updatedFarmerList = $updateKey->empList;
        if ($request->id) {
        } else {
            $mobile = $request->personalInfo['mobile'];
            $empName = $request->personalInfo['username'];
            $userName = $eid;
            $password = $randomNumber;
            $company = strtoupper($dbName);
            
            $SendSMSController = new SendSMSController();
            // Call the sendSms method with the necessary parameters
            $response = $SendSMSController->sendSMS($mobile, $empName,$userName,$password,$company);
        }

        return response()->json([
            'code' => 200,
            'message' => $request->id ? "Employee updated" : "New Employee added",
        ]);
    }
    
    public function addEmployeeV2(Request $request)
    {
        $dbName = $request->header('usedwhich');
        // dd($request->salaryDetails['pan_no']);
        if ($request->id) {
            $employee = Employee::find($request->id);
        } else {
            $employee = new Employee();

            $eidExist = Employee::where('emp_mobile', $request->personalInfo['mobile'])->exists();
            if ($eidExist) {
                return response()->json([
                    'code' => 500,
                    'message' => "Employee mobile already exists",
                ]);
            }

            $nextId = Employee::max('id') + 1; // Get the next available ID
            $eid = $dbName . '-emp' . $nextId;
            $employee->eid = $eid;
            // $employee->password = md5($this->generatePassword($request->personalInfo['username'], $request->personalInfo['mobile']));
            $randomNumber = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $employee->password = md5($randomNumber);
        }

        $employee->emp_name = $request->personalInfo['username'];
        $employee->emp_mobile = $request->personalInfo['mobile'];
        $employee->emp_email = $request->personalInfo['email'];
        $employee->dob = $request->personalInfo['dob'];
        $employee->address = $request->addressDetails['address'];
        $employee->tehsil = $request->addressDetails['tehsil'];
        $employee->district = $request->addressDetails['district'];
        $employee->state = $request->addressDetails['state'];
        $employee->villages = $request->addressDetails['villages'];
        $employee->empDesignation = $request->workDetails['designation'];
        $employee->web = $request->workDetails['web'];
        $employee->parent_empid = $request->workDetails['authority_emp'];
        $employee->addDate = $request->workDetails['doa'];
        $employee->date_of_joining = $request->workDetails['doj'];
        $employee->EDP_code = $request->workDetails['edp'];
        $employee->region = $request->workDetails['region'];
        $employee->billingRegion = $request->workDetails['billingRegion'];
        $employee->kmlimit = $request->allowencess['dailyKm'];
        $employee->lda = $request->allowencess['localDA'];
        $employee->oda = $request->allowencess['outstationDA'];
        $employee->ta = $request->allowencess['setTa2W'];
        $employee->taCar = $request->allowencess['setTa4W'];
        $employee->pan_no = isset($request->salaryDetails['pan_no'])?$request->salaryDetails['pan_no']:'';
        $employee->pt_number = isset($request->salaryDetails['pt_number'])?$request->salaryDetails['pt_number']:'';
        $employee->gross_salary = $request->salaryDetails['gross_salary'];
        $employee->basic_pay = $request->salaryDetails['basic_pay'];
        $employee->HRA = $request->salaryDetails['HRA'];
        $employee->medical = $request->salaryDetails['medical'];
        $employee->professional_tax = $request->salaryDetails['professional_tax'];
        $employee->insurance = $request->salaryDetails['insurance'];
        $employee->PT = $request->salaryDetails['PT'];
        $employee->income_tax = $request->salaryDetails['income_tax'];

        $employee->save();

        $id = 1;
        $updateKey = UpdateKeyNew::find($id);
        $updateKey->empList += 1;
        $updateKey->save();
        $updatedFarmerList = $updateKey->empList;
        if ($request->id) {
        } else {
            $mobile = $request->personalInfo['mobile'];
            $empName = $request->personalInfo['username'];
            $userName = $eid;
            $password = $randomNumber;
            $company = strtoupper($dbName);
            
            $SendSMSController = new SendSMSController();
            // Call the sendSms method with the necessary parameters
            $response = $SendSMSController->sendSMS($mobile, $empName,$userName,$password,$company);
        }

        return response()->json([
            'code' => 200,
            'message' => $request->id ? "Employee updated" : "New Employee added",
        ]);
    }
    
    public function addEmployeeV3(Request $request)
    {
        $dbName = $request->header('usedwhich');
        // dd($request->salaryDetails['pan_no']);
        if ($request->id) {
            $employee = Employee::find($request->id);
        } else {
            $employee = new Employee();

            $eidExist = Employee::where('emp_mobile', $request->personalInfo['mobile'])->exists();
            if ($eidExist) {
                return response()->json([
                    'code' => 500,
                    'message' => "Employee mobile already exists",
                ]);
            }

            $nextId = Employee::max('id') + 1; // Get the next available ID
            $eid = $dbName . '-emp' . $nextId;
            $employee->eid = $eid;
            // $employee->password = md5($this->generatePassword($request->personalInfo['username'], $request->personalInfo['mobile']));
            $randomNumber = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $employee->password = md5($randomNumber);
        }

        $employee->emp_name = $request->personalInfo['username'];
        $employee->emp_mobile = $request->personalInfo['mobile'];
        $employee->emp_email = $request->personalInfo['email'];
        $employee->dob = $request->personalInfo['dob'];
        $employee->address = $request->addressDetails['address'];
        $employee->tehsil = $request->addressDetails['tehsil'];
        $employee->district = $request->addressDetails['district'];
        $employee->state = $request->addressDetails['state'];
        $employee->villages = $request->addressDetails['villages'];
        $employee->empDesignation = $request->workDetails['designation'];
        $employee->web = $request->workDetails['web'];
        $employee->parent_empid = $request->workDetails['authority_emp'];
        $employee->addDate = $request->workDetails['doa'];
        $employee->date_of_joining = $request->workDetails['doj'];
        $employee->EDP_code = $request->workDetails['edp'];
        $employee->region = $request->workDetails['region'];
        $employee->billingRegion = $request->workDetails['billingRegion'];
        $employee->kmlimit = $request->allowencess['dailyKm'];
        $employee->lda = $request->allowencess['localDA'];
        $employee->oda = $request->allowencess['outstationDA'];
        $employee->ta = $request->allowencess['setTa2W'];
        $employee->taCar = $request->allowencess['setTa4W'];
        $employee->earning = $request->salaryDetails['earning'];
        $employee->deduction = $request->salaryDetails['deduction'];
        $employee->bankDetails = $request->salaryDetails['bankDetails'];
        
        $employee->save();

        $id = 1;
        $updateKey = UpdateKeyNew::find($id);
        $updateKey->empList += 1;
        $updateKey->save();
        $updatedFarmerList = $updateKey->empList;
        if ($request->id) {
        } else {
            $mobile = $request->personalInfo['mobile'];
            $empName = $request->personalInfo['username'];
            $userName = $eid;
            $password = $randomNumber;
            $company = strtoupper($dbName);
            
            $SendSMSController = new SendSMSController();
            // Call the sendSms method with the necessary parameters
            $response = $SendSMSController->sendSMS($mobile, $empName,$userName,$password,$company);
        }

        return response()->json([
            'code' => 200,
            'message' => $request->id ? "Employee updated" : "New Employee added",
        ]);
    }

    public function deleteEmployee(Request $request)
    {
        $employee = Employee::find($request->id);
        $employee->deleteFlag = $request->action;
        $employee->deleteDate = date('Y-m-d');
        $employee->save();

        return response()->json([
            'code' => 200,
            'message' => "Employee deleted successfully",
        ]);
    }
    
    public function updateSalaryDetailsData(Request $request)
    {
        $data = $request->json()->all();
        $employee = Employee::find($data['empID']);
        $employee->earning = $data['earning'];
        $employee->deduction = $data['deduction'];
        $employee->bankDetails = $data['bankDetails'];
        $employee->save();

        return response()->json([
            'code' => 200,
            'message' => "Employee salary details successfully",
        ]);
    }
    public function changePassword(Request $request)
    {
        $employee = Employee::find($request->id);
        $employee->password = md5($request->password);
        $employee->save();

        return response()->json([
            'code' => 200,
            'message' => "Employee password changed successfully",
        ]);
    }

    public function importEmployeeCSV(Request $request)
    {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);

        $validateCSVFile = array_diff($uploadAndGetData['header'], StaticArray::$employeeArray);

        if ($validateCSVFile) {
            return response()->json([
                'code' => 200,
                'message' => "Invalid CSV file uploaded",
            ]);
        }
        foreach ($uploadAndGetData['data'] as $value) {
            $getAllRegion = Category::where('category_name', $value['Region'])
                ->get()
                ->toArray();
            $getBillingRegion = Category::where('category_name', $value['BillingRegion'])
                ->get()
                ->toArray();
            $getdesignation = DB::table('tbl_designation')->where('designationName', $value['Designation'])
                ->get()
                ->toArray();
            $empExist = Employee::where('emp_mobile', $value['Mobile'])
                ->get()
                ->toArray();
            if (!count($empExist) > 0) {
                // Generate emp ID
                $dbName = $request->header('usedwhich');
                $getLastRecord = Employee::orderBy('id', 'desc')
                    ->get()
                    ->toArray();
                $eid = $dbName . '-emp' . $getLastRecord[0]['id'] + 1;

                $employee = new Employee();
                $employee->emp_name = $value['EmployeeName'];
                $employee->emp_mobile = $value['Mobile'];
                $employee->eid = $eid;
                $employee->emp_email = $value['EmployeeEmail'];
                $employee->dob = date('Y-m-d',strtotime($value['DOB']));
                $employee->password = md5(str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT));
                $employee->address = $value['Address'];
                $employee->tehsil = $value['Tehsil'];
                $employee->district = $value['District'];
                $employee->state = $value['State'];
                $employee->villages = $value['Village'];
                $employee->empDesignation = $getdesignation ? count($getdesignation) ? $getdesignation[0]->designationId : null :'';
                $employee->parent_empid = $value['ReportingAuthority'];
                $employee->addDate = date('Y-m-d', strtotime($value['DateOfActivation']));
                $employee->date_of_joining = date('Y-m-d', strtotime($value['DateOfJoining']));
                $employee->EDP_code = $value['EDPNo'];
                $employee->region = count($getAllRegion) ? $getAllRegion[0]['category_id'] : null;
                $employee->billingRegion = count($getBillingRegion) ? $getBillingRegion[0]['category_id'] : null;
                $employee->kmlimit = $value['DailyKM'];
                $employee->lda = $value['LocalDA'];
                $employee->oda = $value['OutstationDA'];
                $employee->ta = $value['SetTa2W'];
                $employee->taCar = $value['SetTa4W'];

                $employee->save();
            }
        }
        
        //use update key also
        
        return response()->json([
            'code' => 200,
            'message' => "CSV file uploaded successfully",
        ]);
    }

    public function getEmpTrackDetails(Request $request)
    {
        $data = $this->commonController->getTrackDetails($request->eid, $request->date, $request->id);
        $activityData = $this->commonController->getTrackDetailsGAVL($request->eid, $request->date, $request->id);
        return response()->json([
            'code' => 200,
            'data' => $data,
            'activityData' => $activityData,
        ]);
    }
    public function getEmpTrackDetailsUpdated(Request $request)
    {
        $data = $this->commonController->getTrackDetails($request->eid, $request->date, $request->id);
        $activityData = $this->commonController->getTrackDetailsGAVLNew($request->eid, $request->date, $request->id);
        return response()->json([
            'code' => 200,
            'data' => $data,
            'activityData' => $activityData,
        ]);
    }

    public function getAllEmployeePassword(Request $request)
    {
        $regionID = $request->regionIndex;
        $getAllRegionIDs = $this->apiController->getRegionId($regionID);

        $getAllCountData = DB::table('tbl_employee as te')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
            ->where('deleteFlag', 0)
            ->where('user_role', 'employee')
            ->where('empDesignation', '!=', 24);

        if ($request->keyword) {
            $getAllCountData->where(function ($query) use ($request) {
                $query
                    ->where('te.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('te.emp_mobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('te.eid', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $getAllCountData->whereIn('te.region', explode(',', $getAllRegionIDs));

        $reportArray = []; // Initialize an empty array
        $perPage = $request->per_page ?? 15; // Adjust the per_page value as needed

        if ($request->paginate == "true") {
            $getAllCountDataPaginated = $getAllCountData->paginate($perPage);

            foreach ($getAllCountDataPaginated as $employee) {
                $decryptedString = '';
                for ($i = 100; $i < 999999; $i++) {
                    if ($employee->password == md5($i)) {
                        $decryptedString = $i;
                        break;
                    }
                }

                $data['id'] = $employee->id;
                $data['work_region'] = $employee->category_name;
                $data['employee_name'] = $employee->emp_name;
                $data['employee_mobile'] = $employee->emp_mobile;
                $data['eid'] = $employee->eid;
                $data['password'] = $decryptedString;

                array_push($reportArray, $data);
            }

            // Calculate 'from' and 'to' values
            $from = $getAllCountDataPaginated->firstItem();
            $to = $getAllCountDataPaginated->lastItem();

            return response()->json([
                'code' => 200,
                'report_data' => $reportArray,
                'pagination' => [
                    'current_page' => $getAllCountDataPaginated->currentPage(),
                    'per_page' => $getAllCountDataPaginated->perPage(),
                    'total' => $getAllCountDataPaginated->total(),
                    'last_page' => $getAllCountDataPaginated->lastPage(),
                    'first_page_url' => $getAllCountDataPaginated->url(1),
                    'prev_page_url' => $getAllCountDataPaginated->previousPageUrl(),
                    'next_page_url' => $getAllCountDataPaginated->nextPageUrl(),
                    'from' => $from,
                    'to' => $to,
                ],
            ]);
        } else {
            $getAllCountData = $getAllCountData->get();

            $previousPageUrl = null; // Calculate the previous page URL
            $nextPageUrl = null; // Calculate the next page URL

            foreach ($getAllCountData as $employee) {
                $decryptedString = '';
                for ($i = 100; $i < 999999; $i++) {
                    if ($employee->password == md5($i)) {
                        $decryptedString = $i;
                        break;
                    }
                }

                $data['work_region'] = $employee->category_name;
                $data['employee_name'] = $employee->emp_name;
                $data['employee_mobile'] = $employee->emp_mobile;
                $data['eid'] = $employee->eid;
                $data['password'] = $decryptedString;

                array_push($reportArray, $data);
            }

            return response()->json([
                'code' => 200,
                'report_data' => $reportArray,
                'previous_page_url' => $previousPageUrl,
                'next_page_url' => $nextPageUrl,
            ]);
        }
    }

    public function sendPassword(Request $request)
    {
        $eid = $request->id;
        $empDetail = Employee::where('id', $eid)
            ->select('emp_name', 'eid', 'password', 'emp_mobile')
            ->first();
        $decryptedString = '';
        for ($i = 100; $i < 999999; $i++) {
            if ($empDetail->password == md5($i)) {
                $decryptedString = $i;
                break;
            }
        }
        $empName = $empDetail->emp_name;
        $password = $decryptedString;
        $userName = $empDetail->eid;
        $mobile = $empDetail->emp_mobile;
        $dbName = $request->header('usedwhich');
        $company = strtoupper($dbName);
        
        $SendSMSController = new SendSMSController();
        // Call the sendSms method with the necessary parameters
        $response = $SendSMSController->sendSMS($mobile, $empName,$userName,$password,$company);
        return response()->json([
            'code' => 200,
            'message' => "SMS Send Successfully",
        ]);
    }
    
    
}
