<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Product;
use App\Models\DownloadInfo;
use App\Http\Controllers\APIController;
use App\Jobs\DownlaodLargeDataset;
use Illuminate\Support\Facades\Cache;

class DownloadController extends Controller {
  private $apiController;

  public function __construct(APIController $apiController) {
    $this->apiController = $apiController;
  }
  public function getSDData (Request $request) {
    try {
      $regionID = $request->regionID;
      $fromDate = $request->fromDate;
      $toDate = $request->toDate;
      $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
      $getAllRegionIDs = rtrim($categoryIDWithParent,',');
      $result = DB::table('tbl_farmactivity as tfa');
      $result = $result
                    ->leftJoin('tbl_farmer as tf', 'tfa.farmerId', '=', 'tf.farmerId')
                    ->leftJoin('tbl_employee as te', 'tfa.empId', '=', 'te.id', 'LIKE', 'te.Suresh%')
                    ->leftJoin('tbl_crop as tc', 'tfa.cropId', '=', 'tc.cropId')
                    ->leftJoin('tbl_activity_product as tp', 'tfa.productId', '=', 'tp.pid')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                    ->select('te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName', 'tf.farmerName', 'tf.farmerMobile', 'tfa.SD_Area', 'tfa.SD_ProductQty', 'tfa.SD_date')
                    ->where('tfa.SD_Flag',1)
                    ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs))
                    ->whereBetween('tfa.SD_date',[$fromDate, $toDate])
                    ->get()->toArray();

      $reportArray = [];
      foreach ($result as $value) {
        $data['Employee Name'] = $value->emp_name;
        $data['Region Name'] = $value->category_name;
        $data['Product Name'] = $value->productName;
        $data['Crop Name'] = $value->cropName;
        $data['Farmer Name'] = $value->farmerName;
        $data['Farmer Mobile'] = $value->farmerMobile;
        $data['SD Date'] = $value->SD_date;
        $data['SD Area'] = $value->SD_Area;
        $data['SD Product Qty'] = $value->SD_ProductQty;

        array_push($reportArray, $data);
      }
      return response()->json([
        'code' => 200,
        'data' => $reportArray,
        'message' => "Data fetched successfully"
      ]);
    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'message' => $e->getMessage()
      ]);
    }
  }
  public function getSDVData (Request $request) {
    try {
      $regionID = $request->regionID;
      $fromDate = $request->fromDate;
      $toDate = $request->toDate;
      $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
      $getAllRegionIDs = rtrim($categoryIDWithParent,',');
      $result = DB::table('tbl_farmactivity as tfa');
      $result = $result
                    ->leftJoin('tbl_farmer as tf', 'tfa.farmerId', '=', 'tf.farmerId')
                    ->leftJoin('tbl_employee as te', 'tfa.empId', '=', 'te.id', 'LIKE', 'te.Suresh%')
                    ->leftJoin('tbl_crop as tc', 'tfa.cropId', '=', 'tc.cropId')
                    ->leftJoin('tbl_activity_product as tp', 'tfa.productId', '=', 'tp.pid')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                    ->select('te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName', 'tf.farmerName', 'tf.farmerMobile', 'tfa.SDV_farmerNumber', 'tfa.SDV_budget', 'tfa.SDV_date', 'tfa.SDV_budget_approval', 'tfa.SDV_budget_approvedBy', 'tfa.SDV_budget_approvalDate')
                    ->where('tfa.SDV_Flag',1)
                    ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs))
                    ->whereBetween('tfa.SDV_date',[$fromDate, $toDate])
                    ->get()->toArray();

      $reportArray = [];
      foreach ($result as $value) {
        $data['Employee Name'] = $value->emp_name;
        $data['Region Name'] = $value->category_name;
        $data['Product Name'] = $value->productName;
        $data['Crop Name'] = $value->cropName;
        $data['Farmer Name'] = $value->farmerName;
        $data['Farmer Mobile'] = $value->farmerMobile;
        $data['SDV Date'] = $value->SDV_date;
        $data['SD Farmer Number'] = $value->SDV_farmerNumber;
        $data['SD Budget'] = $value->SDV_budget;
        $data['SD Budget Approval'] = $value->SDV_budget_approval;
        $data['SD Budget ApprovedBy'] = $value->SDV_budget_approvedBy;
        $data['SD Budget Approval Date'] = $value->SDV_budget_approvalDate;

        array_push($reportArray, $data);
      }
      return response()->json([
        'code' => 200,
        'data' => $reportArray,
        'message' => "Data fetched successfully"
      ]);
    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'message' => $e->getMessage()
      ]);
    }
  }
  public function getFDData (Request $request) {
    try {
      $regionID = $request->regionID;
      $fromDate = $request->fromDate;
      $toDate = $request->toDate;
      $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
      $getAllRegionIDs = rtrim($categoryIDWithParent,',');
      $result = DB::table('tbl_farmactivityfd as tfd')
                    ->leftJoin('tbl_farmer as tf', 'tfd.farmerId', '=', 'tf.farmerId')
                    ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                    ->leftJoin('tbl_crop as tc', 'tfd.cropId', '=', 'tc.cropId')
                    ->leftJoin('tbl_activity_product as tp', 'tfd.productId', '=', 'tp.pid')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                    ->select('tp.productName', 'tc.cropName', 'tfd.FD_date', 'tf.farmerName', 'tf.farmerMobile', 'te.emp_name', 'tcc.category_name', 'tfd.FD_Area', 'tfd.FD_ProductQty', 'tfd.FD_farmerNum', 'tfd.FD_budget', 'tfd.Actual_Budget')
                    ->whereIn('tf..farmerRegion', explode(',', $getAllRegionIDs))
                    ->whereBetween('tfd.FD_date',[$fromDate, $toDate])
                    ->get()->toArray();

      $reportArray = [];
      foreach ($result as $value) {
        $data['Employee Name'] = $value->emp_name;
        $data['Region Name'] = $value->category_name;
        $data['Product Name'] = $value->productName;
        $data['Crop Name'] = $value->cropName;
        $data['Farmer Name'] = $value->farmerName;
        $data['Farmer Mobile'] = $value->farmerMobile;
        $data['FD Date'] = $value->FD_date;
        $data['FD Area'] = $value->FD_Area;
        $data['FD Product Qty'] = $value->FD_ProductQty;
        $data['FD Farmer Num'] = $value->FD_farmerNum;
        $data['FD Budget'] = $value->FD_budget;
        $data['FD Actual Budget'] = $value->Actual_Budget;

        array_push($reportArray, $data);
      }
      return response()->json([
        'code' => 200,
        'data' => $reportArray,
        'message' => "Data fetched successfully"
      ]);
    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'message' => $e->getMessage()
      ]);
    }
  }
  public function getFMData (Request $request) {
    try {
      $regionID = $request->regionID;
      $fromDate = $request->fromDate;
      $toDate = $request->toDate;
      $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
      $getAllRegionIDs = rtrim($categoryIDWithParent,',');
      $getProductData = DB::table('tbl_activity_product')->get()->pluck('productName', 'pid')->toArray();
      $getCropData = DB::table('tbl_crop')->get()->pluck('cropName', 'cropId')->toArray();

      $result = DB::table('tbl_farmermeeting as tfm')
                    ->leftJoin('tbl_farmer as tf', 'tfm.farmerId', '=', 'tf.farmerId')
                    ->leftJoin('tbl_employee as te', 'tfm.empId', '=', 'te.id')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tfm.farmerRegion')
                    ->leftJoin('tbl_meeting as tm', 'tm.meeting_id', '=', 'tfm.fmType')
                    ->select('tm.meeting_name', 'tf.farmerName', 'tf.farmerMobile', 'tfm.Actual_Farmerno', 'tfm.fmDate', 'tfm.villageNameID', 'tfm.fmNos', 'tfm.fmRemark', 'tfm.fmCropIds', 'tfm.fmProductIds', 'te.emp_name', 'tcc.category_name')
                    ->whereBetween('tfm.fmDate',[$fromDate, $toDate])
                    ->whereIn('tfm.farmerRegion', explode(',', $getAllRegionIDs))
                    ->get()->toArray();
      $reportArray = [];
      foreach ($result as $value) {
        $productName = '';
        foreach (explode('#', $value->fmProductIds) as $id) {
          $productName .= $getProductData[$id].',';
        }
        $cropName = '';
        foreach (explode('#', $value->fmCropIds) as $id1) {
          $cropName .= $getCropData[$id1].',';
        }
        $data['Employee Name'] = $value->emp_name;
        $data['Region Name'] = $value->category_name;
        $data['Product Name'] = rtrim($productName,',');
        $data['Crop Name'] = rtrim($cropName,',');
        $data['Farmer Name'] = $value->farmerName;
        $data['Farmer Mobile'] = $value->farmerMobile;
        $data['Meeting Name'] = $value->meeting_name;
        $data['Actual Farmerno'] = $value->Actual_Farmerno;
        $data['FM Date'] = $value->fmDate;
        $data['Village Name'] = $value->villageNameID;
        $data['FM No'] = $value->fmNos;
        $data['FM Remark'] = $value->fmRemark;

        array_push($reportArray, $data);
      }
      return response()->json([
        'code' => 200,
        'data' => $reportArray,
        'message' => "Data fetched successfully"
      ]);
    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'message' => $e->getMessage()
      ]);
    }
  }
  public function getAVData (Request $request) {
    try {
      $regionID = $request->regionID;
      $fromDate = $request->fromDate;
      $toDate = $request->toDate;
      $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
      $getAllRegionIDs = rtrim($categoryIDWithParent,',');
      $getProductData = DB::table('tbl_product')->get()->pluck('productName', 'pid')->toArray();
      $getCropData = DB::table('tbl_crop')->get()->pluck('cropName', 'cropId')->toArray();

      $result = DB::table('tbl_agencyvisit as tav')
                    ->leftJoin('tbl_employee as te', 'tav.empId', '=', 'te.id')
                    ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tav.agencyRegion')
                    ->select('te.emp_name', 'tcc.category_name', 'ta.agencyName', 'ta.agencyShopName', 'ta.agencyMobile', 'ta.agencyAltNumber', 'ta.agencyAddress', 'ta.agencyCity', 'ta.agencyType', 'ta.distributorCode', 'ta.gst', 'ta.pan', 'ta.licence1', 'ta.licence2', 'ta.licence3', 'ta.bank_name', 'ta.account_no', 'ta.branch_name', 'ta.ifsc_code', 'ta.associate_since', 'ta.handling_business_since', 'ta.dateOfBirth', 'ta.croppingPattern', 'tav.visitDate', 'tav.cropUpdate', 'tav.liquidation', 'tav.feedback', 'tav.collecttion', 'tav.postHarvest')
                    ->whereIn('tav.agencyRegion', explode(',', $getAllRegionIDs))
                    ->whereBetween('tav.visitDate',[$fromDate, $toDate])
                    ->get()->toArray();
      $reportArray = [];
      foreach ($result as $value) {
        $cropName = '';
        if ($value->croppingPattern) {
          foreach (explode('#', $value->croppingPattern) as $id1) {
            $cropName .= $getCropData[$id1].',';
          }
        }
        $visitPurpose = '';
        if($value->cropUpdate==1){
            $visitPurpose = 'Crop Update';
        }else if($value->liquidation==1){
            $visitPurpose = 'Liquidation';
        }else if($value->feedback==1){
            $visitPurpose = 'Feedback';
        }else if($value->collecttion==1){
            $visitPurpose = 'Collection';
        }else if($value->postHarvest==1){
            $visitPurpose = 'Post Harvest';
        }

        $data['Employee Name'] = $value->emp_name;
        $data['Region Name'] = $value->category_name;
        $data['Crop Name'] = rtrim($cropName,',');
        $data['Agency Name'] = $value->agencyName;
        $data['Agency Shop Name'] = $value->agencyShopName;
        $data['Agency Mobile'] = $value->agencyMobile;
        $data['Agency Alt Number'] = $value->agencyAltNumber;
        $data['Agency Address'] = $value->agencyAddress;
        $data['Agency City'] = $value->agencyCity;
        $data['Agency Type'] = $value->agencyType == 1 ? "Deaer" : "Distributor";
        $data['Distributor Code'] = $value->distributorCode;
        $data['GST'] = $value->gst;
        $data['PAN'] = $value->pan;
        $data['Licence1'] = $value->licence1;
        $data['Licence2'] = $value->licence2;
        $data['Licence3'] = $value->licence3;
        $data['Bank Name'] = $value->bank_name;
        $data['Account No'] = $value->account_no;
        $data['Branch Name'] = $value->branch_name;
        $data['IFSC Code'] = $value->ifsc_code;
        $data['Associate Since'] = $value->associate_since;
        $data['Handling Business Since'] = $value->handling_business_since;
        $data['Date Of Birth'] = $value->dateOfBirth;
        $data['Visit Date'] = $value->visitDate;
        $data['Visit Purpose'] = $visitPurpose;

        array_push($reportArray, $data);
      }
      return response()->json([
        'code' => 200,
        'data' => $reportArray,
        'message' => "Data fetched successfully"
      ]);
    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'message' => $e->getMessage()
      ]);
    }
  }
  public function getICData1  (Request $request) {
    // dd(Cache::get('icData'));
    // try {
    // ini_set('memory_limit', '1028M');
    // set_time_limit(0);
      $regionID = $request->regionID;
      $fromDate = $request->fromDate;
      $toDate = $request->toDate;
      $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
      $getAllRegionIDs = rtrim($categoryIDWithParent,',');
      $getProductData = DB::table('tbl_activity_product')->get()->pluck('productName', 'pid')->toArray();
      $getCropData = DB::table('tbl_crop')->get()->pluck('cropName', 'cropId')->toArray();

      $reportArray = [];
      $result = DB::table('tbl_farmer as tf')
                    ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                    ->select('tf.farmerId', 'tf.farmerRegDate', 'tf.farmerName', 'tf.farmerCity', 'tf.farmerWaterDependency', 'tf.farmerRabiCrop1', 'tf.farmerRabiCrop1Acer', 'tf.farmerRabiCrop2', 'tf.farmerRabiCrop2Acer', 'tf.farmerRabiCrop3', 'tf.farmerRabiCrop3Acer', 'tf.farmerKharifCrop1', 'tf.farmerKharifCrop1Acer', 'tf.farmerKharifCrop2', 'tf.farmerKharifCrop2Acer', 'tf.farmerKharifCrop3', 'tf.farmerKharifCrop3Acer',  'tf.farmerLandAcerage', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name')
                    ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs))
                    ->whereBetween('tf.farmerRegDate',[$fromDate, $toDate]);

                    $totalRecords = $result->count();

                    $perPage = 10000;
                    $totalPages = ceil($totalRecords / $perPage);
                    $insert = new DownloadInfo();
                    $insert->download_for = 'IC';
                    $insert->total_records = $totalRecords;
                    $insert->total_pages = $totalPages;
                    $insert->processed_records = 0;

                    $insert->save();
                    Cache::put('icData', []);
                    for ($page = 1; $page <= $totalPages; $page++) {
                      $offset = ($page - 1) * $perPage;
                      DownlaodLargeDataset::dispatch($offset, $perPage, $insert->id, 'IC', $page, $fromDate, $toDate, $getAllRegionIDs)->afterResponse();
                    }
                    return response()->json([
                      'code' => 200,
                      'data' => '$reportArray',
                      'message' => "Data fetched successfully"
                    ]);
                    dd($totalRecords);
                    print_r($totalRecords);
                    exit;

    for ($page = 1; $page <= $totalPages; $page++) {
        $offset = ($page - 1) * $perPage;

        $records = $result->offset($offset)->limit($perPage)->get();


    }
                    // ->orderBy('tf.farmerId', 'asc')
                    // ->chunk(1000, function ($records) use($reportArray) {
                    //      foreach ($records as $value) {
                    //        $data['Employee Name'] = $value->emp_name;
                    //        $data['Region Name'] = $value->category_name;
                    //        $data['Farmer Name'] = $value->farmerName;
                    //        $data['Farmer Mobile'] = $value->farmerMobile;
                    //        $data['Farmer Reg Date'] = $value->farmerRegDate;
                    //        $data['farmerLandAcerage'] = $value->farmerLandAcerage;
                    //        $data['Farmer Address'] = $value->farmerAddress;
                    //        $data['Farmer City'] = $value->farmerCity;
                    //        $data['Farmer Water Dependency'] = $value->farmerWaterDependency;
                    //        $data['farmerRabiCrop1'] = $value->farmerRabiCrop1;
                    //        $data['farmerRabiCrop1Acer'] = $value->farmerRabiCrop1Acer;
                    //        $data['farmerRabiCrop2'] = $value->farmerRabiCrop2;
                    //        $data['farmerRabiCrop2Acer'] = $value->farmerRabiCrop2Acer;
                    //        $data['farmerRabiCrop3'] = $value->farmerRabiCrop3;
                    //        $data['farmerRabiCrop3Acer'] = $value->farmerRabiCrop3Acer;
                    //        $data['farmerKharifCrop1'] = $value->farmerKharifCrop1;
                    //        $data['farmerKharifCrop1Acer'] = $value->farmerKharifCrop1Acer;
                    //        $data['farmerKharifCrop2'] = $value->farmerKharifCrop2;
                    //        $data['farmerKharifCrop2Acer'] = $value->farmerKharifCrop2Acer;
                    //        $data['farmerKharifCrop3'] = $value->farmerKharifCrop3;
                    //        $data['farmerKharifCrop3Acer'] = $value->farmerKharifCrop3Acer;
                    //
                    //        array_push($reportArray, $data);
                    //          // Process each record here
                    //          // Example: $record->farmerName, $record->farmerMobile, etc.
                    //      }
                    //  });
                    // ->get()->toArray();
                    // dd($result);
      // for ($i=0; $i < count($result) ; $i++) {
      //   $value = $result[$i];
      //   $data['Employee Name'] = $value->emp_name;
      //   $data['Region Name'] = $value->category_name;
      //   $data['Farmer Name'] = $value->farmerName;
      //   $data['Farmer Mobile'] = $value->farmerMobile;
      //   $data['Farmer Reg Date'] = $value->farmerRegDate;
      //   $data['farmerLandAcerage'] = $value->farmerLandAcerage;
      //   $data['Farmer Address'] = $value->farmerAddress;
      //   $data['Farmer City'] = $value->farmerCity;
      //   $data['Farmer Water Dependency'] = $value->farmerWaterDependency;
      //   $data['farmerRabiCrop1'] = $value->farmerRabiCrop1;
      //   $data['farmerRabiCrop1Acer'] = $value->farmerRabiCrop1Acer;
      //   $data['farmerRabiCrop2'] = $value->farmerRabiCrop2;
      //   $data['farmerRabiCrop2Acer'] = $value->farmerRabiCrop2Acer;
      //   $data['farmerRabiCrop3'] = $value->farmerRabiCrop3;
      //   $data['farmerRabiCrop3Acer'] = $value->farmerRabiCrop3Acer;
      //   $data['farmerKharifCrop1'] = $value->farmerKharifCrop1;
      //   $data['farmerKharifCrop1Acer'] = $value->farmerKharifCrop1Acer;
      //   $data['farmerKharifCrop2'] = $value->farmerKharifCrop2;
      //   $data['farmerKharifCrop2Acer'] = $value->farmerKharifCrop2Acer;
      //   $data['farmerKharifCrop3'] = $value->farmerKharifCrop3;
      //   $data['farmerKharifCrop3Acer'] = $value->farmerKharifCrop3Acer;
      //
      //   array_push($reportArray, $data);
      // }
      // dd($reportArray);
      // foreach ($result as $value) {
      //   $data['Employee Name'] = $value->emp_name;
      //   $data['Region Name'] = $value->category_name;
      //   $data['Farmer Name'] = $value->farmerName;
      //   $data['Farmer Mobile'] = $value->farmerMobile;
      //   $data['Farmer Reg Date'] = $value->farmerRegDate;
      //   $data['farmerLandAcerage'] = $value->farmerLandAcerage;
      //   $data['Farmer Address'] = $value->farmerAddress;
      //   $data['Farmer City'] = $value->farmerCity;
      //   $data['Farmer Water Dependency'] = $value->farmerWaterDependency;
      //   $data['farmerRabiCrop1'] = $value->farmerRabiCrop1;
      //   $data['farmerRabiCrop1Acer'] = $value->farmerRabiCrop1Acer;
      //   $data['farmerRabiCrop2'] = $value->farmerRabiCrop2;
      //   $data['farmerRabiCrop2Acer'] = $value->farmerRabiCrop2Acer;
      //   $data['farmerRabiCrop3'] = $value->farmerRabiCrop3;
      //   $data['farmerRabiCrop3Acer'] = $value->farmerRabiCrop3Acer;
      //   $data['farmerKharifCrop1'] = $value->farmerKharifCrop1;
      //   $data['farmerKharifCrop1Acer'] = $value->farmerKharifCrop1Acer;
      //   $data['farmerKharifCrop2'] = $value->farmerKharifCrop2;
      //   $data['farmerKharifCrop2Acer'] = $value->farmerKharifCrop2Acer;
      //   $data['farmerKharifCrop3'] = $value->farmerKharifCrop3;
      //   $data['farmerKharifCrop3Acer'] = $value->farmerKharifCrop3Acer;
      //
      //   array_push($reportArray, $data);
      // }
      // dd($reportArray);
      return response()->json([
        'code' => 200,
        'data' => $reportArray,
        'message' => "Data fetched successfully"
      ]);
    // } catch (\Exception $e) {
    //   return response()->json([
    //     'code' => 500,
    //     'message' => $e->getMessage()
    //   ]);
    // }
  }
  public function getICData (Request $request){
    // ini_set('memory_limit', '1028M');
    // set_time_limit(0);
    $outputFile = public_path('assets/output.csv');;
    $chunkSize = 1000; // Number of records to fetch at a time
    $offset = 0;

    $regionID = $request->regionID;
    $fromDate = $request->fromDate;
    $toDate = $request->toDate;
    $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
    $getAllRegionIDs = rtrim($categoryIDWithParent,',');

    $result = DB::table('tbl_farmer as tf')
                ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                ->select('tf.farmerId', 'tf.farmerRegDate', 'tf.farmerName', 'tf.farmerCity', 'tf.farmerWaterDependency', 'tf.farmerRabiCrop1', 'tf.farmerRabiCrop1Acer', 'tf.farmerRabiCrop2', 'tf.farmerRabiCrop2Acer', 'tf.farmerRabiCrop3', 'tf.farmerRabiCrop3Acer', 'tf.farmerKharifCrop1', 'tf.farmerKharifCrop1Acer', 'tf.farmerKharifCrop2', 'tf.farmerKharifCrop2Acer', 'tf.farmerKharifCrop3', 'tf.farmerKharifCrop3Acer',  'tf.farmerLandAcerage', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name')
                ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs))
                ->whereBetween('tf.farmerRegDate',[$fromDate, $toDate])
                ->get()->toArray();

    $reportArray = [];
    foreach ($result as $value) {
      $data['Employee Name'] = $value->emp_name;
      $data['Region Name'] = $value->category_name;
      $data['Farmer Name'] = $value->farmerName;
      $data['Farmer Mobile'] = $value->farmerMobile;
      $data['Farmer Reg Date'] = $value->farmerRegDate;
      $data['farmerLandAcerage'] = $value->farmerLandAcerage;
      $data['Farmer Address'] = $value->farmerAddress;
      $data['Farmer City'] = $value->farmerCity;
      $data['Farmer Water Dependency'] = $value->farmerWaterDependency;
      $data['farmerRabiCrop1'] = $value->farmerRabiCrop1;
      $data['farmerRabiCrop1Acer'] = $value->farmerRabiCrop1Acer;
      $data['farmerRabiCrop2'] = $value->farmerRabiCrop2;
      $data['farmerRabiCrop2Acer'] = $value->farmerRabiCrop2Acer;
      $data['farmerRabiCrop3'] = $value->farmerRabiCrop3;
      $data['farmerRabiCrop3Acer'] = $value->farmerRabiCrop3Acer;
      $data['farmerKharifCrop1'] = $value->farmerKharifCrop1;
      $data['farmerKharifCrop1Acer'] = $value->farmerKharifCrop1Acer;
      $data['farmerKharifCrop2'] = $value->farmerKharifCrop2;
      $data['farmerKharifCrop2Acer'] = $value->farmerKharifCrop2Acer;
      $data['farmerKharifCrop3'] = $value->farmerKharifCrop3;
      $data['farmerKharifCrop3Acer'] = $value->farmerKharifCrop3Acer;

      array_push($reportArray, $data);
    }
    return response()->json([
      'code' => 200,
      'data' => $reportArray
    ]);
  }
}
