<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Designation;

class DesignationController extends Controller {
 public function submitDesignation(Request $request)
{
    if ($request->id) {
        $this->updationDesignation($request);
    } else {
        $designationData = new Designation();

        $designationData->designationName = $request->designationName;
        
        $designationData->save();

        return response()->json([
            'code' => 200,
            'message' => "Data saved successfully"
        ]);
    }
}

public function updationDesignation(Request $request)
{
    $updateData = Designation::where('designationId',$request->id)
                  ->update([
                        'designationName' => $request->designationName
                      ]);
    
    return response()->json([
        'code' => 200,
        'message' => "Data updated successfully"
    ]);
}

//   public function getDesignation(Request $request) {
//     try {
//       $designationData = Designation ::select('*')->where('isDeleted', false)->get()->toArray();

//       return response()->json([
//         'code' => 200,
//         'data' => $designationData
//       ]);
//     } catch (\Exception $e) {
//     return response()->json([
//         'code' => 500,
//         'message' => "Something went wrong while saving data"
//       ]);
//     }
//   }
 public function getDesignation(Request $request)
{
    try {
        $result = DB::table('tbl_designation as tfm');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tfm.designationName', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->where('isDeleted', false)
            ->orderBy('created_at', 'desc');

        if ($request->paginate == "true") {
            $result = $result->select('tfm.*');
        } else {
            $result = $result->select('tfm.*');
        }

        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Designation fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}

  public function deleteDesignation(Request $request) {
    $agency = Designation::where('designationId', $request->id)
                      ->update(['isDeleted' => true]);

    return response()->json([
      'code' => 200,
      'message' => "Designation deleted successfully",
    ]);
  }
//   public function deleteDesignation (Request $request) {
//     try {
//       $designationData = Designation::find($request-> designationId);
//       $designationData->isDeleted = true;
//       $designationData->save();

//       return response()->json([
//         'code' => 200,
//         'message' => "Designation deleted successfully",
//         'deleteVal' => $request->deleteFlag
//       ]);
//     } catch (\Exception $e) {
//       return response()->json([
//         'code' => 500,
//         'error' => $e->getMessage(),
//         'message' => "Something went wrong while deleting designation"
//       ]);
//     }
//   }
}
