<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Deduction;
use App\Models\UpdateKeyNew;

class DeductionController extends Controller {

    public function submitDeduction(Request $request)
    {
        try {
            if ($request->id) { 
                $DeductionData = Deduction::find($request->id);
            } else {
                $DeductionData = new Deduction();
            }
            // Check if a Deduction with the same name already exists
            $existingDeduction = Deduction::where('deductionName', $request->deductionName)->where('deleteFlag', 0)->first();
            
            if ($existingDeduction) {
                return response()->json([
                    'code' => 201,
                    'message' => "Deduction with the same name already exists"
                ]);
            } else {
                $DeductionData->deductionName = $request->deductionName;
                $DeductionData->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "Data saved successfully"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data"
            ]);
        }
    }

    public function getDeduction(Request $request)
    {
        try {
            $result = DB::table('tbl_deduction as t1');
    
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('t1.deductionName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            $result = $result->where('deleteFlag',0)->orderBy('t1.id','DESC');
            
            // Get the total record count
            $totalCount = $result->count();
    
            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }
    
            return response()->json([
                'code' => 200,
                'message' => "Deduction fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteDeduction(Request $request)
    {
        try {
            $DeductionData = Deduction::where('id', $request->input('DeductionId'))
                            ->update(['deleteFlag' => 1]);
    
            if ($DeductionData) {
                return response()->json([
                    'code' => 200,
                    'message' => "Deduction deleted successfully"
                ]);
            } else {
                return response()->json([
                    'code' => 201,
                    'message' => "Deduction not found"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting Deduction: " . $e->getMessage()
            ]);
        }
    }

   
}
