<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\Agency;
use App\Models\AgencyDetail;
use App\Http\Controllers\APIController;

class DealerProfileController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
   
    public function getDealerProfileData(Request $request)
    {
        try{
        
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            
            $result =  DB::table('tbl_agencydetail as t1')
                    ->select('t2.agencyId', DB::raw("CONVERT(CAST(CONVERT(t2.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                                DB::raw("CONVERT(CAST(CONVERT(t2.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                                DB::raw("CONVERT(CAST(CONVERT(t2.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"),
                             't2.agencyMobile','t3.category_name','t1.date','t1.agencyTurnover',
                             't1.agencyHerbicidePer','t1.agencyInsecticidePer','t1.delaerFungicidePer',
                             't1.sealerPgrPer', 't1.sellerPN', 't1.agencyGAPLTurnover', 
                             't1.agencyGAPLHerbicidePer', 't1.agencyGAPLInsecticidePer', 
                             't1.delaerGAPLFungicidePer', 't1.sealerGAPLPgrPer', 't1.GAPLPN', 
                             't4.compititor_name as agencyFirstCompanyName', 't1.agencyFirstCompanyTr', 
                             't5.compititor_name as agencySecCompanyName', 't1.agencySecCompanyTr', 't1.agencyDetailId')
                    ->leftJoin('tbl_agency as t2', 't1.agencyId', '=', 't2.agencyId')
                    ->leftJoin('tbl_category as t3', 't2.agencyRegion', '=', 't3.category_id')
                    ->leftJoin('tbl_company_compitior as t4', 't1.agencyFirstCompanyName', '=', 't4.cid')
                    ->leftJoin('tbl_company_compitior as t5', 't1.agencySecCompanyName', '=', 't5.cid')
                    ->whereNotNull('t1.agencyTurnover')
                    ->where('t2.approvstatus', 1);
                    
            if ($request->regionIndex) {
                $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
                $result = $result->whereIn('t2.agencyRegion', explode(',', $getAllRegionIDs));
            }
            
            if ($request->agencyId) {
                $result = $result->where('t1.agencyId', $request->agencyId);
            }
            
            if ($request->timeFrameValue != "0") {
                $result = $result->whereBetween('t1.date', [$fromDate, $toDate]);
            }
            
            if ($request->keyword) {
                $result = $result->Where(function ($query) use ($request) {
                    $query->orWhere('t2.agencyShopName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            $result = $result->orderBy('t1.agencyDetailId', 'desc');

            // Get the total record count
            $totalCount = $result->count();

            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }

            return response()->json([
                'code' => 200,
                'message' => "Agency Profile fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                // 'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
        return response()->json(['result' => $result]);
    }
    
}
