<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderBookEntries;
use App\Models\Dispatch;
use App\Models\Product;
use App\Models\RegionwisePrice;
use App\Http\Controllers\APIController;

class DashboardController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }


    public function getOrderDashboard(Request $request)
    {
        $result = DB::table('tbl_ordernew as tp');

        $fromDate = $request->fromDate;

        $result = $result
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tp.did')
            ->leftJoin('tbl_product as to', 'to.pid', '=', 'tp.pid')
            //->where('tp.approval', 0)
            ->select('*');

        if ($request->paginate == "true") {
            $result = $result->select('tp.oid', 'tp.created_at', 'tc.agencyName', 'te.emp_name', 'to.productName', 'tp.qty', 'tp.rate', 'tp.approval');
        } else {
            $result = $result->select('tp.*', 'tc.*', 'te.*');
        }

        if ($request->empID) {
            $result = $result->where('tp.emp_id', $request->empID);
        }
        if ($request->regionIndex) {
            $result = $result->where('tp.region', $request->regionIndex);
        }

        return response()->json([
            'code' => 200,
            'message' => "Order fetched successfully",
            'data' => $result,
        ]);
    }

    public function getMapBoxJSON(Request $request)
    {
        $date = $request->givenDate;
        $result = DB::table('tbl_daystart as t1')
            ->leftJoin('tbl_employee as t2', 't1.uid', '=', 't2.id')
            ->select('t1.*', 't2.emp_name', 't2.region')
            ->where('date', '=', $date)
            ->get();
            // dd($result);
        $getRegionNameVal = $this->apiController->getRegionDataArray();
        $geojson = array(
          'type'      => 'FeatureCollection',
          "crs" => array(
                            'type' => 'name',
                            'properties'=> array(
                                   'name' => 'urn:ogc:def:crs:OGC:1.3:CRS84' )
                      ),
          'Feature'  => array()
        );
        $feature = [];
        foreach($result as $value) {
            // print_r($value);
        // echo rawurldecode($value->location_map);
            if(rawurldecode($value->sgps)!=''){
                $latLong = explode('#',rawurldecode($value->sgps)) ;
                // print_r($lat);
            }else{
               $latLong = explode(',','0,0') ;
            }
            $mainRegionName = '';
            if($value->region){
                $key = '';
                $key = array_search($value->region, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $mainRegionName = '';
                } else {
                    $mainRegionName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $long = $latLong[1];
            $lat = $latLong[0];
            $featureData = array(
              "type" => "Feature",
              "Properties" =>array(
                     "id"=>$value->id,
                     "ownername"=> rawurldecode($value->emp_name),
                     "address"=>rawurldecode($mainRegionName),
                     "propertytype"=>rawurldecode($value->uid),
                ),
              "geometry"=>array(
                     "type"=>'Point',
                     "coordinates"=>array($long,$lat)
              ),
           );
           array_push($feature, $featureData);
       }

       $object = array(
              "type" => 'FeatureCollection',
              "crs" => array(
                            'type' => 'name',
                            'properties'=> array(
                            'name' => 'urn:ogc:def:crs:OGC:1.3:CRS84' )
                      ),
              'features' => $feature
       );

        return response()->json([
           $object,
        ]);
    }



}
