<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Crop;
use App\Models\UpdateKeyNew;

class CropController extends Controller {

  public function submitCrop(Request $request)
{
    try {
        if ($request->id) { // Updated: change $request->id to $request->cropId
            $this->updationCrop($request);
            return response()->json([
                'code' => 200,
                'message' => "Data updated successfully"
            ]);
        } else {
            $cropData = new Crop();
            $cropData->cropName = $request->crop_name;
            $cropData->cropType = $request->cropType;
            $cropData->status = $request->crop_status;
            $cropData->save();
            
            $id = 1;
            $updateKey = UpdateKeyNew::find($id);
            $updateKey->cropList += 1;
            $updateKey->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Data saved successfully"
            ]);
        }
    } catch (\Exception $e) {
        return response()->json([
            'code' => 500,
            'error' => $e->getMessage(),
            'message' => "Something went wrong while saving data"
        ]);
    }
}


  public function updationCrop(Request $request)
{
    // $crop = Crop::find($request->id);

    // if (!$crop) {
    //     return response()->json([
    //         'code' => 404,
    //         'message' => "Crop not found"
    //     ], 404);
    // }

    $updateData = Crop::where('cropId',$request->id)->update([
                    'cropName' => $request->crop_name,
                    'cropType' => $request->cropType,
                    'status' => $request->crop_status,
                  ]);

    return response()->json([
        'code' => 200,
        'message' => "Data updated successfully"
    ]);
}

//   public function getCrop(Request $request) {
//     try {
//       $cropData = Crop::select('*')->where('isDeleted', false)->orderBy('created_at', 'desc')->get()->toArray();

//       return response()->json([
//         'code' => 200,
//         'data' => $cropData
//       ]);
//     } catch (\Exception $e) {
//       return response()->json([
//         'code' => 500,
//         'message' => "Something went wrong while saving data"
//       ]);
//     }
//   }
  public function getCrop(Request $request)
{
    try {
        $result = DB::table('tbl_crop as tfm');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tfm.cropName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfm.cropType', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result->leftJoin('tbl_croptype as tf', 'tfm.cropType', '=', 'tf.id')
            ->where('isDeleted', false)
            ->orderBy('created_at', 'desc');

        if ($request->paginate == "true") {
            $result = $result->select('tfm.*', 'tf.*');
        } else {
            $result = $result->select('tfm.*', 'tf.*');
        }

        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "Crop fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}

public function deleteCrop(Request $request)
{
    try {
        $cropData = Crop::where('cropId', $request->input('id'))
                        ->update(['isDeleted' => true]);

        if ($cropData) {
            return response()->json([
                'code' => 200,
                'message' => "Crop deleted successfully"
            ]);
        } else {
            return response()->json([
                'code' => 404,
                'message' => "Crop not found"
            ]);
        }
    } catch (\Exception $e) {
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting crop: " . $e->getMessage()
        ]);
    }
}


}
