<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\ComplaintType;
use App\Models\UpdateKeyNew;

class ComplaintController extends Controller {

    public function submitComplaintType(Request $request)
    {
        try {
            if ($request->id) { 
                $ComplaintData = ComplaintType::find($request->id);
            } else {
                $ComplaintData = new ComplaintType();
            }
            // Check if a complaint with the same name already exists
            $existingComplaint = ComplaintType::where('complaintName', $request->complaintName)->where('deleteFlag', 0)->first();
            
            if ($existingComplaint) {
                return response()->json([
                    'code' => 201,
                    'message' => "Complaint with the same name already exists"
                ]);
            } else {
                $ComplaintData->complaintName = $request->complaintName;
                $ComplaintData->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "Data saved successfully"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data"
            ]);
        }
    }

    public function getComplaintType(Request $request)
    {
        try {
            $result = DB::table('tbl_complaintType as t1');
    
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('t1.complaintName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            $result = $result->where('deleteFlag',0);
            
            // Get the total record count
            $totalCount = $result->count();
    
            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }
    
            return response()->json([
                'code' => 200,
                'message' => "Complaint Type fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteComplaintType(Request $request)
    {
        try {
            $ComplaintData = ComplaintType::where('id', $request->input('complaintTypeId'))
                            ->update(['deleteFlag' => 1]);
    
            if ($ComplaintData) {
                return response()->json([
                    'code' => 200,
                    'message' => "Complaint Type deleted successfully"
                ]);
            } else {
                return response()->json([
                    'code' => 201,
                    'message' => "Complaint Type not found"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting Complaint: " . $e->getMessage()
            ]);
        }
    }

    //get complaint dashboard
    public function getComplaintDashboard(Request $request)
    {
        try {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $result = DB::table('tbl_complaintType as t1');
    
            $result = $result->where('deleteFlag',0);
            
            // Get the total record count
            $totalCount = $result->count();
            $complaintArray = [];
            $result = $result->get()->toArray();
            foreach($result as $row){
                $complaintCount = DB::table('tbl_complaints')->where('complaintType',$row->id);
                
                $complaintCount = $complaintCount->whereBetween('complaintDate', [$fromDate, $toDate]);
                
                $complaintCount = $complaintCount->count();
                $data = array('label' => $row->complaintName,'complaintCount' => $complaintCount,'id' =>$row->id);
                array_push($complaintArray,$data);
            }
            return response()->json([
                'code' => 200,
                'message' => "complaint data fetched successfully",
                'data' => $complaintArray,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
    
    public function getComplaintTypeWiseDetail(Request $request)
    {
        try {
            $result = DB::table('tbl_complaints as t1')
                        ->select('t1.*','t2.farmerName','t3.productName')
                        ->where('complaintType',$request->complaintType)
                        ->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')
                        ->leftJoin('tbl_activity_product as t3','t1.productId','t3.pid');
    
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('t2.farmerName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t1.complaintDate', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t3.productName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            // Get the total record count
            $totalCount = $result->count();
    
            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }
    
            return response()->json([
                'code' => 200,
                'message' => "Complaint Data fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
}
