<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Employee;
use App\Models\Category;
use App\Models\Designation;
use App\Models\Agency;
use App\Models\FarmerType;
use App\Models\FarmerBuyingPattern;
use App\Models\Allowance;
use App\Models\Deduction;
use App\Http\Controllers\APIController;

class CommonController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }
    public function getAllState(Request $request)
    {
        $result = DB::select('SELECT DISTINCT(stateName) FROM `tbl_district` ');
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getDistrictByState(Request $request)
    {
        $result = DB::table('tbl_district')
            ->where('stateName', $request->stateName)
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    
    public function getAllEmployee($regionID)
    {
        $categoryIDWithParent = $regionID . ',' . $this->apiController->getRegionId($regionID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
        $result = DB::table('tbl_employee')
            ->select('*')
            ->whereIn('region', explode(',', $getAllRegionIDs))
            ->where('deleteFlag', 0)
            ->get()
            ->toArray();
        $regionName = Category::get()
            ->pluck('category_name', 'category_id')
            ->toArray();

        return response()->json([
            'code' => 200,
            'data' => $result,
            'regionName' => $regionName,
        ]);
    }
    public function getAllFarmerList(Request $request)
    {
        $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
        
        $result = DB::table('tbl_farmer')
            ->select('farmerId','farmerName')
            ->whereIn('farmerRegion', explode(',', $getAllRegionIDs))
            ->get()
            ->toArray();
            
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    // get farmer season list
    public function getAllFarmerSeasonList(Request $request)
    {
        
        $result = DB::table('tbl_farmerProfilingSeason')
            ->select('id','durationName')
            ->where('deleteFlag', 0)
            ->get()
            ->toArray();
            
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    
    // get farmerType list
    public function getFarmerType(Request $request)
    {
        $result = FarmerType::select('id','typeName')
            ->where('deleteFlag', 0)
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    
    public function getFarmerBuyingPattern(Request $request)
    {
        $result = FarmerBuyingPattern::select('id','patternName')
            ->where('deleteFlag', 0)
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    
    public function getEmployeelist(Request $request)
    {
        // $categoryIDWithParent = $regionID.','.$this->apiController->getRegionId($regionID);
        // $getAllRegionIDs = rtrim($categoryIDWithParent,',');
        $result = DB::table('tbl_employee')
            ->select('id', 'emp_name')
            ->where('deleteFlag', 0)
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getAllEmployeeWithPaginate(Request $request)
    {
        $fromDate = $request->fromDate;
    $toDate = $request->toDate;
    $result = DB::table('tbl_employee as te');
    $regionIndex = $request->regionIndex;

    if ($request->keyword) {
        $result = $result->orWhere(function ($query) use ($request) {
            $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
            $query->orWhere('te.emp_mobile', 'like', '%' . $request->keyword . '%');
            $query->orWhere('te.EDP_code', 'like', '%' . $request->keyword . '%');
            $query->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
            $query->orWhere('td.designationName', 'like', '%' . $request->keyword . '%');
        });
    }

    $result = $result
        ->leftJoin('tbl_designation as td', 'td.designationId', '=', 'te.empDesignation')
        ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
        ->select('te.*', 'td.designationName', 'tc.category_name')
        ->where('te.user_role', 'employee');

    if ($request->empType) {
        $value = $request->empType == 1 ? 0 : 1;
        $result = $result->where('te.deleteFlag', $value);
    }

    if ($request->timeFrameValue != "0") {
        $result = $result->whereBetween('te.created_at', [$fromDate, $toDate]);
    }

    if ($request->regionIndex) {
        $regionId = $request->regionIndex;
        $getAllRegionIDs = $this->apiController->getRegionId($regionId);
        $result = $result->whereIn('te.region', explode(',', $getAllRegionIDs));
    }

    $orderBy = $request->orderBy;
    if ($orderBy === 'asc' || $orderBy === 'desc') {
        $result = $result->orderBy('te.id', $orderBy);
    } else {
        $result = $result->orderBy('te.id', 'desc');
    }

    if ($request->paginate == 'true') {
        $result = $result->paginate();
        $result->getCollection()->transform(function ($item) {
            if (isset($item->bankDetails)) {
                $item->bankDetails = json_decode($item->bankDetails);
            }if (isset($item->earning)) {
                $item->earning = json_decode($item->earning);
            }if (isset($item->deduction)) {
                $item->deduction = json_decode($item->deduction);
            }
            return $item;
        });
    } else {
        $result = $result->get()->map(function ($item) {
            if (isset($item->bankDetails)) {
                $item->bankDetails = json_decode($item->bankDetails);
            }if (isset($item->earning)) {
                $item->earning = json_decode($item->earning);
            }if (isset($item->deduction)) {
                $item->deduction = json_decode($item->deduction);
            }
            return $item;
        })->toArray();
    }

    return response()->json([
        'code' => 200,
        'data' => $result,
    ]);
    }

    public function getAllDesignation(Request $request)
    {
        $result = DB::table('tbl_designation')
            ->select('designationId', 'designationName')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getAgencyDesignation(Request $request)
    {
        $result = DB::table('tbl_agency_designation')
            ->select('id', 'designation_name')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getCompanyCompititor(Request $request)
    {
        $result = DB::table('tbl_company_compitior')
            ->select('cid', 'compititor_name')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getBillingRegion(Request $request)
    {
        $getBillingRegionId = Agency::select('billing_region')
            ->where('agencyId', $request->id)
            ->get()
            ->toArray();
        $result = DB::table('tbl_category')
            ->select('category_name', 'category_id')
            ->where('category_id', $getBillingRegionId[0]['billing_region'])
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getAllBillingRegion(Request $request)
    {
        $getBillingRegion = DB::table('tbl_regionwise_price as trp')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'trp.regionId')
            ->select('tc.category_id', 'tc.category_name')
            ->groupBy('trp.regionId')
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'data' => $getBillingRegion,
        ]);
    }
    public function getTrackDetailsGAVL($eid, $date, $id)
    {
        $getDetails = DB::table('tbl_track')
            ->where('eid', $eid)
            ->where('date', $date)
            ->get()
            ->toArray();
        $lltbForPath = count($getDetails) > 0 && $getDetails[0]->lltb ? explode('#', $getDetails[0]->lltb) : [];
        $activityGeotagForMarkerPosition = count($getDetails) > 0 && $getDetails[0]->activityGeotag ? explode('#', $getDetails[0]->activityGeotag) : [];

        //Generate Path Array
        $generatePathArray = [];
        $i = 0;
        $startTime = '';
        $endTime = '';
        $totalCount = count($lltbForPath);
        foreach ($lltbForPath as $path) {
            $indVal = explode('/', $path);
            $object = ['lat' => floatval($indVal[0]), 'lng' => floatval($indVal[1])];
            array_push($generatePathArray, $object);
            if ($i == $totalCount - 1) {
                $endTime = $indVal[2];
            }
            if ($i == 0) {
                $startTime = $indVal[2];
            }
            $i++;
        }
        //Generate Position Array
        $positionArray = [];
        foreach ($activityGeotagForMarkerPosition as $position) {
            $indVal = explode('/', $position);
            $object = ['lat' => floatval($indVal[0]), 'lng' => floatval($indVal[1]), 'agencyType' => floatval($indVal[3])];
            array_push($positionArray, $object);
            if ($i == $totalCount - 1) {
                $endTime = $indVal[2];
            }
            if ($i == 0) {
                $startTime = $indVal[2];
            }
            $i++;
        }
            
        $empActivityDetails = DB::table('tbl_activity_count_current_year')
            ->selectRaw(
                'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
            )
            ->where('empId', $id)
            ->where('activityDate', $date)
            ->get()
            ->toArray();
        $removedElement = array_shift($positionArray);
        $result = [
            // 'path' => $generatePathArray,
            'position' => $positionArray,
            'startTime' => $startTime,
            'endTime' => $endTime,
            'emp_activity_details' => $empActivityDetails,
        ];
        return $result;
    }
    public function getTrackDetailsGAVLNew($eid, $date, $id)
    {
        $getDetails = DB::table('tbl_track')
            ->where('eid', $eid)
            ->where('date', $date)
            ->get()
            ->toArray();
        $lltbForPath = count($getDetails) > 0 && $getDetails[0]->lltb ? explode('#', $getDetails[0]->lltb) : [];
        $activityGeotagForMarkerPosition = count($getDetails) > 0 && $getDetails[0]->activityGeotag ? explode('#', $getDetails[0]->activityGeotag) : [];

        //Generate Path Array
        $generatePathArray = [];
        $i = 0;
        $startTime = '';
        $endTime = '';
        $totalCount = count($lltbForPath);
        foreach ($lltbForPath as $path) {
            $indVal = explode('/', $path);
            $object = ['lat' => floatval($indVal[0]), 'lng' => floatval($indVal[1])];
            array_push($generatePathArray, $object);
            if ($i == $totalCount - 1) {
                $endTime = $indVal[2];
            }
            if ($i == 0) {
                $startTime = $indVal[2];
            }
            $i++;
        }
        //Generate Position Array
        $positionArray = [];
        foreach ($activityGeotagForMarkerPosition as $position) {
            $indVal = explode('/', $position);
            $object = ['lat' => floatval($indVal[0]), 'lng' => floatval($indVal[1]), 'agencyType' => floatval($indVal[3])];
            array_push($positionArray, $object);
            if ($i == $totalCount - 1) {
                $endTime = $indVal[2];
            }
            if ($i == 0) {
                $startTime = $indVal[2];
            }
            $i++;
        }
        
        //get activity name
        $activity_name = [];
        foreach ($activityGeotagForMarkerPosition as $position) {
            $indVal = explode('/', $position);
            $activityName = '';
            $purpose = '';
            $villageName = '';
            if(floatval($indVal[3]) == 1){
                $ic = DB::table('tbl_farmer')->where('farmerId',floatval($indVal[4]))->select('farmerName','farmerCity')->first();
                $activityName = ($ic) ?  $ic->farmerName : '';
                $purpose = 'IC';
                $villageName = ($ic) ?  $ic->farmerCity : '';

            }else if(floatval($indVal[3]) == 2){
                $sd = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('faId',floatval($indVal[4]))->select('farmerName','farmerCity')->first();
                $activityName = ($sd) ?  $sd->farmerName : '';
                $purpose = 'SD';
                $villageName = ($sd) ?  $sd->farmerCity : '';

            }else if(floatval($indVal[3]) == 3){
                $sdv = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('faId',floatval($indVal[4]))->select('farmerName','farmerCity')->first();
                $activityName = ($sdv) ?  $sdv->farmerName : '';
                $purpose = 'SDV';
                $villageName = ($sdv) ?  $sdv->farmerCity : '';

            }else if(floatval($indVal[3]) == 4){
                $fd = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('fafdId',floatval($indVal[4]))->select('farmerName','farmerCity')->first();
                $activityName = ($fd) ?  $fd->farmerName : '';
                $purpose = 'FD';
                $villageName = ($fd) ?  $fd->farmerCity : '';

            }else if(floatval($indVal[3]) == 5){
                $fm = DB::table('tbl_farmermeeting as t1')->where('fmId',floatval($indVal[4]))->select('villageNameID')->first();
                $activityName = ($fm) ?  $fm->villageNameID : '';
                $purpose = 'FM';
                $villageName = '';

            }else if(floatval($indVal[3]) == 6){
                $av = DB::table('tbl_agencyvisit as t1')->leftJoin('tbl_agency as t2','t1.agencyId','t2.agencyId')->where('visitId',floatval($indVal[4]))->select('agencyShopName','agencyCity')->first();
                $activityName = ($av) ?  $av->agencyShopName : '';
                $purpose = 'AV';
                $villageName = ($av) ?  $av->agencyCity : '';

            }else if(floatval($indVal[3]) == 7){
                $newAg = DB::table('tbl_agency as t1')->where('agencyId',floatval($indVal[4]))->select('agencyShopName','agencyCity')->first();
                $activityName = ($newAg) ?  $newAg->agencyShopName : '';
                $purpose = 'New agency';
                $villageName = ($newAg) ?  $newAg->agencyCity : '';

            }else if(floatval($indVal[3]) == 8){
                $order = DB::table('tbl_ordernew as t1')->leftJoin('tbl_agency as t2','t1.did','t2.agencyId')->where('oid',floatval($indVal[4]))->select('agencyShopName','agencyCity')->first();
                $activityName = ($order) ?  $newAg->agencyShopName : '';
                $purpose = 'Order';
                $villageName = ($order) ?  $order->agencyCity : '';

            }else if(floatval($indVal[3]) == 9){
                $payment = DB::table('tbl_payment as t1')->leftJoin('tbl_agency as t2','t1.dealerName','t2.agencyId')->where('id',floatval($indVal[4]))->select('agencyShopName','agencyCity')->first();
                $activityName = ($payment) ?  $payment->agencyShopName : '';
                $purpose = 'Payment';
                $villageName = ($payment) ?  $payment->agencyCity : '';

            }else if(floatval($indVal[3]) == 12){
                $revisit = DB::table('tbl_revisit as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('rid',floatval($indVal[4]))->select('farmerName','farmerCity')->first();
                $activityName = ($revisit) ?  $revisit->farmerName : '';
                $purpose = 'Revisit';
                $villageName = ($revisit) ?  $revisit->farmerCity : '';

            }
            $object = [
                        'agencyType' => floatval($indVal[3]),
                        'Purpose' => $purpose,
                        'activity_name' => $activityName,
                        'villageName' => $villageName,
                        'lat' => floatval($indVal[0]),
                        'lng' => floatval($indVal[1]),
                        'activity_time' => $indVal[2]
                    ];
            
            array_push($activity_name, $object);
            
        }
            
        $empActivityDetails = DB::table('tbl_activity_count_current_year')
            ->selectRaw(
                'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
            )
            ->where('empId', $id)
            ->where('activityDate', $date)
            ->get()
            ->toArray();
        $removedElement = array_shift($positionArray);
        $removedElement = array_shift($activity_name);
        $result = [
            // 'path' => $generatePathArray,
            'position' => $activity_name,
            'startTime' => $startTime,
            'endTime' => $endTime,
            'emp_activity_details' => $empActivityDetails,
            // 'emp_activity_Name' => $activity_name,
        ];
        return $result;
    }
    public function getTrackDetails($eid, $date, $id)
    {
        $getDetails = DB::table('tbl_track')
            ->where('eid', $eid)
            ->where('date', $date)
            ->get()
            ->toArray();
        $lastLocation = count($getDetails) > 0 && $getDetails[0]->lastLatLong ? $getDetails[0]->lastLatLong : '';
        $lltbForPath = count($getDetails) > 0 && $getDetails[0]->lltb ? explode('#', $getDetails[0]->lltb) : [];
        $noOfPosistion = count($lltbForPath);
        //Generate Path Array
        $generatePathArray = [];
        $totalCount = count($lltbForPath);
        foreach ($lltbForPath as $path) {
            $indVal = explode('/', $path);
            $object = ['lat' => floatval($indVal[0]), 'lng' => floatval($indVal[1])];
            array_push($generatePathArray, $object);
        }
        //Generate Time Array
        $generateTimeArray = [];
        foreach ($lltbForPath as $path) {
            $indVal = explode('/', $path);
            array_push($generateTimeArray, $indVal[2]);
        }
        if(!empty($lastLocation)){ 
            $lastLocationVal = explode('/', $lastLocation);
            $lastLocationObject = ['lat' => floatval($lastLocationVal[0]), 'lng' => floatval($lastLocationVal[1])];
        }else{
            $lastLocationObject = [];
        }
        $getDayStart = DB::table('tbl_employee as te')
            ->leftJoin('tbl_daystart as td', 'td.uid', '=', 'te.id')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
            ->select('te.id', 'te.emp_name', 'td.date', 'td.puse', 'td.disgps', 'td.stime', 'td.etime', 'tc.*')
            ->where('te.eid', $eid)
            ->where('td.date', $date)
            ->get()
            ->toArray();
        
        $result = [
            'path' => $generatePathArray,
            'position' => $generatePathArray,
            'noOfPosistion' => $noOfPosistion,
            'generateTimeArray' => $generateTimeArray,
            'startTime' => count($getDayStart) > 0 ? $getDayStart[0]->stime : '',
            'endTime' => count($getDayStart) > 0 ? $getDayStart[0]->etime : '',
            'distanceTravelled' => count($getDayStart) > 0 ? $getDayStart[0]->disgps : '',
            'distanceTravelledByDevice' => count($getDayStart) > 0 ? $getDayStart[0]->puse : '',
            'empRegion' => count($getDayStart) > 0 ? $getDayStart[0]->category_name : '',
            'empName' => count($getDayStart) > 0 ? $getDayStart[0]->emp_name : '',
            'last_location' => $lastLocationObject,
        ];
        return $result;
    }

    public function getEmployeeDetails(Request $request)
    {
        
        // Get the total record count
        $totalCount =  DB::table('tbl_leave_application_details')
                    ->selectRaw('COUNT(*) as count')
                    ->where('emp_id', $request->id)
                    ->count();

        
        $leaveType = DB::table('tbl_leavetype')
            ->select('id','leavetype')
            ->where('isDeleted','0')
            ->get()
            ->toArray();
        $leaveArray = [];    
        foreach($leaveType as $leaveTypeVal){
            
            $countData = DB::table('tbl_leave_application_details as t1')
                ->leftJoin('tbl_leave_application as t2', 't1.leave_id', '=', 't2.leave_id')
                ->selectRaw('COUNT(*) as TotCount')
                ->where('t1.emp_id', $request->id)
                ->where('t2.leave_type_id', $leaveTypeVal->id)
                ->groupBy('t2.leave_type_id')
                ->first();
            if ($countData) {
                $totCount = $countData->TotCount; 
            } else {
                $totCount = 0; 
            }

            $leaveArray[] = [
                            'leaveTypeName' => $leaveTypeVal->leavetype,
                            'leaveTypeCount' => $totCount,
                ];
        }

        

        $leaveData = ['total' => $totalCount,'leaveData' => $leaveArray];
        
        // print_r($leaveData);   

        $empDetails = DB::table('tbl_employee')
            ->where('id', $request->id)
            ->get()
            ->toArray();
        $reportingAuthorityDetails = DB::table('tbl_employee')
            ->where('id', $empDetails[0]->parent_empid)
            ->get()
            ->toArray();
        $regionDetails = Category::where('category_id', $empDetails[0]->region)
            ->get()
            ->toArray();
        $regionName = Category::get()
            ->pluck('category_name', 'category_id')
            ->toArray();
        $desigationDetails = DB::table('tbl_designation')
            ->where('designationId', $empDetails[0]->empDesignation)
            ->get()
            ->toArray();
        $empActivityDetails = DB::table('tbl_activity_count_current_year')
            ->selectRaw(
                'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
            )
            ->where('empId', $request->id)
            ->get()
            ->toArray();
        $agencyDetails = DB::table('tbl_agencydetail as tad')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tad.agencyId')
            ->select('ta.distributorCode', 'ta.agencyName', 'ta.agencyMobile', 'ta.agencyCity', 'ta.agencyRegion')
            ->where('tad.empId', $request->id)
            ->get()
            ->toArray();

        $empLeaveDetails = $leaveData;
        // $empLeaveDetails = $result;

        //get employee track records
        $date = date('Y-m-d');
        $getTrackDetails = $this->getTrackDetails($empDetails[0]->eid, $date, $request->id);
        
        //salary details
        $earningList = Allowance::where('deleteFlag',0)->pluck('allowanceName','id');
        $deductionList = Deduction::where('deleteFlag',0)->pluck('deductionName','id');
        $earningArray = json_decode($empDetails[0]->earning,true);
        $deductionArray = json_decode($empDetails[0]->deduction,true);
        
        $earningsWithName = [];
        foreach ($earningList as $id => $name) {
            $earningsWithName[$name] = isset($earningArray[$id]) ? $earningArray[$id] : 0;
        }
        
        $deductionsWithName = [];
        foreach ($deductionList as $id => $name) {
            $deductionsWithName[$name] = isset($deductionArray[$id]) ? $deductionArray[$id] : 0;
        }
        $salaryDetails = ['earning' => $earningsWithName,'deduction' => $deductionsWithName,'bankDetails' => json_decode($empDetails[0]->bankDetails)];
        $data = [
            'emp_details' => $empDetails,
            'region_details' => $regionDetails,
            'designation_details' => $desigationDetails,
            'emp_activity_details' => $empActivityDetails,
            'agency_details' => $agencyDetails,
            'reporting_authority' => $reportingAuthorityDetails,
            'region_name' => $regionName,
            'leave_details' => $empLeaveDetails,
            'trackDetails' => $getTrackDetails,
            'salaryDetails' => $salaryDetails,
        ];
        return response()->json([
            'code' => 200,
            'data' => $data,
        ]);
    }
}
