<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\BillingProduct;
use App\Models\RegionWisePrice;

use App\Http\Controllers\ReadCSVController;
use StaticArray;

class BillingProductController extends Controller {
  private $readCSVController;

  public function __construct(APIController $apiController, ReadCSVController $readCSVController) {
    $this->readCSVController = $readCSVController;
  }
    public function submitBillingProduct(Request $request)
    {
        // dd($request->all());
        if ($request->id) {
            $this->updationBillingProduct($request);
        } else {
            $checkProductExist = DB::table('tbl_product')->where('productName', $request->productName)->select('pid')->get()->toArray();
            // dd($checkProductExist);
             
            if (!count($checkProductExist)) {
                $productData = new BillingProduct();
                $productData->skuId = $request->skuId;
                $productData->productName = $request->productName;
                $productData->productType = $request->productType;
                $productData->tradeDiscount = $request->tradeDiscount;
                $productData->status = $request->status;
                // $productData->created_at = date('Y-m-d h:i:s');
                $productData->save();
                $productID = $productData->pid;
                // print_r($productData);
            }else{
                $productID = $checkProductExist[0]->pid;
            }    
            
            // dd($productID);
            $checkProductPriceExist = DB::table('tbl_regionwise_price')->where('productId', $productID)->where('regionId',$request->region)->select('rpId')->get()->toArray();
            if (!count($checkProductPriceExist)) {  
                $regionwisePrice = new RegionWisePrice();
                $regionwisePrice->regionId = $request->region;
                $regionwisePrice->productId = $productID;
                $regionwisePrice->price = $request->price;
                $regionwisePrice->gst_no = $request->gst;
                $regionwisePrice->save();
            }else{
                $rpID = $checkProductPriceExist[0]->rpId;
                $updateData = RegionWisePrice::where('rpId', $rpID)->update([
                'regionId' => $request->region,
                'productId' => $productID, 
                'price' => $request->price,
                'gst_no' => $request->gst
                
                ]);
            }
            
            return response()->json([
                'code' => 200,
                'message' => "Data Save successfully"
            ]);
        }
    }
public function updationBillingProduct(Request $request)
{
    $productData = BillingProduct::where('pid', $request->id)->first();

    if (!$productData) {
        return response()->json([
            'code' => 404,
            'message' => "Product not found"
        ], 404);
    }
    
    
    BillingProduct::where('pid', $request->id)
            ->update([
                'productName' => $request->productName,
                'productType' => $request->productType,
                'tradeDiscount' => $request->tradeDiscount,
                'status' => $request->status
            ]);

    RegionWisePrice::where('productId', $request->id)->where('regionId', $request->region)
            ->update([
                'price' => $request->price,
                'gst_no' => $request->gst
            ]);

    return response()->json([
        'code' => 200,
        'message' => "Data updated successfully"
    ]);
}





public function getBillingProduct(Request $request)
{
    try {
        $query = DB::table('tbl_product as tpc')
            ->leftJoin('tbl_product_type as te', 'te.id', '=', 'tpc.productType')
            ->leftJoin('tbl_regionwise_price as tp', 'tp.productId', '=', 'tpc.pid')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.regionId')
            ->where('tpc.isDeleted', 0)
            ->orderBy('tpc.created_at', 'desc');

        if ($request->keyword) {
            $query->where('tpc.productName', 'like', '%' . $request->keyword . '%');
        }

        if ($request->paginate == "true") {
            $query->select('tpc.pid', 'tpc.skuId', 'tc.category_name', 'tpc.productName', 'te.prodType', 'tpc.status', 'tpc.tradeDiscount','tpc.gst', 'tp.price');
            $result = $query->simplePaginate();
        } else {
            $query->select('tpc.*', 'te.*', 'tc.category_name', 'tp.price');
            $result = $query->get()->toArray();
        }

        // Get the total record count
        $totalCount = $query->count();

        return response()->json([
            'code' => 200,
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data"
        ]);
    }
}



    public function deletebillingProduct(Request $request) {
    $agency = BillingProduct::where('pid', $request->id)
                      ->update(['isDeleted' => true]);

    return response()->json([
      'code' => 200,
      'message' => "Product deleted successfully",
    ]);
  }
  private function validateCSVHeader($csvHeader, $staticHeader) {
    $result = false;
    if (count($csvHeader) != count($staticHeader)) {
      $result = true;
    } else {
      for ($i=0; $i < count($staticHeader) ; $i++) {
        if ($staticHeader[$i] != $csvHeader[$i]) {
          $result = true;
          break;
        }
      }
    }
    return $result;
  }
  public function importproduct1(Request $request) {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$productArray);
    
        if ($validateCSVFIle) {
          return response()->json([
            'code' => 500,
            'message' => "Invalid CSV file uploaded",
          ]);
        }
    
        foreach ($uploadAndGetData['data'] as $value) {
          $getProductType = DB::table('tbl_product_type')->select('id')->where('prodType', $value['ProductType'])->get()->toArray();
          $checkProductExist = DB::table('tbl_product')->where('productName', $value['ProductName'])->select('pid')->get()->toArray();
          if (!count($checkProductExist)) {
            $product = new Product();
            $product->productName = $value['ProductName'];
            $product->productType = $getProductType[0]->id;
            $product->tradeDiscount = $value['TradeDiscount'];
            $product->gst = $value['GST'];
            $product->save();
    
            $regionwisePrice = new RegionWisePrice();
            $regionwisePrice->regionId = $request->region_id;
            $regionwisePrice->productId = $product->pid;
            $regionwisePrice->price = $value['Rate'];
            $regionwisePrice->gst_no = $value['GST'];
            $regionwisePrice->save();
          }
        }
    
        return response()->json([
          'code' => 200,
          'message' => "CSV file uploaded successfully",
        ]);
  }
  
  
  public function importproduct(Request $request) {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$productArray);
    
        if ($validateCSVFIle) {
          return response()->json([
            'code' => 500,
            'message' => "Invalid CSV file uploaded",
          ]);
        }
    
        foreach ($uploadAndGetData['data'] as $value) {
          $getProductType = DB::table('tbl_product_type')->select('id')->where('prodType', $value['ProductType'])->get()->toArray();
          $checkProductExist = DB::table('tbl_product')->where('productName', $value['ProductName'])->select('pid')->get()->toArray();
          if (!count($checkProductExist)) {
            $product = new Product();
            $product->productName = $value['ProductName'];
            $product->productType = $getProductType[0]->id;
            $product->tradeDiscount = $value['TradeDiscount'];
            $product->gst = $value['GST'];
            $product->save();
            
            $productId = $product->pid;
          }else{
            $productId = $checkProductExist->pid;  
          }
          
          $checkProductPriceExist = DB::table('tbl_regionwise_price')->where('productId', $productId)->where('regionId',$request->region_id)->select('rpId')->get()->toArray();
          if (!count($checkProductPriceExist))
          {
            $regionwisePrice = new RegionWisePrice();
            $regionwisePrice->regionId = $request->region_id;
            $regionwisePrice->productId = $product->pid;
            $regionwisePrice->price = $value['Rate'];
            $regionwisePrice->gst_no = $value['GST'];
            $regionwisePrice->save();
          }else{
            $rpID = $checkProductPriceExist[0]->rpId;
            $updateData = RegionWisePrice::where('rpId', $rpID)->update([
            'regionId' => $request->region_id,
            'productId' => $productId, 
            'price' => $value['Rate'],
            'gst_no' => $value['GST']
            
            ]);  
          }
        }
    
        return response()->json([
          'code' => 200,
          'message' => "CSV file uploaded successfully",
        ]);
  }
}
