<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\BillingProduct;
use App\Models\BeatPlanning;

use App\Http\Controllers\ReadCSVController;
use StaticArray;

class BeatPlanningController extends Controller {
    private $apiController;
    private $readCSVController;

    public function __construct(APIController $apiController, ReadCSVController $readCSVController)
    {
        $this->apiController = $apiController;
        $this->readCSVController = $readCSVController;
    }
    
    public function getBeatPlanningCustomerType(Request $request){
        $result = DB::table('tbl_customer_type')
            ->select('customer_type_id','customer_type_name')
            ->get()
            ->toArray();
            
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getBeatPlanningActivityFarmer(Request $request){
        $result = DB::table('tbl_farmer_activity')
            ->select('id','activity_name')
            ->whereIn('id',[1,2,3,4,5,6])
            ->get()
            ->toArray();
            
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }
    public function getBeatPlanningOfficeWorkPurpose(Request $request){
        $result = DB::table('tbl_office_work_pupose')
            ->select('id','purpose_name')
            ->get()
            ->toArray();
            
        return response()->json([
            'code' => 200,
            'data' => $result,
        ]);
    }

    public function submitBeatPlanning(Request $request){
        try{
            $empId = $request->empId;
            $beatPlanDate = $request->beatPlanDate;
            $customerType = $request->customerType;
            $farmerActivityType = $request->farmerActivityType;
            $clientId = $request->clientId;
            $villageName = $request->villageName;
            $purposeId = $request->purposeId;
            $otherWork = $request->otherWork;
            $newRegistration = $request->newRegistration;
            $activity_time = date('h:i:s');
            
            $beatPlanning = BeatPlanning::where('customerType', $customerType)
                ->where('farmerActivityType', $farmerActivityType)
                ->where('clientId', $clientId)
                ->where('purposeId', $purposeId)
                ->where('villageName', $villageName)
                ->where('otherWork', $otherWork)
                ->where('newRegistration', $newRegistration)
                ->where('date', $beatPlanDate)
                ->where('empId', $empId)
                ->get();
            
            $rowsAffected = $beatPlanning->count();
            
            if ($rowsAffected == 0) {
                $beatPlanning = new BeatPlanning();
                $beatPlanning->customerType = $customerType;
                $beatPlanning->farmerActivityType = $farmerActivityType;
                $beatPlanning->clientId = $clientId;
                $beatPlanning->purposeId = $purposeId;
                $beatPlanning->villageName = $villageName;
                $beatPlanning->otherWork = $otherWork;
                $beatPlanning->newRegistration = $newRegistration;
                $beatPlanning->date = $beatPlanDate;
                $beatPlanning->activity_time = $activity_time;
                $beatPlanning->empId = $empId;
                $beatPlanning->save();
                
                $beatPlanId = $beatPlanning->id;
                            
                return response()->json([
                    'code' => 200,
                    'message' => 'Data Saved Successfully'
                ]);
            }else{
                return response()->json([
                    'code' => 201,
                    'message' => 'Data already Available',
                ]);
            }
        }catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => 'something went wrong',
                'error' => $e->getMessage(),
            ]);
        }
    }

    public function getBeatPlanningReportOld(Request $request)
    {
        try {
            
            $empID = $request->empID;
            $curDate = $request->curDate;
            
            $beatPlanDetails = BeatPlanning::select(
                    'tbl_beat_planning.*',
                    'tbl_beatPlanning_customerType.CustomerType as customerTypeName',
                    'tbl_farmer_activity.activity_name',
                    'tbl_office_work_pupose.purpose_name',
                    DB::raw("CASE
                                WHEN tbl_beat_planning.customerType = '1' THEN tbl_farmer.farmerName
                                WHEN tbl_beat_planning.customerType = '2' THEN tbl_agency.agencyShopName
                                ELSE NULL
                            END AS clientName")
                )
                ->leftJoin('tbl_farmer', function ($join) {
                    $join->on('tbl_farmer.farmerId', '=', 'tbl_beat_planning.clientId')->where('tbl_beat_planning.customerType', '=', '1');
                })
                ->leftJoin('tbl_agency', function ($join) {
                    $join->on('tbl_agency.agencyId', '=', 'tbl_beat_planning.clientId')->where('tbl_beat_planning.customerType', '=', '2');
                })
                ->leftJoin('tbl_beatPlanning_customerType', 'tbl_beatPlanning_customerType.id', '=', 'tbl_beat_planning.customerType')
                ->leftJoin('tbl_farmer_activity', 'tbl_farmer_activity.id', '=', 'tbl_beat_planning.farmerActivityType')
                ->leftJoin('tbl_office_work_pupose', 'tbl_office_work_pupose.id', '=', 'tbl_beat_planning.purposeId')
                ->where('tbl_beat_planning.empId',$empID)
                ->where('tbl_beat_planning.date',$curDate)
                ->get();

            $response = [];

            if ($beatPlanDetails->count() > 0) {
                $beatPlanDetail = [];
            
                foreach ($beatPlanDetails as $row) {
                    
                    $pursoseArray = array();
                    if($row['customerType'] == '2'){
                        if($row['purposeId']){
                            $pursose = explode("#",$row['purposeId']);
                            $pursoseCount = count($pursose);
                            for($i = 0;$i < $pursoseCount;$i++){
                                if($pursose[$i]){
                                    $key = '';
                                    $key = array_search($pursose[$i], array_column($pursoseValArry, 'purpose_agencyVisit_id'));
                                    if ($key === FALSE) {
                                        $pursoseArray[] = '';
                                    } else {
                                        $pursoseArray[] = $pursoseValArry[$key]['purpose_agencyVisit_name'];
                                    }
                                }
                            }
                        }else{
                            $pursoseArray = [];
                        }
                    }else if($row['customerType'] == '3'){
                        $pursoseArray = array($row['purpose_name']);
                    }
                    
                    //check for farmer activity
                    if($row->customerType == 1){
                        if($row->farmerActivityType == 1){ // ic
                            if($row->clientId == 0){
                                $countIC = DB::table('tbl_farmer')
                                    ->where('farmerName',$row->newRegistration)
                                    ->where('empId','=',$empID)
                                    ->where('farmerName','=',$curDate)
                                    ->count();
                                if($countIC > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $ICArray = DB::table('tbl_farmer')
                                        ->where('farmerName','!=',$row->newRegistration)
                                        ->where('empId','=',$empID)
                                        ->where('farmerName','=',$curDate)
                                        ->get();
                            foreach($ICArray as $icRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Farmer Activity',
                                "farmerActivityName" => 'IC',
                                "clientName" => $icRow->farmerName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                        //SD 
                        if($row->farmerActivityType == 2){
                            if($row->clientId != 0){
                                $countSD = DB::table('tbl_farmactivity')
                                    ->where('farmerId',$row->clientId)
                                    ->where('empId','=',$empID)
                                    ->where('SD_date','=',$curDate)
                                    ->count();
                                if($countSD > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $SDArray = DB::table('tbl_farmactivity as t1')
                                        ->leftJoin('tbl_farmer as t2','t1.farmerId','=','t2.farmerId')
                                        ->where('t1.farmerId','!=',$row->clientId)
                                        ->where('t1.empId','=',$empID)
                                        ->where('SD_date','=',$curDate)
                                        ->get();
                            foreach($SDArray as $sdRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Farmer Activity',
                                "farmerActivityName" => 'SD',
                                "clientName" => $sdRow->farmerName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                        // sdv
                        if($row->farmerActivityType == 3){
                            if($row->clientId != 0){
                                $countSDV = DB::table('tbl_farmactivity')
                                    ->where('farmerId',$row->clientId)
                                    ->where('empId','=',$empID)
                                    ->where('SDV_date','=',$curDate)
                                    ->count();
                                if($countSDV > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $SDVArray = DB::table('tbl_farmactivity as t1')
                                        ->leftJoin('tbl_farmer as t2','t1.farmerId','=','t2.farmerId')
                                        ->where('t1.farmerId','!=',$row->clientId)
                                        ->where('t1.empId','=',$empID)
                                        ->where('SDV_date','=',$curDate)
                                        ->get();
                            foreach($SDVArray as $sdvRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Farmer Activity',
                                "farmerActivityName" => 'SDV',
                                "clientName" => $sdvRow->farmerName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                        //FD
                        if($row->farmerActivityType == 4){
                            if($row->clientId != 0){
                                $countFD = DB::table('tbl_farmactivityFD')
                                    ->where('farmerId',$row->clientId)
                                    ->where('empId','=',$empID)
                                    ->where('FD_date','=',$curDate)
                                    ->count();
                                if($countFD > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $SDArray = DB::table('tbl_farmactivityFD as t1')
                                        ->leftJoin('tbl_farmer as t2','t1.farmerId','=','t2.farmerId')
                                        ->where('t1.farmerId','!=',$row->clientId)
                                        ->where('t1.empId','=',$empID)
                                        ->where('FD_date','=',$curDate)
                                        ->get();
                            foreach($SDArray as $sdRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Farmer Activity',
                                "farmerActivityName" => 'FD',
                                "clientName" => $sdRow->farmerName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                        //FM
                        if($row->farmerActivityType == 5){
                            if($row->clientId != 0){
                                $countFM = DB::table('tbl_farmermeeting')
                                    ->where('villageNameID',$row->villageName)
                                    ->where('empId','=',$empID)
                                    ->where('fmDate','=',$curDate)
                                    ->count();
                                if($countFM > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $FMArray = DB::table('tbl_farmermeeting')
                                    ->where('villageNameID','!=',$row->villageName)
                                    ->where('empId','=',$empID)
                                    ->where('fmDate','=',$curDate)
                                    ->get();
                            foreach($FMArray as $fmRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Farmer Activity',
                                "farmerActivityName" => 'FM',
                                "clientName" => '',
                                "purpose_name" => '',
                                "villageName" => $row->villageName,
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                        //Revisit
                        if($row->farmerActivityType == 6){
                            if($row->clientId != 0){
                                $countRevisit = DB::table('tbl_revisit')
                                    ->where('farmerId',$row->clientId)
                                    ->where('empId','=',$empID)
                                    ->whereBetween('revisit_datetime',[$curDate.'00:00:00',$curDate.'23:59:59'])
                                    ->count();
                                if($countRevisit > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $RevisitArray = DB::table('tbl_revisit as t1')
                                        ->leftJoin('tbl_farmer as t2','t1.farmerId','=','t2.farmerId')
                                        ->where('t1.farmerId','!=',$row->clientId)
                                        ->where('t1.empId','=',$empID)
                                        ->whereBetween('revisit_datetime',[$curDate.'00:00:00',$curDate.'23:59:59'])
                                        ->get();
                            foreach($RevisitArray as $RevisitRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Farmer Activity',
                                "farmerActivityName" => 'Revisit',
                                "clientName" => $RevisitRow->farmerName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                    }
                    
                    if($row->customerType == 2){
                        if($row->farmerActivityType == 7){
                            if($row->clientId != 0){
                                $countAgency = DB::table('tbl_agency')
                                    ->where('agencyShopName',$row->newRegistration)
                                    ->where('empId','=',$empID)
                                    ->where('created_at',$curDate)
                                    ->count();
                                if($countAgency > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $AgencyArray = DB::table('tbl_agency')
                                            ->where('agencyShopName','!=',$row->newRegistration)
                                            ->where('empId','=',$empID)
                                            ->where('created_at',$curDate)
                                            ->get();
                            foreach($AgencyArray as $AgencyRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Agency Activity',
                                "farmerActivityName" => 'New Agency',
                                "clientName" => $AgencyRow->agencyShopName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                        
                        // agency visit
                        if($row->farmerActivityType == 8){
                            if($row->clientId != 0){
                                $countAgencyVisit = DB::table('tbl_agencyvisit')
                                    ->where('agencyId',$row->clientId)
                                    ->where('empId','=',$empID)
                                    ->where('visitDate',$curDate)
                                    ->count();
                                if($countAgencyVisit > 0){
                                    $status = 1;
                                }else{
                                    $status = 0;
                                }
                            }
                            $AgencyVisitArray = DB::table('tbl_agencyvisit as t1')
                                            ->leftJoin('tbl_agency as t2','t1.agencyId','=','t2.agencyId')
                                            ->where('t1.agencyId','!=',$row->clientId)
                                            ->where('t1.empId','=',$empID)
                                            ->where('visitDate',$curDate)
                                            ->get();
                            foreach($AgencyVisitArray as $AgencyVisitRow)
                            $beatPlanDetail[] = [
                                "id" => '',
                                "customerTypeName" => 'Agency Activity',
                                "farmerActivityName" => 'New Agency',
                                "clientName" => $AgencyVisitRow->agencyShopName,
                                "purpose_name" => '',
                                "villageName" => '',
                                "otherWork" => '',
                                "status" => ''
                            ];
                        }
                    }
                    
                    
                    $beatPlanDetail[] = [
                        "id" => $row->id,
                        "customerTypeName" => $row->customerTypeName,
                        "farmerActivityName" => $row->activity_name,
                        "clientName" => $row->clientName,
                        "purpose_name" => $pursoseArray,
                        "villageName" => $row->villageName,
                        "otherWork" => $row->otherWork,
                        "status" => $status
                        
                    ];
                }
            
                
                $totalCount = $beatPlanDetails->count();
        
                return response()->json([
                    'code' => 200,
                    'data' => $beatPlanDetail,
                    'total_records' => $totalCount, // Include total record count in the response
                ]);
               
            } else {
                return response()->json([
                    'code' => 500,
                    'message' => "Data Not Available"
                ]);
            }
    
            
        } catch (\Exception $e) {
            // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data"
            ]);
        }
    }
    
    public function getAllAVPurposeList()
    {
        $gwtCropData = DB::table('tbl_purpose_agencyvisit')
            ->get()
            ->toArray();
        $cropData = [];
    
        foreach ($gwtCropData as $value) {
            $cropData[] = [
                'purpose_agencyVisit_id' => $value->purpose_agencyVisit_id,
                'purpose_agencyVisit_name' => $value->purpose_agencyVisit_name
            ];
        }
    
        return $cropData;
    }
    
    public function getBeatPlanningReport(Request $request)
    {
        try {
            $empID = $request->empID;
            $curDate = $request->curDate;
            $pursoseValArry = $this->getAllAVPurposeList();
            $beatPlanDetails = BeatPlanning::select(
                    'tbl_beat_planning.customerType', 'farmerActivityType', 'clientId', 'purposeId',  DB::raw("CONVERT(CAST(CONVERT(villageName USING latin1) AS BINARY) USING utf8mb4) as villageName"), 'otherWork', 'newRegistration', 'date', 
                    'tbl_beat_planning.activity_time', 'tbl_beat_planning.empId', 'tbl_beat_planning.latlong', 'performedStatus', 'performedTime', 'from_time', 'to_time',
                    'tbl_beatPlanning_customerType.CustomerType as customerTypeName',
                    'tbl_farmer_activity.activity_name',
                    'tbl_office_work_pupose.purpose_name',
                    DB::raw("CASE
                                WHEN tbl_beat_planning.customerType = '1' THEN CONVERT(CAST(CONVERT(tbl_farmer.farmerName USING latin1) AS BINARY) USING utf8mb4)
                                WHEN tbl_beat_planning.customerType = '2' THEN CONVERT(CAST(CONVERT(tbl_agency.agencyShopName USING latin1) AS BINARY) USING utf8mb4)
                                ELSE NULL
                            END AS clientName")
                )
                ->leftJoin('tbl_farmer', function ($join) {
                    $join->on('tbl_farmer.farmerId', '=', 'tbl_beat_planning.clientId')->where('tbl_beat_planning.customerType', '=', '1');
                })
                ->leftJoin('tbl_agency', function ($join) {
                    $join->on('tbl_agency.agencyId', '=', 'tbl_beat_planning.clientId')->where('tbl_beat_planning.customerType', '=', '2');
                })
                ->leftJoin('tbl_beatPlanning_customerType', 'tbl_beatPlanning_customerType.id', '=', 'tbl_beat_planning.customerType')
                ->leftJoin('tbl_farmer_activity', 'tbl_farmer_activity.id', '=', 'tbl_beat_planning.farmerActivityType')
                ->leftJoin('tbl_office_work_pupose', 'tbl_office_work_pupose.id', '=', 'tbl_beat_planning.purposeId')
                ->where('tbl_beat_planning.empId', $empID)
                ->where('tbl_beat_planning.date', $curDate)
                ->get();


            $response = [];

            if ($beatPlanDetails->count() > 0) {
                $beatPlanDetail = [];
            
                foreach ($beatPlanDetails as $row) {
                    if($row->performedStatus == 0){
                        $activity_time = '';
                    }else{
                        $activity_time = $row->activity_time;
                    }
                    $pursoseArray = array();
                    if($row['customerType'] == '2'){
                        if($row['purposeId']){
                            $pursose = explode("#",$row['purposeId']);
                            $pursoseCount = count($pursose);
                            for($i = 0;$i < $pursoseCount;$i++){
                                if($pursose[$i]){
                                    $key = '';
                                    $key = array_search($pursose[$i], array_column($pursoseValArry, 'purpose_agencyVisit_id'));
                                    if ($key === FALSE) {
                                        $pursoseArray[] = '';
                                    } else {
                                        $pursoseArray[] = $pursoseValArry[$key]['purpose_agencyVisit_name'];
                                    }
                                }
                            }
                        }else{
                            $pursoseArray = [];
                        }
                        
                        if($row->farmerActivityType == '8'){
                            if($row->performedStatus == '1'){
                                $activity_time = $row->performedTime;
                            }
                        }
                    }else if($row['customerType'] == '3'){
                        $pursoseArray = array($row['purpose_name']);
                    }
                    
                    if($row->customerType == '3'){
                        $task = 'Office Work';
                        $purpose = [$row->otherWork];
                    }else if($row->customerType == '2'){
                        if($row->farmerActivityType == 8){
                            $task = $row->clientName;
                            $purpose = $pursoseArray;
                        }else{
                            $task = $row->clientName;
                            $purpose = [$row->activity_name];
                        }
                    }else{
                        if($row->farmerActivityType == 5){
                            $task = $row->villageName;
                            $purpose = [$row->activity_name];
                        }else{
                            $task = $row->clientName;
                            $purpose = [$row->activity_name];
                        }
                    }
                    
                    $beatPlanDetail[] = [
                        "id" => $row->id,
                        "task" => $task,
                        "purpose" => $purpose,
                        "activityType" => $row->customerTypeName,
                        "performedStatus" => $row->performedStatus,
                        "from_time" => $row->from_time,
                        "to_time" => $row->to_time,
                        "date" => $row->date,
                        "activity_time" => $activity_time
                        
                    ];
                    
                }
            
                $sortedBeatPlanDetail = collect($beatPlanDetail)->sortBy(function ($item) {
                    return strtotime($item['activity_time']);
                })->values()->all();

                if ($request->paginate == "true") {
                    $perPage = 15; // Set your desired number of items per page
                    $page = $request->page ?: 1;
        
                    $paginator = new \Illuminate\Pagination\LengthAwarePaginator(
                        array_slice($sortedBeatPlanDetail, ($page - 1) * $perPage, $perPage),
                        count($sortedBeatPlanDetail),
                        $perPage,
                        $page
                    );
        
                    $paginationDetails = [
                        'current_page' => $paginator->currentPage(),
                        'first_page_url' => $paginator->url(1),
                        'from' => $paginator->firstItem(),
                        'to' => $paginator->lastItem(),
                        'last_page' => $paginator->lastPage(),
                        'last_page_url' => $paginator->url($paginator->lastPage()),
                        'next_page_url' => $paginator->nextPageUrl(),
                        'path' => $paginator->path(),
                        'per_page' => $paginator->perPage(),
                        'prev_page_url' => $paginator->previousPageUrl(),
                        'total' => $paginator->total(),
                    ];
        
                    $beatPlanDetail = $paginator->items();
                }else {
                    $beatPlanDetail = $beatPlanDetail;
                    $paginationDetails = null;
                }
                $totalCount = $beatPlanDetails->count();
        
                return response()->json([
                    'code' => 200,
                    'data' => $beatPlanDetail,
                    'total_records' => $totalCount, // Include total record count in the response
                    'pagination_details' => $paginationDetails,
                ]);
               
            } else {
                return response()->json([
                    'code' => 500,
                    'message' => "Data Not Available"
                ]);
            }
    
            
        } catch (\Exception $e) {
            // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data"
            ]);
        }
    }

}
