<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Clients;
use Illuminate\Support\Facades\Hash;

class AuthenticationController extends Controller
{
    // public function login(Request $request)
    // {
    //     $username = $request->username;
    //     $password = $request->header('password');
    //     $user = Employee::where('eid', $username)->first();
    //     $userType = $request->userType;
    //     $companyCode = explode('-', $username)[0];
    //     if($companyCode == NULL){
    //         $companyCode = $username;
    //         $username = $username."-admin";
    //     }
    //     $dbName = "imconnect_".$companyCode;
    //     $clientStatus = DB::connection('mysql')
    //             ->table('tbl_clients')
    //             ->where('dbname', $companyCode)
    //             ->where('status', 'Active')
    //             ->get();
    //     if (!$clientStatus) {
    //         return response()->json([
    //             'code' => 500,
    //             'message' => "Services Suspended for the Company!",
    //         ]);
    //     }else{
    //         $user = Employee::where('eid', $username)
    //             ->where('password', md5($password))
    //             ->first();
    //         if (!$user) {
    //             return response()->json([
    //                 'code' => 500,
    //                 'message' => "Invalid credential",
    //             ]);
    //         }
    //         $authToken = $user->createToken($username)->plainTextToken;
    //         $userdata = $user->toArray();

    //         return response()->json([
    //             'code' => 200,
    //             'token' => $authToken,
    //             'user' => $userdata,
    //             'dbname' => $dbName,
    //         ]);
    //     }
    // }
    public function login(Request $request)
    {
        try{
            $username = $request->username;
            $password = $request->header('password');
            $user = Employee::where('eid', $username)->first();
            $userType = $request->userType;
            $companyCode = explode('-', $username)[0];
            
            if ($companyCode == NULL) {
                $companyCode = $username;
                $username = $username . "-admin";
            }
            
            $dbName = "imconnect_" . $companyCode;
            
            $clientStatus = DB::connection('mysql')
                ->table('tbl_clients')
                ->where('dbname', $companyCode)
                ->where('status', 'Active')
                ->where('exp_date', '>=',date('Y-m-d'))
                ->first(); // Use first() to retrieve a single client record
            
            if (!$clientStatus) {
                // Log an error message to help with troubleshooting
                \Log::error('Company status not found for dbname: ' . $companyCode);
                
                return response()->json([
                    'code' => 500,
                    'message' => "Services Suspended for the Company!",
                ]);
            }
            
            $cuname = $clientStatus->c_name;
            $expiryDate = $clientStatus->exp_date;
            $com_info = DB::table('tbl_companyinfo')->first();
            $company_full_name = $com_info->company_name;
            $company_logo = "http://handheldapi.imconnect.in/images/company_img/" .$com_info->c_img;
            
            if ($userType === 'company') {
                // If the user is a company, include the "cuname" in the $userdata array
                $userdata['cuname'] = $cuname;
                $userdata['com_logo'] = $company_logo;
                $userdata['company_full_name'] = $company_full_name;
                $userdata['expiry_date'] = $expiryDate;
                return response()->json([
                    'code' => 200,
                    'token' => $authToken,
                    'user' => $userdata,
                    'dbname' => $dbName,
                    'expiry_date' => $expiryDate,
                ]);
            } else {
                // If the user is an employee, include the "cuname" from the employee record
                $user = Employee::where('eid', $username)
                    ->where('password', md5($password))
                    ->first();
        
                if (!$user) {
                    return response()->json([
                        'code' => 500,
                        'message' => "Invalid credential",
                    ]);
                }
        
                $authToken = $user->createToken($username)->plainTextToken;
                $userdata = $user->toArray();
                
                // Include "cuname" in the $userdata array
                $userdata['cuname'] = $cuname;
                $userdata['com_logo'] = $company_logo;
                $userdata['company_full_name'] = $company_full_name;
                $userdata['expiry_date'] = $expiryDate;
                
                return response()->json([
                    'code' => 200,
                    'token' => $authToken,
                    'user' => $userdata,
                    'dbname' => $dbName,
                    //'expiry_date' => $expiryDate,
                ]);
            }
            
        }catch(\Exception $e ){
            return response()->json([
                'code' => 500,
                'message' => 'Check User Id',
                
            ]);
        }
    }

}