<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Allowance;
use App\Models\UpdateKeyNew;

class AllowanceController extends Controller {

    public function submitAllowance(Request $request)
    {
        try {
            if ($request->id) { 
                $AllowanceData = Allowance::find($request->id);
            } else {
                $AllowanceData = new Allowance();
            }
            // Check if a Allowance with the same name already exists
            $existingAllowance = Allowance::where('allowanceName', $request->allowanceName)->where('deleteFlag', 0)->first();
            
            if ($existingAllowance) {
                return response()->json([
                    'code' => 201,
                    'message' => "Allowance with the same name already exists"
                ]);
            } else {
                $AllowanceData->allowanceName = $request->allowanceName;
                $AllowanceData->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "Data saved successfully"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data"
            ]);
        }
    }

    public function getAllowance(Request $request)
    {
        try {
            $result = DB::table('tbl_allowance as t1');
    
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('t1.allowanceName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            $result = $result->where('deleteFlag',0)->orderBy('t1.id','DESC');
            
            // Get the total record count
            $totalCount = $result->count();
    
            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }
    
            return response()->json([
                'code' => 200,
                'message' => "Allowance Type fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteAllowance(Request $request)
    {
        try {
            $AllowanceData = Allowance::where('id', $request->input('AllowanceId'))
                            ->update(['deleteFlag' => 1]);
    
            if ($AllowanceData) {
                return response()->json([
                    'code' => 200,
                    'message' => "Allowance Type deleted successfully"
                ]);
            } else {
                return response()->json([
                    'code' => 201,
                    'message' => "Allowance Type not found"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting Allowance: " . $e->getMessage()
            ]);
        }
    }

   
}
