<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\AlertType;

class AlertController extends Controller
{
    public function submitAlertType(Request $request)
    {
        try {
            if ($request->id) { 
                $AlertData = AlertType::find($request->id);
            } else {
                $AlertData = new AlertType();
            }
            // Check if a Alert with the same name already exists
            $existingAlert = AlertType::where('alertName', $request->alertName)->where('deleteFlag', 0)->first();
            
            if ($existingAlert) {
                return response()->json([
                    'code' => 201,
                    'message' => "Alert with the same name already exists"
                ]);
            } else {
                $AlertData->alertName = $request->alertName;
                $AlertData->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "Data saved successfully"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while saving data"
            ]);
        }
    }

    public function getAlertType(Request $request)
    {
        try {
            $result = DB::table('tbl_alertType as t1');
    
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('t1.alertName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            $result = $result->where('deleteFlag',0);
            
            // Get the total record count
            $totalCount = $result->count();
    
            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }
    
            return response()->json([
                'code' => 200,
                'message' => "Alert Type fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteAlertType(Request $request)
    {
        try {
            $AlertData = AlertType::where('id', $request->input('alertTypeId'))
                            ->update(['deleteFlag' => 1]);
    
            if ($AlertData) {
                return response()->json([
                    'code' => 200,
                    'message' => "Alert Type deleted successfully"
                ]);
            } else {
                return response()->json([
                    'code' => 201,
                    'message' => "Alert Type not found"
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting Alert: " . $e->getMessage()
            ]);
        }
    }
    
    //get alert dashboard
    public function getAlertDashboard(Request $request)
    {
        try {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $result = DB::table('tbl_alertType as t1');
    
            $result = $result->where('deleteFlag',0);
            
            // Get the total record count
            $totalCount = $result->count();
            $alertArray = [];
            $result = $result->get()->toArray();
            foreach($result as $row){
                $alertCount = DB::table('tbl_alert')->where('alertType',$row->id);
                
                $alertCount = $alertCount->whereBetween('alertDate', [$fromDate, $toDate]);
                
                $alertCount = $alertCount->count();
                $data = array('label' => $row->alertName,'alertCount' => $alertCount,'id' =>$row->id);
                array_push($alertArray,$data);
            }
            return response()->json([
                'code' => 200,
                'message' => "Alert data fetched successfully",
                'data' => $alertArray,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
    
    public function getAlertTypeWiseDetail(Request $request)
    {
        try {
            $result = DB::table('tbl_alert as t1')
                        ->select('t1.*')
                        ->where('alertType',$request->alertType);
    
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('t2.alertDate', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('t3.villageName', 'like', '%' . $request->keyword . '%');
                });
            }
            
            // Get the total record count
            $totalCount = $result->count();
    
            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }
    
            return response()->json([
                'code' => 200,
                'message' => "Alert Data fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // dd($e->getMessage()); 
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
}
