<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\AgencyProfileSeason;
use App\Http\Controllers\APIController;

class AgencyProfileSeasonController extends Controller
{
    private $apiController;

    public function __construct(APIController $apiController)
    {
        $this->apiController = $apiController;
    }

    public function submitAgencySeason(Request $request)
    {
        try {
            if ($request->id) {
                $AgencyProfileSeasonData = AgencyProfileSeason::find($request->id);
                $AgencyProfileSeasonData->durationName = $request->AgencyProfileSeasonName;
                $AgencyProfileSeasonData->activeStatus = $request->activeStatus;
                $AgencyProfileSeasonData->save();
                
                $lastInsertedId = $request->id;
                
                if($request->activeStatus == 0 && $lastInsertedId) {
                    AgencyProfileSeason::where('id', '!=', $lastInsertedId)
                                    ->update([
                                            'activeStatus' => 1,
                                            'deactivated_on' => date('Y-m-d h:i:s')
                                    ]); 
                    
                    AgencyProfileSeason::where('id', '=', $lastInsertedId)
                                    ->update([
                                            'activated_on' => date('Y-m-d h:i:s')
                                    ]);
                }
                
                return response()->json([
                    'code' => 200,
                    'message' => "Data Updated successfully",
                ]);
            } else {
                $AgencyProfileSeasonData = new AgencyProfileSeason();
                
                $rowAffectedForData = AgencyProfileSeason::where('durationName', $request->AgencyProfileSeasonName)
                    ->where('deleteFlag', 0)
                    ->count();
            
                if ($rowAffectedForData == 0 || $rowAffectedForData > 1) {
                    $AgencyProfileSeasonData->durationName = $request->AgencyProfileSeasonName;
                    $AgencyProfileSeasonData->activeStatus = $request->activeStatus;
                    $AgencyProfileSeasonData->save();
                    
                    $lastInsertedId = $AgencyProfileSeasonData->id;
                    
                    if($request->activeStatus == 0 && $lastInsertedId) {
                        AgencyProfileSeason::where('id', '!=', $lastInsertedId)
                                        ->update([
                                                'activeStatus' => 1,
                                                'deactivated_on' => date('Y-m-d h:i:s')
                                        ]); 
                        
                        AgencyProfileSeason::where('id', '=', $lastInsertedId)
                                        ->update([
                                                'activated_on' => date('Y-m-d h:i:s')
                                        ]);
                    }
                    
                    return response()->json([
                        'code' => 200,
                        'message' => "Data Save successfully",
                    ]);
                }else{
                    return response()->json(['code' => 201, 'message' => 'Data already available']);
                }
            }
            
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    
    public function getAgencyProfileSeason(Request $request)
    {
        try {
            $AgencyProfileSeasonData = AgencyProfileSeason::select('id', 'durationName', 'activated_on', 'deactivated_on', 'activeStatus')
                ->where('deleteFlag', 0)
                ->orderBy('id', 'desc');

            if ($request->paginate == "true") {
                $AgencyProfileSeasonData = $AgencyProfileSeasonData->select('id', 'durationName', 'activated_on', 'deactivated_on', 'activeStatus');
            } else {
                $AgencyProfileSeasonData = $AgencyProfileSeasonData->select('id', 'durationName', 'activated_on', 'deactivated_on', 'activeStatus');
            }

            $totalCount = $AgencyProfileSeasonData->count();

            if ($request->paginate == "true") {
                $AgencyProfileSeasonData = $AgencyProfileSeasonData->simplePaginate();
            } else {
                $AgencyProfileSeasonData = $AgencyProfileSeasonData->get()->toArray();
            }

            // Get the total record count

            return response()->json([
                'code' => 200,
                'data' => $AgencyProfileSeasonData,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteAgencyProfileSeason(Request $request)
    {
        try {
            if($request->id){
                $AgencyProfileSeasonData = AgencyProfileSeason::find($request->id);
                $AgencyProfileSeasonData->deleteFlag = 1;
                $AgencyProfileSeasonData->save();
    
                return response()->json([
                    'code' => 200,
                    'message' => "data deleted successfully",
                ]);
            }else{
                return response()->json([
                    'code' => 500,
                    'error' => $e->getMessage(),
                    'message' => "Data not available",
                ]);
            }
        } catch (\Exception $e) {
            // dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting data",
            ]);
        }
    }
}
