<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Employee;
use App\Models\Agency;
use App\Models\AgencyDetail;
use App\Models\Crop;
use App\Models\Category;
use App\Models\UpdateKeyNew;
use App\Http\Controllers\APIController;
use App\Http\Controllers\ReadCSVController;
use StaticArray;
 
class AgencyController extends Controller
{
    private $apiController;
    private $readCSVController;

    public function __construct(APIController $apiController, ReadCSVController $readCSVController)
    {
        $this->apiController = $apiController;
        $this->readCSVController = $readCSVController;
    }
    
    // without wizard agency register and update
    private function updateAgencyBackup($request)
    {
        Agency::where('agencyId', $request->id)->update([
            'agencyName' => $request->distributorInfo['authoriseName'],
            'agencyShopName' => $request->distributorInfo['agencyShopName'],
            'agencyMobile' => $request->distributorInfo['mobile'],
            'agencyAltNumber' => $request->distributorInfo['altMobile'],
            'agencyEmail' => $request->distributorInfo['email'],
            'agencyAddress' => $request->addressDetails['address'],
            'agencyState' => $request->addressDetails['state'],
            'agencyDistrict' => $request->addressDetails['district'],
            'agencyThesil' => $request->addressDetails['villageName'],
            'agencyCity' => $request->addressDetails['agencyCity'],
            'agencyPincode' => $request->addressDetails['pincode'],
            'agencyRegion' => $request->distributorInfo['region'],
            'distributorCode' => $request->distributorInfo['dCode'],
            'pan' => $request->licenceDetails['pan'],
            'gst' => $request->licenceDetails['gst'],
            'licence1' => $request->licenceDetails['licence1'],
            'licence2' => $request->licenceDetails['licence2'],
            'licence3' => $request->licenceDetails['licence3'],
            'bank_name' => $request->bankDetails['bankName'],
            //   'other_bank_name' => $request->bankDetails['otherBank'],
            'account_no' => $request->bankDetails['accountNo'],
            'branch_name' => $request->bankDetails['branchName'],
            'ifsc_code' => $request->bankDetails['ifce'],
            'activity_time' => $request->distributorInfo['activity_time'],
            'designation' => $request->distributorInfo['designation'],
            'dateOfBirth' => $request->distributorInfo['dob'],
            'anniversaryDate' => $request->distributorInfo['anniversory'],
            'croppingPattern' => $request->turnoverDetails['croppingPattern'],
            'associate_since' => $request->distributorInfo['associate'],
            'handling_business_since' => $request->distributorInfo['hBusiness'],
        ]);

        AgencyDetail::where('agencyId', $request->id)->update([
            'agencyTurnover' => $request->turnoverDetails['ourCompanyTurnOver'],
            'agencyHerbicidePer' => $request->turnoverDetails['companyHerbicidePer'],
            'agencyInsecticidePer' => $request->turnoverDetails['companyinsecticidePer'],
            'delaerFungicidePer' => $request->turnoverDetails['companyfungicidePer'],
            'sealerPgrPer' => $request->turnoverDetails['companypgrPer'],
            'agencyGAPLTurnover' => $request->turnoverDetails['totalTurnover'],
            'agencyGAPLHerbicidePer' => $request->turnoverDetails['agencyHerbicidePer'],
            'agencyGAPLInsecticidePer' => $request->turnoverDetails['agencyInsecticidePer'],
            'delaerGAPLFungicidePer' => $request->turnoverDetails['agencyFungicidePer'],
            'sealerGAPLPgrPer' => $request->turnoverDetails['agencyPgrPer'],
            'agencyFirstCompanyName' => $request->turnoverDetails['agencyFirstCompanyName'],
            'agencyFirstCompanyTr' => $request->turnoverDetails['agencyFirstCompanyTr'],
            'agencySecCompanyName' => $request->turnoverDetails['agencySecCompanyName'],
            'agencySecCompanyTr' => $request->turnoverDetails['agencySecCompanyTr'],
            'agencyThCompanyName' => $request->turnoverDetails['agencyThCompanyName'],
            'agencyThCompanyTr' => $request->turnoverDetails['agencyThCompanyTr'],
            'agencyCreditLimit' => $request->distributorInfo['creditLimit'],
            'noOfRetailers' => $request->turnoverDetails['noDealer'],
        ]);
    }
    public function addAgencyBackup(Request $request)
    {
        if ($request->id) {
            $this->updateAgency($request);
        } else {
            $agency = new Agency();
            $agencyDetial = new AgencyDetail();
            //Add into table Agency
            $agency->agencyName = $request->distributorInfo['authoriseName'];
            $agency->agencyShopName = $request->distributorInfo['agencyShopName'];
            $agency->agencyMobile = $request->distributorInfo['mobile'];
            $agency->agencyAltNumber = $request->distributorInfo['altMobile'];
            $agency->agencyEmail = $request->distributorInfo['email'];
            $agency->agencyAddress = $request->addressDetails['address'];
            $agency->agencyState = $request->addressDetails['state'];
            $agency->agencyDistrict = $request->addressDetails['district'];
            $agency->agencyThesil = $request->addressDetails['villageName'];
            $agency->agencyCity = $request->addressDetails['agencyCity'];
            $agency->agencyPincode = $request->addressDetails['pincode'];
            $agency->agencyRegion = $request->distributorInfo['region'];
            $agency->distributorCode = $request->distributorInfo['dCode'];
            $agency->agencyType = $request->distributorInfo['agencyType'];
            $agency->pan = $request->licenceDetails['pan'];
            $agency->gst = $request->licenceDetails['gst'];
            $agency->licence1 = $request->licenceDetails['licence1'];
            $agency->licence2 = $request->licenceDetails['licence2'];
            $agency->licence3 = $request->licenceDetails['licence3'];
            $agency->bank_name = $request->bankDetails['bankName'];
            $agency->account_no = $request->bankDetails['accountNo'];
            $agency->branch_name = $request->bankDetails['branchName'];
            $agency->ifsc_code = $request->bankDetails['ifce'];
            $agency->designation = $request->distributorInfo['designation'];
            $agency->dateOfBirth = $request->distributorInfo['dob'];
            $agency->anniversaryDate = $request->distributorInfo['anniversory'];
            $agency->croppingPattern = $request->turnoverDetails['croppingPattern'];
            $agency->associate_since = $request->distributorInfo['associate'];
            $agency->handling_business_since = $request->distributorInfo['hBusiness'];
            $agency->save();

            //Add into Agency Details Table
            $agencyDetial->agencyId = $agency->id;
            $agencyDetial->agencyTurnover = $request->turnoverDetails['ourCompanyTurnOver'];
            $agencyDetial->agencyHerbicidePer = $request->turnoverDetails['companyHerbicidePer'];
            $agencyDetial->agencyInsecticidePer = $request->turnoverDetails['companyinsecticidePer'];
            $agencyDetial->delaerFungicidePer = $request->turnoverDetails['companyfungicidePer'];
            $agencyDetial->sealerPgrPer = $request->turnoverDetails['companypgrPer'];
            $agencyDetial->agencyGAPLTurnover = $request->turnoverDetails['totalTurnover'];
            $agencyDetial->agencyGAPLHerbicidePer = $request->turnoverDetails['agencyHerbicidePer'];
            $agencyDetial->agencyGAPLInsecticidePer = $request->turnoverDetails['agencyInsecticidePer'];
            $agencyDetial->delaerGAPLFungicidePer = $request->turnoverDetails['agencyFungicidePer'];
            $agencyDetial->sealerGAPLPgrPer = $request->turnoverDetails['agencyPgrPer'];
            $agencyDetial->agencyFirstCompanyName = $request->turnoverDetails['agencyFirstCompanyName'];
            $agencyDetial->agencyFirstCompanyTr = $request->turnoverDetails['agencyFirstCompanyTr'];
            $agencyDetial->agencySecCompanyName = $request->turnoverDetails['agencySecCompanyName'];
            $agencyDetial->agencySecCompanyTr = $request->turnoverDetails['agencySecCompanyTr'];
            $agencyDetial->agencyThCompanyName = $request->turnoverDetails['agencyThCompanyName'];
            $agencyDetial->agencyThCompanyTr = $request->turnoverDetails['agencyThCompanyTr'];
            $agencyDetial->agencyCreditLimit = $request->distributorInfo['creditLimit'];
            $agencyDetial->noOfRetailers = $request->turnoverDetails['noDealer'];
            $agencyDetial->save();

            $id = 1;
            if ($request->distributorInfo['agencyType'] == 1) {
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->dealerList += 1;
                $updateKey->save();
                $updatedList = $updateKey->dealerList;
            } elseif ($request->distributorInfo['agencyType'] == 2) {
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->distributorlist += 1;
                $updateKey->save();
                $updatedList = $updateKey->distributorlist;
            }
        }

        return response()->json([
            'code' => 200,
            'message' => $request->id ? "Agency updated" : "New Agency added",
        ]);
    }
    
    // without wizard agency register and update
    private function updateAgency($request)
    {
        // Check if croppingPattern is an array and use implode, else set as empty string or handle accordingly
        // $croppingPattern = is_array($request->croppingPattern) ? implode('#', $request->croppingPattern) : '';
    
        // Update the Agency model
        Agency::where('agencyId', $request->id)->update([
            'agencyName' => $request->authoriseName,
            'agencyShopName' => $request->agencyShopName,
            'agencyMobile' => $request->mobile,
            'agencyAltNumber' => $request->agencyAltNumber, // Ensure your DB schema allows null here
            'agencyEmail' => $request->email, // Assuming this is included in your request
            'agencyAddress' => $request->agencyAddress,
            'agencyCity' => $request->agencyCity,
            'agencyPincode' => $request->pincode,
            'agencyRegion' => $request->region,
            'distributorCode' => $request->distributorCode,
            'agencyDistributor' => $request->distributor,
            'pan' => $request->pan,
            'gst' => $request->gst,
            'licence1' => $request->licence1,
            'licence2' => $request->licence2,
            'licence3' => $request->licence3,
            'creditLimit' => is_numeric($request->creditLimit) ? $request->creditLimit : 0, // Cast to appropriate type and provide default
            'designation' => $request->designation,
            
            'handling_business_since' => $request->hBusiness // Check format or provide default
        ]);
        
        AgencyDetail::where('agencyDetailId', $request->agencyDetailId)->update([
            'agencyCreditLimit' => $request->creditLimit,
            'dso_payment' => $request->dso_payment,
            'noOfRetailers' => $request->noDealer,
            'agencyWholesaleBrand' => $request->agencyWholesaleBrand,
            'agencyWholesalePer' => $request->agencyWholesalePer,
            'updated_at' => \DB::raw('NOW()'), // Use DB::raw to mimic the manual query
        ]);
    
    
    }

    public function addAgency(Request $request)
    {
        if ($request->id) {
            $this->updateAgency($request);
        } else {
            // $cropingPattern = implode('#',$request->croppingPattern);
            // $cropingPattern = is_array($request->croppingPattern) ? implode('#', $request->croppingPattern) : '';
            $agency = new Agency();
            $agencyDetial = new AgencyDetail();
            //Add into table Agency
            $agency->agencyName = $request->authoriseName;
            $agency->agencyShopName = $request->agencyShopName;
            $agency->agencyMobile = $request->mobile;
            $agency->agencyAltNumber = $request->agencyAltNumber;
            $agency->agencyEmail = $request->email;
            $agency->agencyAddress = $request->agencyAddress;
            $agency->agencyCity = $request->agencyCity;
            $agency->agencyPincode = $request->pincode;
            $agency->agencyRegion = $request->region;
            $agency->distributorCode = $request->distributorCode;
            $agency->agencyDistributor = $request->distributor;
            $agency->agencyType = $request->agencyType;
            $agency->pan = $request->pan;
            $agency->gst = $request->gst;
            $agency->licence1 = $request->licence1;
            $agency->licence2 = $request->licence2;
            $agency->licence3 = $request->licence3;
            $agency->creditLimit = $request->creditLimit;
            $agency->designation = $request->designation;
            
            $agency->handling_business_since = $request->hBusiness;
            $agency->save();

            //Add into Agency Details Table
            $agencyDetial->agencyId = $agency->id;
            $agencyDetial->agencyCreditLimit = $request->creditLimit;
            $agencyDetial->dso_payment = $request->dso_payment;
            $agencyDetial->noOfRetailers = $request->noDealer;
            $agencyDetial->agencyWholesaleBrand = $request->agencyWholesaleBrand;
            $agencyDetial->agencyWholesalePer = $request->agencyWholesalePer;
            $agencyDetial->date = date('Y-m-d');
            $agencyDetial->save();

            $id = 1;
            if ($request->agencyType == 1) {
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->dealerList += 1;
                $updateKey->save();
                $updatedList = $updateKey->dealerList;
            } elseif ($request->agencyType == 2) {
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->distributorlist += 1;
                $updateKey->save();
                $updatedList = $updateKey->distributorlist;
            }
        }

        return response()->json([
            'code' => 200,
            'message' => $request->id ? "Agency updated" : "New Agency added",
        ]);
    }

    public function getAgencyMappingData(Request $request)
    {
        try {
            $result = DB::table('tbl_agency as ta');
            // $regionIndex = $request->regionIndex;
            // $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
            $distributorId = $request->distributorId;

            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyAddress', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyCity', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.distributorCode', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }

            $result = $result->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion');

            if ($request->paginate == "true") {
                $result = $result->select('ta.agencyId', 
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"), 
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"), 
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"), 
                                'ta.agencyMobile', 'ta.latlong', 'ta.distributorCode', 'tc.category_name', 'ta.created_at', 'ta.agencyType', 'ta.isDeleted');
            } else {
                $result = $result->select('ta.agencyId', 
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"), 
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"), 
                                DB::raw("CONVERT(CAST(CONVERT(ta.agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"), 
                                'ta.agencyMobile', 'ta.latlong', 'ta.distributorCode', 'tc.category_name', 'ta.created_at', 'ta.agencyType', 'ta.isDeleted');
            }

            $result = $result
                ->where('ta.agencyType', 1)
                ->where('ta.approvstatus', 1)
                ->where('ta.isDeleted', false)
                ->where('ta.agencyDistributor', $distributorId);

            $result = $result->orderBy('ta.agencyId', 'desc');

            // if ($request->regionIndex) {
            //     $result = $result->whereIn('ta.agencyRegion', explode(',', $getAllRegionIDs));
            // }

            // Get the total record count
            $totalCount = $result->count();

            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }

            return response()->json([
                'code' => 200,
                'message' => "Agency fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // In case of any exception, it's better to log the error for debugging purposes
            // Log::error($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function getAgencyDistributor(Request $request)
    {
        try {
            // $result = DB::table('tbl_agency as ta');
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $regionIndex = $request->regionIndex;
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);
            $agencyType = $request->agencyType;
            
            $result = DB::table('tbl_agency as ta')
                ->join(DB::raw('(SELECT * FROM tbl_agencydetail GROUP BY agencyId) as tad'), function ($join) {
                    $join->on('ta.agencyId', '=', 'tad.agencyId');
                })
                ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion')
                ->select('ta.*', 'tad.*');
            
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyAddress', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyCity', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.distributorCode', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }
            

            // $result = $result->leftJoin('tbl_agencydetail as tad', 'ta.agencyId', '=', 'tad.agencyId')->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion');

            if ($request->paginate == "true") {
                $result = $result->select('ta.agencyId',
                                    DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                                    DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"), 
                                    DB::raw("CONVERT(CAST(CONVERT(ta.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"), 
                                    DB::raw("CONVERT(CAST(CONVERT(ta.agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"), 
                                    'agencyMobile', 'agencyAltNumber', 'agencyPincode', 'agencyRegion', 'agencyType', 'agencyDistributor', 'latlong', 'distributorCode', 'ta.empid', 'activity_time', 'gst', 'creditLimit', 'pan', 'licence1', 'licence2', 'licence3',  'handling_business_since', 'designation', 'croppingPattern', 'tad.dso_payment', 'tad.noOfRetailers', 'tad.agencyWholesaleBrand','tad.agencyWholesalePer', 'tc.category_name','tad.agencyDetailId');
            } else {
                $result = $result->select('ta.agencyId',DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),DB::raw("CONVERT(CAST(CONVERT(tc.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"), 'agencyMobile', 'agencyAltNumber', 'agencyAddress',  'agencyCity', 'agencyPincode', 'agencyRegion', 'agencyType', 'agencyDistributor', 'latlong', 'distributorCode', 'ta.empid', 'activity_time', 'gst', 'creditLimit', 'pan', 'licence1', 'licence2', 'licence3',  'handling_business_since', 'designation', 'croppingPattern', 'tad.dso_payment', 'tad.noOfRetailers', 'tad.agencyWholesaleBrand','tad.agencyWholesalePer', 'tc.category_name','tad.agencyDetailId');
            }

            $result = $result
                ->where('ta.agencyType', $request->agencyType)
                ->where('ta.approvstatus', 1)
                ->where('ta.isDeleted', false);

            $result = $result->orderBy('ta.agencyId', 'desc');

            if ($request->timeFrameValue != "0") {
                $result = $result->whereBetween('ta.created_at', [$fromDate, $toDate]);
            }

            if ($request->regionIndex) {
                $result = $result->whereIn('ta.agencyRegion', explode(',', $getAllRegionIDs));
            }

            // Get the total record count
            $totalCount = $result->count();

            if ($request->paginate == "true") {
                // $result = $result->simplePaginate();
                $result1 = $result->paginate(15);
                $result = [];
                foreach($result1 as $row){
                    $getDesigData = DB::table('tbl_agency_designation')
                        ->where('id', $row->designation)
                        ->get()
                        ->toArray();
                    $getDistributorData = DB::table('tbl_agency')
                        ->select(DB::raw('CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName'))
                        ->where('agencyId', $row->agencyDistributor)
                        ->get()
                        ->toArray();
                    // print_r($getDistributorData);
                    $getEmployeeData = DB::table('tbl_employee')
                        ->where('eid', $row->empid)
                        ->get()
                        ->toArray();
                    if($row->croppingPattern){
                        $crops = explode('#',$row->croppingPattern);
                        $cropName = '';
                        foreach($crops as $cropVal){
                            $getCrop = DB::table('tbl_crop')->where('cropId', $cropVal)->first();
                            if ($getCrop) {
                                $cropName .= $getCrop->cropName . '#';
                            }
                        }
                        $cropName = substr($cropName,0,-1);
                    }else{
                        $crops = [];
                        $cropName = '';
                    }
                    $getAgencyDetail['agencyId'] = $row->agencyId;
                    $getAgencyDetail['agencyShopName'] = $row->agencyShopName;
                    $getAgencyDetail['agencyName'] = $row->agencyName;
                    $getAgencyDetail['agencyMobile'] = $row->agencyMobile;
                    $getAgencyDetail['agencyAltNumber'] = $row->agencyAltNumber;
                    $getAgencyDetail['agencyAddress'] = $row->agencyAddress;
                    $getAgencyDetail['agencyCity'] = $row->agencyCity;
                    $getAgencyDetail['agencyPincode'] = $row->agencyPincode;
                    $getAgencyDetail['category_name'] = $row->category_name;
                    $getAgencyDetail['agencyRegion'] = $row->agencyRegion;
                    $getAgencyDetail['agencyDistributor'] = count($getDistributorData) ? $getDistributorData[0]->agencyShopName : null;
                    $getAgencyDetail['agencyDistributorId'] = $row->agencyDistributor;
                    $getAgencyDetail['authorisedPerson'] = count($getEmployeeData) ? $getEmployeeData[0]->emp_name : null;
                    $getAgencyDetail['distributorCode'] = $row->distributorCode;
                    $getAgencyDetail['latlong'] = $row->latlong;
                    $getAgencyDetail['gst'] = $row->gst;
                    $getAgencyDetail['creditLimit'] = $row->creditLimit;
                    $getAgencyDetail['pan'] = $row->pan;
                    $getAgencyDetail['licence1'] = $row->licence1;
                    $getAgencyDetail['licence2'] = $row->licence2;
                    $getAgencyDetail['licence3'] = $row->licence3;
                    
                    $getAgencyDetail['handling_business_since'] = $row->handling_business_since;
                    $getAgencyDetail['designation'] = count($getDesigData) ? $getDesigData[0]->designation_name : null;
                    
                    $getAgencyDetail['croppingPattern'] = $cropName;
                    $getAgencyDetail['croppingPatternIdArray'] = $crops;
                    $getAgencyDetail['croppingPatternNameArray'] = ($cropName)?explode('#',$cropName):[];
                    $getAgencyDetail['agencyDetailId'] = $row->agencyDetailId;
                    
                    $getAgencyDetail['noOfRetailers'] = $row->noOfRetailers;
                    $getAgencyDetail['dso_payment'] = $row->dso_payment;
                    // $getAgencyDetail['agencyFarmerNetwork'] = $row->agencyFarmerNetwork;
                    $getAgencyDetail['agencyWholesalePer'] = $row->agencyWholesalePer;
                    $getAgencyDetail['agencyWholesaleBrand'] = $row->agencyWholesaleBrand;
                    
                    array_push($result, $getAgencyDetail);
                    
                }
                
                $paginate = $result1->toArray();
                unset($paginate['data']);
            
            } else {
                $paginate = [];
                $result1 = $result->get()->toArray();
                
                $result = [];
                
                foreach($result1 as $row){
                   
                    $getDesigData = DB::table('tbl_agency_designation')
                        ->where('id', $row->designation)
                        ->get()
                        ->toArray();
                    $getDistributorData = DB::table('tbl_agency')
                        ->where('agencyId', $row->agencyDistributor)
                        ->get()
                        ->toArray();
                    $getEmployeeData = DB::table('tbl_employee')
                        ->where('eid', $row->empid)
                        ->get()
                        ->toArray();
                    if($row->croppingPattern){
                        $crops = explode('#',$row->croppingPattern);
                        $cropName = '';
                        foreach($crops as $cropVal){
                            $getCrop = DB::table('tbl_crop')->where('cropId', $cropVal)->first();
                            if ($getCrop) {
                                $cropName .= $getCrop->cropName . '#';
                            }
                        }
                        $cropName = substr($cropName,0,-1);
                    }else{
                        $cropName = '';
                    }
                    $getAgencyDetail['agencyId'] = $row->agencyId;
                    $getAgencyDetail['agencyShopName'] = $row->agencyShopName;
                    $getAgencyDetail['agencyName'] = $row->agencyName;
                    $getAgencyDetail['agencyMobile'] = $row->agencyMobile;
                    $getAgencyDetail['agencyAltNumber'] = $row->agencyAltNumber;
                    $getAgencyDetail['agencyEmail'] = $row->agencyEmail;
                    $getAgencyDetail['agencyLocation'] = $row->agencyLocation;
                    $getAgencyDetail['agencyAddress'] = $row->agencyAddress;
                    $getAgencyDetail['agencyState'] = $row->agencyState;
                    $getAgencyDetail['agencyDistrict'] = $row->agencyDistrict;
                    $getAgencyDetail['agencyThesil'] = $row->agencyThesil;
                    $getAgencyDetail['agencyCity'] = $row->agencyCity;
                    $getAgencyDetail['agencyPincode'] = $row->agencyPincode;
                    $getAgencyDetail['agencyRegion'] = $row->category_name;
                    $getAgencyDetail['agencyDistributor'] = count($getDistributorData) ? $getDistributorData[0]->agencyName : null;
                    $getAgencyDetail['authorisedPerson'] = count($getEmployeeData) ? $getEmployeeData[0]->emp_name : null;
                    $getAgencyDetail['distributorCode'] = $row->distributorCode;
                    $getAgencyDetail['gst'] = $row->gst;
                    $getAgencyDetail['creditLimit'] = $row->creditLimit;
                    $getAgencyDetail['pan'] = $row->pan;
                    $getAgencyDetail['licence1'] = $row->licence1;
                    $getAgencyDetail['licence2'] = $row->licence2;
                    $getAgencyDetail['licence3'] = $row->licence3;
                    
                    $getAgencyDetail['handling_business_since'] = $row->handling_business_since;
                    $getAgencyDetail['designation'] = count($getDesigData) ? $getDesigData[0]->designation_name : null;
                    
                    $getAgencyDetail['croppingPattern'] = $cropName;
                    $getAgencyDetail['agencyDetailId'] = $row->agencyDetailId;
                    
                    $getAgencyDetail['noOfRetailers'] = $row->noOfRetailers;
                    $getAgencyDetail['dso_payment'] = $row->dso_payment;
                    $getAgencyDetail['agencyFarmerNetwork'] = $row->agencyFarmerNetwork;
                    $getAgencyDetail['agencyWholesalePer'] = $row->agencyWholesalePer;
                    $getAgencyDetail['agencyWholesaleBrand'] = $row->agencyWholesaleBrand;
                    
                    array_push($result, $getAgencyDetail);
                }
                
            }

            return response()->json([
                'code' => 200,
                'message' => "Agency fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
                'pagination' => $paginate
            ]);
        } catch (\Exception $e) {

            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function getdeactivatedAgency(Request $request)
    {
        try {
            $result = DB::table('tbl_agency as ta');
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $getAllRegionIDs = $this->apiController->getRegionId($request->regionIndex);

            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyAddress', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyCity', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.distributorCode', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }

            $result = $result
                ->leftJoin('tbl_agencydetail as tad', 'ta.agencyId', '=', 'tad.agencyId')
                ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion')
                ->leftJoin('tbl_employee as te', 'te.eid', '=', 'ta.empid');

            if ($request->paginate == "true") {
                $result = $result->select('ta.agencyId', 
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"),
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"),
                            'ta.agencyMobile','ta.distributorCode', 'tc.category_name', 'ta.agencyType', 'te.emp_name', 'ta.isDeleted');
            } else {
                $result = $result->select('ta.agencyId', 
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"),
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"),
                            DB::raw("CONVERT(CAST(CONVERT(ta.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"),
                            'ta.agencyMobile','ta.distributorCode', 'tc.category_name', 'ta.agencyType', 'te.emp_name', 'ta.isDeleted');
            }

            $result = $result->where('ta.approvstatus', 0)->where('ta.isDeleted', false);

            $result = $result->orderBy('ta.agencyId', 'desc');

            if ($request->timeFrameValue != "0") {
                $result = $result->whereBetween('ta.created_at', [$fromDate, $toDate]);
            }

            if ($request->regionIndex) {
                $result = $result->whereIn('ta.agencyRegion', explode(',', $getAllRegionIDs));
            }

            // Get the total record count
            $totalCount = $result->count();

            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }

            return response()->json([
                'code' => 200,
                'message' => "Agency fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // In case of any exception, it's better to log the error for debugging purposes
            // Log::error($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteAgency(Request $request)
    {
        $agency = Agency::where('agencyId', $request->id)->update(['isDeleted' => true]);

        return response()->json([
            'code' => 200,
            'message' => "Agency deleted successfully",
        ]);
    }
    public function RejectAgency(Request $request)
    {
        $agency = Agency::where('agencyId', $request->id)->update(['approvstatus' => 2]);

        return response()->json([
            'code' => 200,
            'message' => "Agency deleted successfully",
        ]);
    }

    public function approveAgency(Request $request)
    {
        // dd($request->all());
        $agency = Agency::where('agencyId', $request->id)->update(['approvstatus' => 1]);
        $id = 1;
        if ($request->agencyType == 1) {
            $updateKey = UpdateKeyNew::find($id);
            $updateKey->dealerList += 1;
            $updateKey->save();
            $updatedList = $updateKey->dealerList;
        } elseif ($request->agencyType == 2) {
            $updateKey = UpdateKeyNew::find($id);
            $updateKey->distributorlist += 1;
            $updateKey->save();
            $updatedList = $updateKey->distributorlist;
        }
        return response()->json([
            'code' => 200,
            'message' => "Agency Approve successfully",
        ]);
    }
    public function getAgencyByID($id)
    {
        $result = DB::table('tbl_agency as ta')
            ->leftJoin('tbl_agencydetail as tad', 'ta.agencyId', '=', 'tad.agencyId')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion')
            ->select('ta.*', 'tad.*')
            ->where('ta.agencyId', $id)
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'message' => "Agency details fetched successfully",
            'data' => $result,
        ]);
    }
    
    public function getAgencyByIDNew($id)
    {
        $resultData = array();
        $result = DB::table('tbl_agency as ta')
            ->leftJoin('tbl_agencydetail as tad', 'ta.agencyId', '=', 'tad.agencyId')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'ta.agencyRegion')
            ->select('ta.*', 'tad.*','tc.category_name')
            ->where('tad.agencyDetailId', $id)
            ->get();
        $getAgencyDetails = [];
        foreach($result as $row){
            // echo $c1 = $row->agencyFirstCompanyName;
            $getCompData1 = DB::table('tbl_company_compitior')
                ->where('cid', $row->agencyFirstCompanyName)
                ->get()
                ->toArray();
                // dd($getCompData1);
            $getCompData2 = DB::table('tbl_company_compitior')
                ->where('cid', $row->agencySecCompanyName)
                ->get()
                ->toArray();
            $getCompData3 = DB::table('tbl_company_compitior')
                ->where('cid', $row->agencyThCompanyName)
                ->get()
                ->toArray();
            $getDesigData = DB::table('tbl_agency_designation')
                ->where('id', $row->agencyThCompanyName)
                ->get()
                ->toArray();
            $getDistributorData = DB::table('tbl_agency')
                ->where('agencyId', $row->agencyDistributor)
                ->get()
                ->toArray();
            $getEmployeeData = DB::table('tbl_employee')
                ->where('eid', $row->empid)
                ->get()
                ->toArray();
            if($row->croppingPattern){
                $crops = explode('#',$row->croppingPattern);
                $cropName = '';
                foreach($crops as $cropVal){
                    $getCrop = DB::table('tbl_crop')->where('cropId', $cropVal)->first();
                    $cropName .= $getCrop->cropName.'#';
                }
                $cropName = substr($cropName,0,-1);
            }else{
                $cropName = '';
            }
            $getAgencyDetail['agencyId'] = $row->agencyId;
            $getAgencyDetail['agencyShopName'] = $row->agencyShopName;
            $getAgencyDetail['agencyName'] = $row->agencyName;
            $getAgencyDetail['agencyMobile'] = $row->agencyMobile;
            $getAgencyDetail['agencyAltNumber'] = $row->agencyAltNumber;
            $getAgencyDetail['agencyEmail'] = $row->agencyEmail;
            $getAgencyDetail['agencyLocation'] = $row->agencyLocation;
            $getAgencyDetail['agencyAddress'] = $row->agencyAddress;
            $getAgencyDetail['agencyState'] = $row->agencyState;
            $getAgencyDetail['agencyDistrict'] = $row->agencyDistrict;
            $getAgencyDetail['agencyThesil'] = $row->agencyThesil;
            $getAgencyDetail['agencyCity'] = $row->agencyCity;
            $getAgencyDetail['agencyPincode'] = $row->agencyPincode;
            $getAgencyDetail['agencyRegion'] = $row->category_name;
            $getAgencyDetail['agencyDistributor'] = count($getDistributorData) ? $getDistributorData[0]->agencyName : null;
            $getAgencyDetail['authorisedPerson'] = count($getEmployeeData) ? $getEmployeeData[0]->emp_name : null;
            $getAgencyDetail['distributorCode'] = $row->distributorCode;
            $getAgencyDetail['gst'] = $row->gst;
            $getAgencyDetail['creditLimit'] = $row->creditLimit;
            $getAgencyDetail['pan'] = $row->pan;
            $getAgencyDetail['licence1'] = $row->licence1;
            $getAgencyDetail['licence2'] = $row->licence2;
            $getAgencyDetail['licence3'] = $row->licence3;
            // $getAgencyDetail['bank_name'] = $row->bank_name;
            // $getAgencyDetail['other_bank_name'] = $row->other_bank_name;
            // $getAgencyDetail['account_no'] = $row->account_no;
            // $getAgencyDetail['branch_name'] = $row->branch_name;
            // $getAgencyDetail['ifsc_code'] = $row->ifsc_code;
            // $getAgencyDetail['associate_since'] = $row->associate_since;
            $getAgencyDetail['handling_business_since'] = $row->handling_business_since;
            $getAgencyDetail['designation'] = count($getDesigData) ? $getDesigData[0]->designation_name : null;
            // $getAgencyDetail['dateOfBirth'] = $row->dateOfBirth;
            // $getAgencyDetail['anniversaryDate'] = $row->anniversaryDate;
            $getAgencyDetail['croppingPattern'] = $cropName;
            $getAgencyDetail['agencyDetailId'] = $row->agencyDetailId;
            // $getAgencyDetail['agencyTurnover'] = $row->agencyTurnover;
            // $getAgencyDetail['agencyHerbicidePer'] = $row->agencyHerbicidePer;
            // $getAgencyDetail['agencyInsecticidePer'] = $row->agencyInsecticidePer;
            // $getAgencyDetail['delaerFungicidePer'] = $row->delaerFungicidePer;
            // $getAgencyDetail['sealerPgrPer'] = $row->sealerPgrPer;
            // $getAgencyDetail['sellerPN'] = $row->sellerPN;
            // $getAgencyDetail['agencyGAPLTurnover'] = $row->agencyGAPLTurnover;
            // $getAgencyDetail['agencyGAPLHerbicidePer'] = $row->agencyGAPLHerbicidePer;
            // $getAgencyDetail['agencyGAPLInsecticidePer'] = $row->agencyGAPLInsecticidePer;
            // $getAgencyDetail['delaerGAPLFungicidePer'] = $row->delaerGAPLFungicidePer;
            // $getAgencyDetail['sealerGAPLPgrPer'] = $row->sealerGAPLPgrPer;
            // $getAgencyDetail['GAPLPN'] = $row->GAPLPN;
            // $getAgencyDetail['agencyFirstCompanyName'] = count($getCompData1) ? $getCompData1[0]->compititor_name : null;
            // $getAgencyDetail['agencyFirstCompanyTr'] = $row->agencyFirstCompanyTr;
            // $getAgencyDetail['agencySecCompanyName'] = count($getCompData2) ? $getCompData2[0]->compititor_name : null;
            // $getAgencyDetail['agencySecCompanyTr'] = $row->agencySecCompanyTr;
            // $getAgencyDetail['agencyThCompanyName'] = count($getCompData3) ? $getCompData3[0]->compititor_name : null;
            // $getAgencyDetail['agencyThCompanyTr'] = $row->agencyThCompanyTr;
            $getAgencyDetail['noOfRetailers'] = $row->noOfRetailers;
            $getAgencyDetail['dso_payment'] = $row->dso_payment;
            $getAgencyDetail['agencyFarmerNetwork'] = $row->agencyFarmerNetwork;
            $getAgencyDetail['agencyWholesalePer'] = $row->agencyWholesalePer;
            $getAgencyDetail['agencyWholesaleBrand'] = $row->agencyWholesaleBrand;
            
            array_push($getAgencyDetails, $getAgencyDetail);
        }
        return response()->json([
            'code' => 200,
            'message' => "Agency details fetched successfully",
            'data' => $getAgencyDetails,
        ]);
    }
    private function validateCSVHeader($csvHeader, $staticHeader)
    {
        $result = false;
        if (count($csvHeader) != count($staticHeader)) {
            $result = true;
        } else {
            for ($i = 0; $i < count($staticHeader); $i++) {
                if ($staticHeader[$i] != $csvHeader[$i]) {
                    $result = true;
                    break;
                }
            }
        }
        return $result;
    }
    public function importDealerAndDistributor(Request $request)
    {
        $file = $request->file('file');
        $uploadAndGetData = $this->readCSVController->uploadAndGetData($file);
        unlink($uploadAndGetData['filename']);
        // dd($uploadAndGetData);
        if ($request->agencyType == 1) {
            $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$dealerArray);
        } else {
            $validateCSVFIle = $this->validateCSVHeader($uploadAndGetData['header'], StaticArray::$distributorrArray);
        }

        if ($validateCSVFIle) {
            return response()->json([
                'code' => 200,
                'message' => "Invalid CSV file uploaded",
            ]);
        }
        // dd($uploadAndGetData['data']);
        foreach ($uploadAndGetData['data'] as $value) {
            $agencyMobile = $value['Mobile'];
            $count = Agency::where('agencyMobile', $agencyMobile)->count();
            if (!$count) {
                
                $agency = new Agency();
                $agencyDetial = new AgencyDetail();
                $distributor = '';
                if ($request->agencyType == 1) {
                    $getDistributor = Agency::where('agencyMobile', $value['Distributor'])
                        ->get()
                        ->toArray();
                    $distributor = count($getDistributor) > 0 ? $getDistributor[0]['agencyId'] : '';
                }

                $agencyRegion = $value['Region'];
                $category = Category::where('category_name', $agencyRegion)->first();
                if ($category) {
                    $agencyRegionId = $category->category_id;
                } else {
                    $agencyRegionId = 0;
                }

                //Add into table Agency
                $agency->agencyName = $value['AgencyName'];
                $agency->agencyShopName = $value['ShopName'];
                $agency->agencyMobile = $value['Mobile'];
                $agency->agencyAltNumber = $value['AlternateNumber'];
                $agency->agencyEmail = $value['Email'];
                $agency->agencyAddress = $value['Address'];
                $agency->agencyState = $value['State'];
                $agency->agencyDistrict = $value['Disctrict'];
                $agency->agencyThesil = $value['VillageName'];
                $agency->agencyCity = $value['City'];
                $agency->agencyPincode = $value['Pincode'];
                $agency->agencyRegion = $agencyRegionId;
                $agency->agencyDistributor = $distributor;
                if ($request->agencyType == 2) {
                    $agency->distributorCode = $value['DistributorCode'];
                }
                $agency->agencyType = $request->agencyType;
                $agency->pan = $value['PAN'];
                $agency->gst = $value['GST'];
                $agency->licence1 = $value['Licence1'];
                $agency->licence2 = $value['Licence2'];
                $agency->licence3 = $value['Licence3'];
                $agency->bank_name = $value['BankName'];
                $agency->account_no = $value['AccountNumber'];
                $agency->branch_name = $value['BranchName'];
                $agency->ifsc_code = $value['IFSCCode'];
                $agency->designation = $value['Designation'];
                $agency->dateOfBirth = date_format(date_create($value['DOB']), "Y/m/d");
                $agency->anniversaryDate = date_format(date_create($value['AnniversaryDate']), "Y/m/d");
                $agency->associate_since = date_format(date_create($value['AssociateSince']), "Y/m/d");
                $agency->handling_business_since = date_format(date_create($value['HandlingBussinessSince']), "Y/m/d");
                $agency->CreditLimit = $value['CreditLimit'];
                $agency->save();
 
                //Add into Agency Details Table
                $agencyDetial->agencyId = $agency->id;
                $agencyDetial->agencyTurnover = $value['AgencyTurnover'];
                $agencyDetial->agencyHerbicidePer = $value['HerbicidePer'];
                $agencyDetial->agencyInsecticidePer = $value['InsecticidePer'];
                $agencyDetial->delaerFungicidePer = $value['FungicidePer'];
                $agencyDetial->sealerPgrPer = $value['PgrPercent'];
                $agencyDetial->agencyGAPLTurnover = $value['GAVLTurnover'];
                $agencyDetial->agencyGAPLHerbicidePer = $value['GAVLHerbicidePer'];
                $agencyDetial->agencyGAPLInsecticidePer = $value['GAPLInsecticidePer'];
                $agencyDetial->delaerGAPLFungicidePer = $value['GAVLFungicidePer'];
                $agencyDetial->sealerGAPLPgrPer = $value['GAVLPgrPer'];
                $agencyDetial->agencyFirstCompanyName = $value['FirstCompanyName'];
                $agencyDetial->agencyFirstCompanyTr = $value['FirstCompanyTr'];
                $agencyDetial->agencySecCompanyName = $value['SecCompanyName'];
                $agencyDetial->agencySecCompanyTr = $value['SecCompanyTr'];
                $agencyDetial->agencyThCompanyName = $value['ThirdCompanyName'];
                $agencyDetial->agencyThCompanyTr = $value['ThirdCompanyTr'];
                $agencyDetial->agencyCreditLimit = $value['CreditLimit'];
                $agencyDetial->noOfRetailers = $value['NoOfFarmer'];
                $agencyDetial->save();
            }
        }

        
        return response()->json([
            'code' => 200,
            'message' => "CSV file uploaded successfully",
        ]);
    }
    public function getAllDistributor()
    {
        $agency = Agency::select('agencyId', DB::raw("CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'agencyRegion')
            ->where('agencyType', 2)
            ->get()
            ->toArray();
        $getCategory = DB::table('tbl_category')
            ->get()
            ->pluck('category_name', 'category_id')
            ->toArray();

        $dataArray = [];
        foreach ($agency as $value) {
            $value['agencyRegion'] = array_key_exists($value['agencyRegion'], $getCategory) ? $getCategory[$value['agencyRegion']] : '';

            array_push($dataArray, $value);
        }

        return response()->json([
            'code' => 200,
            'data' => $dataArray,
        ]);
    }
}
