<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\AvPurpose;
use App\Models\UpdateKeyNew;

class AVPurposeController extends Controller
{
    public function submitAvpurpose(Request $request)
    {
        if ($request->id) {
          $this->updateAVPurpose($request);
        } else {
            try {
                $avpurposeData = new AvPurpose();
                $avpurposeData->purpose_agencyVisit_name = $request->avpurpose_name;
                $avpurposeData->avpurpose_status = $request->avpurpose_status;
                $avpurposeData->deleteFlag = 0;
                $avpurposeData->save();

                $id = 1;
                $updateKey = UpdateKeyNew::find($id);
                $updateKey->agencyVisitPurposeList += 1;
                $updateKey->save();

                return response()->json([
                    'code' => 200,
                    'message' => "Data Save successfully",
                ]);
            } catch (\Exception $e) {
                return response()->json([
                    'error' => $e->getMessage(),
                    'code' => 500,
                    'message' => "Something went wrong while saving data",
                ]);
            }
        }
    }

   public function getAvpurpose(Request $request)
{
    try {
        $result = DB::table('tbl_purpose_agencyvisit as tfm');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('tfm.purpose_agencyVisit_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result->where('deleteFlag', false)->orderBy('created_at', 'desc');

        if ($request->paginate == "true") {
            $result = $result->select('tfm.*');
        } else {
            $result = $result->select('tfm.*');
        }

        // Get the total record count
        $totalCount = $result->count();

        // Handle pagination
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "AV Purpose fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include total record count in the response
        ]);
    } catch (\Exception $e) {
        // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while fetching data",
        ]);
    }
}

    // public function deleteAvpurpose(Request $request)
    // {
    //     try {
    //         $avpurposeData = AvPurpose::find($request->id);
    //         $avpurposeData->deleteFlag = 1;
    //         $avpurposeData->save();

    //         return response()->json([
    //             'code' => 200,
    //             'message' => "AV Purpose deleted successfully",
    //         ]);
    //     } catch (\Exception $e) {
    //         return response()->json([
    //             'code' => 500,
    //             'message' => "Something went wrong while deleting crop",
    //         ]);
    //     }
    // }
    public function deleteAvpurpose(Request $request)
{
    try {
        $avpurposeData = AvPurpose::where('purpose_agencyVisit_id', $request->input('id'))
                        ->update(['deleteFlag' => true]);

        if ( $avpurposeData) {
            return response()->json([
                'code' => 200,
                'message' => "AV Purpose successfully"
            ]);
        } else {
            return response()->json([
                'code' => 404,
                'message' => "AV Purpose not found"
            ]);
        }
    } catch (\Exception $e) {
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while deleting purpose: " . $e->getMessage()
        ]);
    }
}


    private function updateAVPurpose($request) {
    try {
        AvPurpose::where('purpose_agencyVisit_id', $request->id)
            ->update([
                'purpose_agencyVisit_name' => $request->avpurpose_name,
                'avpurpose_status' => $request->avpurpose_status              
            ]);
        return response()->json([
            'code' => 200,
            'message' => "AV Purpose updated successfully",
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'code' => 500,
            'message' => "Something went wrong while updating AV Purpose",
        ]);
    }
}

}
